/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.DateUtils;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormModuleService;
import com.chinaj.engine.form.api.IFormTemplateModuleRelService;
import com.chinaj.engine.form.api.IFormTemplateService;
import com.chinaj.engine.form.api.busi.IFormBusinessCompService;
import com.chinaj.engine.form.api.busi.IFormPageCompService;
import com.chinaj.engine.form.domain.FormPageComp;
import com.chinaj.engine.form.domain.FormTemplate;
import com.chinaj.engine.form.domain.FormTemplateModuleRel;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formPageCompService")
@Transactional(rollbackFor={Exception.class})
public class FormPageCompServiceImpl
implements IFormPageCompService {
    private static final Logger log = LoggerFactory.getLogger(FormPageCompServiceImpl.class);
    @Autowired
    private IFormTemplateService formTemplateService;
    @Autowired
    private IFormTemplateModuleRelService formTemplateModuleRelService;
    @Autowired
    private IFormBusinessCompService formBusinessCompService;
    @Autowired
    private IFormModuleService formModuleService;

    @Override
    public String getBusinessCompId(Long id) {
        StringBuilder sb = new StringBuilder();
        FormTemplateModuleRel formTemplateModuleRel = new FormTemplateModuleRel();
        formTemplateModuleRel.setTmplId(id);
        List<FormTemplateModuleRel> list = this.formTemplateModuleRelService.selectFormTemplateModuleRelList(formTemplateModuleRel);
        if (StringUtils.isNotEmpty(list)) {
            for (FormTemplateModuleRel rel : list) {
                sb.append(rel.getModuleId()).append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public JSONArray list(String data) {
        return null;
    }

    @Override
    public JSONArray getPageCompType() {
        JSONArray array = new JSONArray();
        FormTemplate template = new FormTemplate();
        List<FormTemplate> formTemplates = this.formTemplateService.selectFormTemplateList(template);
        if (StringUtils.isNotEmpty(formTemplates)) {
            for (FormTemplate formTemplate : formTemplates) {
                JSONObject obj = new JSONObject();
                obj.put("value", (Object)formTemplate.getId());
                obj.put("label", (Object)formTemplate.getTmplName());
                array.add((Object)obj);
            }
        }
        return array;
    }

    @Override
    public JSONArray listPageComps(String data) {
        List<FormPageComp> formPageComps;
        String categoryCode;
        String serviceTypeCode;
        JSONArray array = new JSONArray();
        FormPageComp formPageComp = new FormPageComp();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        String pageCompName = jsonObject.getString("pageCompName");
        if (StringUtils.isNotEmpty((String)pageCompName)) {
            formPageComp.setTmplName(pageCompName);
        }
        if (StringUtils.isNotEmpty((String)(serviceTypeCode = jsonObject.getString("serviceTypeCode")))) {
            formPageComp.setServiceTypeCode(serviceTypeCode);
        }
        if (StringUtils.isNotEmpty((String)(categoryCode = jsonObject.getString("categoryCode")))) {
            formPageComp.setCategoryCode(categoryCode);
        }
        if (StringUtils.isNotEmpty(formPageComps = this.formTemplateService.listPageComps(formPageComp))) {
            for (FormPageComp prop : formPageComps) {
                JSONObject obj = new JSONObject();
                obj.put("templateId", (Object)prop.getId());
                obj.put("templateCode", (Object)prop.getTmplCode());
                obj.put("templateName", (Object)prop.getTmplName());
                obj.put("sceneNames", (Object)prop.getSceneName());
                obj.put("templateLevel", (Object)prop.getTmplLevel());
                obj.put("templateStatus", (Object)prop.getTmplStatus());
                Date gmtCreate = prop.getGmtCreate();
                if (!StringUtils.isEmpty((Object)gmtCreate)) {
                    obj.put("gmtCreate", (Object)DateUtils.dateTime((Date)gmtCreate));
                }
                array.add((Object)obj);
            }
        }
        return array;
    }

    @Override
    public JSONObject getPageComp(Long id) {
        JSONObject obj = new JSONObject();
        FormTemplate template = this.formTemplateService.selectFormTemplateById(id);
        obj.put("id", (Object)id);
        String tmplName = template.getTmplName();
        obj.put("text", (Object)tmplName);
        String tmplCode = template.getTmplCode();
        obj.put("name", (Object)tmplCode);
        obj.put("compType", (Object)"template");
        JSONObject schema = new JSONObject();
        schema.put("title", (Object)tmplName);
        schema.put("type", (Object)tmplName);
        List<FormTemplateModuleRel> list = this.formTemplateModuleRelService.selectParentFormTemplateModuleRelByTmplId(id);
        if (StringUtils.isNotEmpty(list)) {
            JSONArray jsonArray = new JSONArray();
            for (FormTemplateModuleRel rel : list) {
                Long moduleId = rel.getModuleId();
                JSONObject businessComp = this.formBusinessCompService.getBusinessComp(moduleId);
                JSONObject object = businessComp.getJSONObject("schema");
                jsonArray.add((Object)object);
            }
            schema.put("properties", (Object)jsonArray);
        }
        obj.put("schema", (Object)schema);
        obj.put("setting", (Object)schema);
        return obj;
    }

    @Override
    public JSONObject updatePageComp(String data) {
        return null;
    }

    @Override
    public JSONObject deletePageComp(Long id) {
        JSONObject obj = new JSONObject();
        FormTemplate template = this.formTemplateService.selectFormTemplateById(id);
        obj.put("", (Object)template.getId());
        return obj;
    }

    @Override
    public JSONObject copyPageComp(Long id) {
        JSONObject obj = new JSONObject();
        FormTemplate template = this.formTemplateService.selectFormTemplateById(id);
        obj.put("", (Object)template.getId());
        return obj;
    }

    @Override
    public JSONObject deployPageComp(Long id) {
        JSONObject obj = new JSONObject();
        FormTemplate template = this.formTemplateService.selectFormTemplateById(id);
        obj.put("", (Object)template.getId());
        return obj;
    }
}

