/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormModuleService;
import com.chinaj.engine.form.api.busi.IFormSaveModuleService;
import com.chinaj.engine.form.api.busi.IFormSavePropConfigService;
import com.chinaj.engine.form.api.busi.IFormSaveTemplateModuleRelService;
import com.chinaj.engine.form.domain.FormModule;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formSaveModuleService")
@Transactional(rollbackFor={Exception.class})
public class FormSaveModuleServiceImpl
implements IFormSaveModuleService {
    private static final Logger log = LoggerFactory.getLogger(FormSaveModuleServiceImpl.class);
    @Autowired
    private IFormModuleService formModuleService;
    @Autowired
    private IFormSavePropConfigService formSavePropConfigService;
    @Autowired
    private IFormSaveTemplateModuleRelService formSaveTemplateModuleRelService;

    @Override
    public void saveModule(JSONObject properties, JSONObject json, AtomicInteger status) {
        AtomicInteger sequence = new AtomicInteger();
        properties.forEach((moduleKey, moduleValue) -> this.dealModule((String)moduleKey, JSONObject.toJSONString((Object)moduleValue), status, sequence, json));
    }

    @Override
    public void dealModule(String moduleKey, String moduleValue, AtomicInteger status, AtomicInteger sequence, JSONObject json) {
        int i;
        sequence.getAndIncrement();
        JSONObject moduleProperty = JSONObject.parseObject((String)moduleValue);
        String moduleTitle = moduleProperty.getString("title");
        String moduleId = moduleProperty.getString("moduleId");
        FormModule module = new FormModule();
        module.setModuleCode(moduleKey);
        module.setModuleName(moduleTitle);
        if (StringUtils.isNotEmpty((String)moduleId)) {
            i = this.formModuleService.updateFormModule(module);
            status.set(i);
        } else {
            i = this.formModuleService.insertFormModule(module);
            status.set(i);
            if (i > 0) {
                moduleId = String.valueOf(module.getId());
                json.put("tmplSequence", (Object)sequence.get());
                this.formSaveTemplateModuleRelService.saveTemplateModuleRel(moduleProperty, json, status);
            }
        }
        json.put("moduleId", (Object)moduleId);
        JSONObject propProperties = moduleProperty.getJSONObject("properties");
        this.formSavePropConfigService.savePropConfig(propProperties, json, status);
    }
}

