/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.api.busi.IFormSaveModulePropRelService;
import com.chinaj.engine.form.api.busi.IFormSaveModuleService;
import com.chinaj.engine.form.api.busi.IFormSavePropConfigService;
import com.chinaj.engine.form.domain.FormPropConfig;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formSavePropConfigService")
@Transactional(rollbackFor={Exception.class})
public class FormSavePropConfigServiceImpl
implements IFormSavePropConfigService {
    private static final Logger log = LoggerFactory.getLogger(FormSavePropConfigServiceImpl.class);
    @Autowired
    private IFormPropConfigService formPropConfigService;
    @Autowired
    private IFormSaveModuleService formSaveModuleService;
    @Autowired
    private IFormSaveModulePropRelService formSaveModulePropRelService;

    @Override
    public void savePropConfig(JSONObject properties, JSONObject json, AtomicInteger status) {
        AtomicInteger sequence = new AtomicInteger();
        properties.forEach((propKey, propValue) -> {
            JSONObject proppProperty = JSONObject.parseObject((String)JSONObject.toJSONString((Object)propValue));
            String compType = proppProperty.getString("compType");
            if ("prop".equals(compType)) {
                this.dealPropCondig((String)propKey, proppProperty, status, sequence, json);
            } else {
                this.formSaveModuleService.dealModule((String)propKey, JSONObject.toJSONString((Object)propValue), status, sequence, json);
            }
        });
    }

    @Override
    public void dealPropCondig(String propKey, JSONObject proppProperty, AtomicInteger status, AtomicInteger sequence, JSONObject json) {
        sequence.getAndIncrement();
        String propId = proppProperty.getString("propId");
        String propTitle = proppProperty.getString("title");
        String htmlType = proppProperty.getString("ui:widget");
        FormPropConfig config = new FormPropConfig();
        config.setPropCode(propKey);
        config.setPropName(propTitle);
        config.setHtmlType(htmlType);
        if (StringUtils.isNotEmpty((String)propId)) {
            int i = this.formPropConfigService.updateFormPropConfig(config);
            status.set(i);
        } else {
            int i = this.formPropConfigService.insertFormPropConfig(config);
            status.set(i);
            if (i > 0) {
                propId = String.valueOf(config.getId());
            }
            json.put("propId", (Object)propId);
            json.put("propSequence", (Object)sequence.get());
            this.formSaveModulePropRelService.saveModulePropRel(proppProperty, json, status);
        }
    }
}

