/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormTemplateService;
import com.chinaj.engine.form.api.busi.IFormSaveModuleService;
import com.chinaj.engine.form.api.busi.IFormSaveTemplateService;
import com.chinaj.engine.form.domain.FormTemplate;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formSaveTemplageService")
@Transactional(rollbackFor={Exception.class})
public class FormSaveTemplateServiceImpl
implements IFormSaveTemplateService {
    private static final Logger log = LoggerFactory.getLogger(FormSaveTemplateServiceImpl.class);
    @Autowired
    private IFormTemplateService formTemplateService;
    @Autowired
    private IFormSaveModuleService formSaveModuleService;

    @Override
    public void saveTemplate(JSONObject properties, JSONObject json, AtomicInteger status) {
        FormTemplate template = new FormTemplate();
        String templateId = properties.getString("templateId");
        String title = properties.getString("title");
        template.setTmplName(title);
        try {
            int i;
            if (StringUtils.isNotEmpty((String)templateId)) {
                i = this.formTemplateService.updateFormTemplate(template);
                status.set(i);
                if (i > 0) {
                    json.put("templateId", (Object)templateId);
                }
            } else {
                i = this.formTemplateService.insertFormTemplate(template);
                status.set(i);
                if (i > 0) {
                    templateId = String.valueOf(template.getId());
                    json.put("templateId", (Object)templateId);
                }
            }
            JSONObject moduleProperties = properties.getJSONObject("properties");
            if (StringUtils.isNotEmpty((Map)moduleProperties)) {
                this.formSaveModuleService.saveModule(moduleProperties, json, status);
            }
        }
        catch (Exception e) {
            log.warn("\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff1a{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }
}

