/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.DateUtils;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormSceneService;
import com.chinaj.engine.form.api.busi.IFormSceneBusiService;
import com.chinaj.engine.form.domain.FormScene;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formSceneService")
@Transactional(rollbackFor={Exception.class})
public class FormSceneBusiServiceImpl
implements IFormSceneBusiService {
    @Autowired
    private IFormSceneService formSceneService;

    @Override
    public JSONArray listScenes(String data) {
        List<FormScene> formScenes;
        String categoryCode;
        String serviceTypeCode;
        JSONArray array = new JSONArray();
        FormScene formScene = new FormScene();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        String sceneName = jsonObject.getString("sceneName");
        if (StringUtils.isNotEmpty((String)sceneName)) {
            formScene.setSceneName(sceneName);
        }
        if (StringUtils.isNotEmpty((String)(serviceTypeCode = jsonObject.getString("serviceTypeCode")))) {
            formScene.setServiceTypeCode(serviceTypeCode);
        }
        if (StringUtils.isNotEmpty((String)(categoryCode = jsonObject.getString("categoryCode")))) {
            formScene.setCategoryCode(categoryCode);
        }
        if (StringUtils.isNotEmpty(formScenes = this.formSceneService.selectFormSceneList(formScene))) {
            for (FormScene prop : formScenes) {
                JSONObject obj = new JSONObject();
                obj.put("sceneId", (Object)prop.getId());
                obj.put("sceneCode", (Object)prop.getSceneCode());
                obj.put("sceneName", (Object)prop.getSceneName());
                obj.put("sceneLevel", (Object)prop.getSceneLevel());
                obj.put("sceneStatus", (Object)prop.getSceneStatus());
                Date gmtCreate = prop.getGmtCreate();
                if (!StringUtils.isEmpty((Object)gmtCreate)) {
                    obj.put("gmtCreate", (Object)DateUtils.dateTime());
                }
                array.add((Object)obj);
            }
        }
        return array;
    }

    @Override
    public JSONObject getScene(Long id) {
        JSONObject obj = new JSONObject();
        FormScene formScene = this.formSceneService.selectFormSceneById(id);
        obj.put("id", (Object)id);
        return obj;
    }

    @Override
    public JSONObject saveScene(String data) {
        return null;
    }

    @Override
    public JSONObject updateScene(String data) {
        return null;
    }

    @Override
    public JSONObject deleteScene(Long id) {
        JSONObject obj = new JSONObject();
        FormScene formScene = this.formSceneService.selectFormSceneById(id);
        obj.put("", (Object)formScene.getId());
        return obj;
    }

    @Override
    public JSONObject copyScene(Long id) {
        JSONObject obj = new JSONObject();
        FormScene formScene = this.formSceneService.selectFormSceneById(id);
        obj.put("", (Object)formScene.getId());
        return obj;
    }

    @Override
    public JSONObject deployScene(Long id) {
        JSONObject obj = new JSONObject();
        FormScene formScene = this.formSceneService.selectFormSceneById(id);
        obj.put("", (Object)formScene.getId());
        return obj;
    }
}

