/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormModulePropRelService;
import com.chinaj.engine.form.api.IFormModuleService;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.api.busi.IFormUpdateBusinessCompService;
import com.chinaj.engine.form.domain.FormModule;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formUpdateBusinessCompService")
@Transactional(rollbackFor={Exception.class})
public class FormUpdateBusinessCompServiceImpl
implements IFormUpdateBusinessCompService {
    private static final Logger log = LoggerFactory.getLogger(FormUpdateBusinessCompServiceImpl.class);
    @Autowired
    private IFormPropConfigService formPropConfigService;
    @Autowired
    private IFormModuleService formModuleService;
    @Autowired
    private IFormModulePropRelService formModulePropRelService;

    @Override
    public JSONObject updateBusinessComp(String data) {
        JSONObject json = new JSONObject();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        AtomicInteger status = new AtomicInteger(1);
        json.put("status", (Object)status.get());
        try {
            JSONObject moduleProperties = jsonObject.getJSONObject("properties");
            if (StringUtils.isNotEmpty((Map)moduleProperties)) {
                moduleProperties.forEach((moduleKey, moduleValue) -> this.dealModule((String)moduleKey, JSONObject.toJSONString((Object)moduleValue), status));
                if (status.get() < 0) {
                    json.put("status", (Object)status.get());
                    return json;
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4e1a\u52a1\u7ec4\u4ef6\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return json;
    }

    public void dealModule(String moduleKey, String moduleValue, AtomicInteger status) {
        JSONObject moduleProperty = JSONObject.parseObject((String)moduleValue);
        String moduleTitle = moduleProperty.getString("title");
        String moduleId = moduleProperty.getString("moduleId");
        FormModule module = new FormModule();
        module.setModuleCode(moduleKey);
        module.setModuleName(moduleTitle);
        if (StringUtils.isNotEmpty((String)moduleId)) {
            status.set(this.formModuleService.updateFormModule(module));
        } else {
            int i = this.formModuleService.insertFormModule(module);
            if (i > 0) {
                moduleId = String.valueOf(module.getId());
            }
        }
        JSONObject propProperties = moduleProperty.getJSONObject("properties");
        String finalModuleId = moduleId;
        AtomicInteger sequence = new AtomicInteger();
        propProperties.forEach((propKey, propValue) -> {
            JSONObject proppProperty = JSONObject.parseObject((String)JSONObject.toJSONString((Object)propValue));
            String compType = proppProperty.getString("compType");
            if ("prop".equals(compType)) {
                this.dealPropCondig((String)propKey, proppProperty, status, sequence, finalModuleId);
            } else {
                this.dealModule((String)propKey, JSONObject.toJSONString((Object)propValue), status);
            }
        });
    }

    public void dealPropCondig(String propKey, JSONObject proppProperty, AtomicInteger status, AtomicInteger sequence, String finalModuleId) {
        sequence.getAndIncrement();
        String propId = proppProperty.getString("propId");
        String propTitle = proppProperty.getString("title");
        String htmlType = proppProperty.getString("ui:widget");
        FormPropConfig config = new FormPropConfig();
        config.setPropCode(propKey);
        config.setPropName(propTitle);
        config.setHtmlType(htmlType);
        if (StringUtils.isNotEmpty((String)propId)) {
            status.set(this.formPropConfigService.updateFormPropConfig(config));
        } else {
            int i = this.formPropConfigService.insertFormPropConfig(config);
            if (i > 0) {
                propId = String.valueOf(config.getId());
            }
            this.dealModulePropRel(finalModuleId, propId, status, sequence);
        }
    }

    public void dealModulePropRel(String finalModuleId, String propId, AtomicInteger status, AtomicInteger sequence) {
        FormModulePropRel rel = new FormModulePropRel();
        rel.setModuleId(Long.valueOf(finalModuleId));
        rel.setPropId(Long.valueOf(propId));
        rel.setSequence(sequence.get());
        status.set(this.formModulePropRelService.insertFormModulePropRel(rel));
    }
}

