/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.good;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.bitf.rpc.api.goods.BitfGoodsService;
import com.chinaj.common.core.redis.RedisCache;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IBuildGoodAttrsService;
import com.chinaj.engine.form.domain.FormAtomicComp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BuildGoodAttrsServiceImpl
implements IBuildGoodAttrsService {
    private static final Logger log = LoggerFactory.getLogger(BuildGoodAttrsServiceImpl.class);
    @Autowired(required=false)
    private BitfGoodsService bitfGoodsService;
    @Autowired
    private RedisCache redisCache;

    @Override
    public JSONObject findAllGoodAttrs(String goodsSku) {
        JSONObject goodsJsonData = new JSONObject();
        if (StringUtils.isNotEmpty((String)goodsSku)) {
            String redisKey = "GOOD_ATTRS_" + goodsSku;
            String goodsData = (String)this.redisCache.getCacheObject(redisKey);
            if (StringUtils.isEmpty((String)goodsData)) {
                JSONObject goodsInfo = this.getGoodInfo(goodsSku);
                try {
                    String goodsType = goodsInfo.getString("goodsType");
                    if ("single".equals(goodsType)) {
                        this.findSingleGoodAttr(goodsInfo, goodsJsonData);
                    } else if ("sale".equals(goodsType)) {
                        this.findSaleGoodAttr(goodsInfo, goodsJsonData);
                    } else {
                        this.findOtherGoodAttr(goodsInfo, goodsJsonData);
                    }
                    this.redisCache.setCacheObject(redisKey, (Object)goodsJsonData.toJSONString(), Integer.valueOf(1), TimeUnit.DAYS);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u5546\u54c1\u5c5e\u6027\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getLocalizedMessage(), (Object)e);
                }
            } else {
                goodsJsonData = JSON.parseObject((String)goodsData);
            }
        }
        return goodsJsonData;
    }

    @Override
    public Map<String, String> getValueLabelMapByType(String goodsSku, String attrCode) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        try {
            JSONObject jsonObject;
            JSONArray dictData;
            JSONObject allGoodAttrs = this.findAllGoodAttrs(goodsSku);
            Object object = allGoodAttrs.get((Object)attrCode);
            if (object instanceof JSONObject && StringUtils.isNotEmpty((Collection)(dictData = (jsonObject = (JSONObject)object).getJSONArray("dictData")))) {
                for (int i = 0; i < dictData.size(); ++i) {
                    JSONObject dictJson = dictData.getJSONObject(i);
                    map.put(dictJson.getString("value"), dictJson.getString("label"));
                }
            }
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u4e0b\u62c9\u6846\u5c5e\u6027 ValueToLabel \u5931\u8d25\uff01{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return map;
    }

    @Override
    public JSONObject getGoodInfo(String goodSku) {
        JSONObject data;
        String goodStr = "";
        try {
            goodStr = this.bitfGoodsService.getGoodsKeyDetail(goodSku);
        }
        catch (Exception e) {
            log.error("goodSku:{},\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}{}{}", new Object[]{goodSku, e.getLocalizedMessage(), e});
        }
        JSONObject jsonObject = JSONObject.parseObject((String)goodStr);
        JSONObject resultJson = new JSONObject();
        if (Boolean.TRUE.equals(jsonObject.getBoolean("flag")) && StringUtils.isNotEmpty((Map)(data = jsonObject.getJSONObject("data")))) {
            resultJson = data;
        }
        return resultJson;
    }

    public void dealAttrs(JSONArray attrValues, String attrCode, JSONObject prodAttrs, JSONObject productAttr) {
        JSONArray dictData = new JSONArray();
        for (int n = 0; n < attrValues.size(); ++n) {
            JSONObject attrValue = attrValues.getJSONObject(n);
            JSONObject attrEnum = new JSONObject();
            attrEnum.put("label", (Object)attrValue.getString("valueName"));
            attrEnum.put("value", (Object)attrValue.getString("valueCode"));
            dictData.add((Object)attrEnum);
        }
        boolean containsKey = prodAttrs.containsKey((Object)attrCode);
        if (!containsKey) {
            JSONObject attrsData = new JSONObject();
            attrsData.put("defaultVal", (Object)productAttr.getString("attrValCodes"));
            attrsData.put("dictData", (Object)dictData);
            prodAttrs.put(attrCode, (Object)attrsData);
        }
    }

    private void findSingleGoodAttr(JSONObject goodsInfo, JSONObject prodAttrs) {
        JSONArray productCategory = goodsInfo.getJSONArray("productCategroy");
        JSONArray array = new JSONArray();
        for (int i = 0; i < productCategory.size(); ++i) {
            JSONObject prod = productCategory.getJSONObject(i);
            JSONArray products = prod.getJSONArray("products");
            for (int j = 0; j < products.size(); ++j) {
                FormAtomicComp atomicComp = new FormAtomicComp();
                JSONObject product = products.getJSONObject(j);
                JSONArray productAttrs = product.getJSONArray("productAttrs");
                if (!StringUtils.isNotEmpty((Collection)productAttrs)) continue;
                for (int m = 0; m < productAttrs.size(); ++m) {
                    JSONObject productAttr = productAttrs.getJSONObject(m);
                    JSONArray attrValues = productAttr.getJSONArray("attrValues");
                    String attrValCodes = productAttr.getString("attrValCodes");
                    String attrCode = productAttr.getString("attrCode");
                    String attrName = productAttr.getString("attrName");
                    String valueType = productAttr.getString("valueType");
                    if ("OPTIONS".equals(valueType) && StringUtils.isNotEmpty((Collection)attrValues)) {
                        this.dealAttrs(attrValues, attrCode, prodAttrs, productAttr);
                        atomicComp.setPropType("select");
                    } else if ("INPUT".equals(valueType) && StringUtils.isNotEmpty((String)attrValCodes)) {
                        prodAttrs.put(attrCode, (Object)attrValCodes);
                        atomicComp.setPropType(valueType);
                    } else {
                        atomicComp.setPropType(valueType);
                        prodAttrs.put(attrCode, (Object)attrValCodes);
                    }
                    atomicComp.setPropCode(attrCode);
                    atomicComp.setPropName(attrName);
                    atomicComp.setPropSource("good");
                    atomicComp.setPropStatus("01");
                    atomicComp.setGmtCreate(new Date());
                    array.add((Object)atomicComp);
                }
            }
        }
        prodAttrs.put("array", (Object)array);
    }

    private void findSaleGoodAttr(JSONObject goodsInfo, JSONObject prodAttrs) {
        JSONArray keyAttrs = goodsInfo.getJSONArray("keyAttrs");
        for (int i = 0; i < keyAttrs.size(); ++i) {
            JSONObject keyAttr = keyAttrs.getJSONObject(i);
            JSONArray attrValues = keyAttr.getJSONArray("attrValues");
            String attrCode = keyAttr.getString("attrCode");
            String valueType = keyAttr.getString("valueType");
            if (StringUtils.isEmpty((String)valueType) && StringUtils.isNotEmpty((Collection)attrValues)) {
                valueType = "OPTIONS";
            }
            if ("OPTIONS".equals(valueType)) {
                this.dealAttrs(attrValues, attrCode, prodAttrs, keyAttr);
                continue;
            }
            if (!"INPUT".equals(valueType) || !StringUtils.isNotEmpty((Collection)attrValues)) continue;
            String value = attrValues.getString(0);
            prodAttrs.put(attrCode, (Object)value);
        }
        JSONArray saleGoods = goodsInfo.getJSONArray("saleGoods");
        for (int i = 0; i < saleGoods.size(); ++i) {
            JSONObject goodObj = saleGoods.getJSONObject(i);
            String goodSku = goodObj.getString("goodsSku");
            JSONObject goodInfo = this.getGoodInfo(goodSku);
            if (!"single".equals(goodInfo.getString("goodsType"))) continue;
            this.findSingleGoodAttr(goodInfo, prodAttrs);
        }
    }

    private void findOtherGoodAttr(JSONObject goodsInfo, JSONObject prodAttrs) {
        JSONArray goodsCategroy = goodsInfo.getJSONArray("goodsCategroy");
        for (int i = 0; i < goodsCategroy.size(); ++i) {
            JSONObject goodCate = goodsCategroy.getJSONObject(i);
            JSONArray goods = goodCate.getJSONArray("goods");
            for (int j = 0; j < goods.size(); ++j) {
                JSONObject good2 = goods.getJSONObject(j);
                JSONArray goodsAttrs = good2.getJSONArray("goodsAttrs");
                if (!StringUtils.isNotEmpty((Collection)goodsAttrs) || goodsAttrs.isEmpty()) continue;
                for (int m = 0; m < goodsAttrs.size(); ++m) {
                    JSONObject productAttr = goodsAttrs.getJSONObject(m);
                    JSONArray attrValues = productAttr.getJSONArray("attrValues");
                    String attrValCodes = productAttr.getString("attrValCodes");
                    String attrCode = productAttr.getString("attrCode");
                    String valueType = productAttr.getString("valueType");
                    if ("OPTIONS".equals(valueType) && StringUtils.isNotEmpty((Collection)attrValues)) {
                        this.dealAttrs(attrValues, attrCode, prodAttrs, productAttr);
                        continue;
                    }
                    if (!"INPUT".equals(valueType) || !StringUtils.isNotEmpty((String)attrValCodes)) continue;
                    prodAttrs.put(attrCode, (Object)attrValCodes);
                }
            }
        }
    }
}

