/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common.aop;

import com.chinaj.common.core.domain.AjaxResult;
import com.chinaj.core.common.DesensitizationUtil;
import com.chinaj.core.common.annotations.DesenField;
import com.chinaj.core.common.annotations.Desensitize;
import com.chinaj.core.common.hoenum.DesensitizationType;
import java.lang.reflect.Field;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class Desensitization {
    private static final Logger log = LoggerFactory.getLogger(Desensitization.class);

    @Pointcut(value="@annotation(com.chinaj.core.common.annotations.Desensitize)|| @within(com.chinaj.core.common.annotations.Desensitize)")
    public void desensitizePointCut() {
    }

    @Pointcut(value="execution(* com.chinaj.*.controller..*(..))")
    private void controllerEndPoint() {
    }

    @Around(value="controllerEndPoint()")
    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        if (result instanceof AjaxResult) {
            AjaxResult res = (AjaxResult)result;
            this.process(res.get((Object)"data"));
        }
        return result;
    }

    private void process(Object obj) {
        Field[] fields;
        if (obj == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        if (cls.getAnnotation(Desensitize.class) == null) {
            return;
        }
        for (Field f : fields = cls.getDeclaredFields()) {
            f.setAccessible(true);
            DesenField df = f.getAnnotation(DesenField.class);
            if (df == null) continue;
            log.info("\u8131\u654f\u5b57\u6bb5:{};\u8131\u654f\u4f4d\u6570:{};\u8131\u654f\u7c7b\u578b:{}", new Object[]{f.getName(), df.type().getValue(), df.type().getDesc()});
            try {
                Object o = f.get(obj);
                if (!(o instanceof String)) continue;
                String s = (String)o;
                if (DesensitizationType.ID_CARD.equals(df.type())) {
                    f.set(obj, DesensitizationUtil.idEncrypt(s));
                }
                if (DesensitizationType.PASSPORT.equals(df.type())) {
                    f.set(obj, DesensitizationUtil.idPassport(s));
                }
                if (DesensitizationType.MOBILE.equals(df.type())) {
                    f.set(obj, DesensitizationUtil.mobileEncrypt(s));
                }
                if (DesensitizationType.OTHER_LEFT.equals(df.type())) {
                    f.set(obj, DesensitizationUtil.left(s, df.type().getValue()));
                }
                if (!DesensitizationType.OTHER_RIGHT.equals(df.type())) continue;
                f.set(obj, DesensitizationUtil.right(s, df.type().getValue()));
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

