/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common.crypt;

import cn.hutool.crypto.digest.BCrypt;
import com.chinaj.core.common.crypt.HoBCrypt;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HoBCryptPasswordEncoder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final int strength;
    private final BCryptVersion version;
    private final SecureRandom random;
    private Pattern BCRYPT_PATTERN = Pattern.compile("\\A\\$2(a|y|b)?\\$(\\d\\d)\\$[./0-9A-Za-z]{53}");

    public HoBCryptPasswordEncoder() {
        this(-1);
    }

    public HoBCryptPasswordEncoder(int strength) {
        this(strength, null);
    }

    public HoBCryptPasswordEncoder(BCryptVersion version) {
        this(version, null);
    }

    public HoBCryptPasswordEncoder(BCryptVersion version, SecureRandom random) {
        this(version, -1, random);
    }

    public HoBCryptPasswordEncoder(int strength, SecureRandom random) {
        this(BCryptVersion.$2A, strength, random);
    }

    public HoBCryptPasswordEncoder(BCryptVersion version, int strength) {
        this(version, strength, null);
    }

    public HoBCryptPasswordEncoder(BCryptVersion version, int strength, SecureRandom random) {
        if (strength != -1 && (strength < 4 || strength > 31)) {
            throw new IllegalArgumentException("Bad strength");
        }
        this.version = version;
        this.strength = strength == -1 ? 10 : strength;
        this.random = random;
    }

    public String encode(CharSequence rawPassword) {
        String salt = this.random != null ? HoBCrypt.gensalt(this.version.getVersion(), this.strength, this.random) : HoBCrypt.gensalt(this.version.getVersion(), this.strength);
        return BCrypt.hashpw((String)rawPassword.toString(), (String)salt);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (encodedPassword == null || encodedPassword.length() == 0) {
            this.logger.warn((Object)"Empty encoded password");
            return false;
        }
        if (!this.BCRYPT_PATTERN.matcher(encodedPassword).matches()) {
            this.logger.warn((Object)"Encoded password does not look like BCrypt");
            return false;
        }
        return BCrypt.checkpw((String)rawPassword.toString(), (String)encodedPassword);
    }

    public boolean upgradeEncoding(String encodedPassword) {
        if (encodedPassword == null || encodedPassword.length() == 0) {
            this.logger.warn((Object)"Empty encoded password");
            return false;
        }
        Matcher matcher = this.BCRYPT_PATTERN.matcher(encodedPassword);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Encoded password does not look like BCrypt: " + encodedPassword);
        }
        int strength = Integer.parseInt(matcher.group(2));
        return strength < this.strength;
    }

    public static enum BCryptVersion {
        $2A("$2a"),
        $2Y("$2y"),
        $2B("$2b");

        private final String version;

        private BCryptVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

