/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.core.domain.entity.SysUser;
import com.chinaj.common.core.domain.model.LoginUser;
import com.chinaj.core.common.RedisUtil;
import com.chinaj.core.common.crypt.HoBCryptPasswordEncoder;
import com.chinaj.core.common.jackson.HoSerializerModifier;
import com.chinaj.core.framework.TokenService;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;

@Component
public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    private static final HoBCryptPasswordEncoder hoBCryptPasswordEncoder = new HoBCryptPasswordEncoder();
    private static final String NULL_STRING = "";
    private static final Snowflake snowflake = IdUtil.createSnowflake((long)31L, (long)31L);
    @Resource
    private ObjectMapper mapper;
    @Resource
    private TokenService tokenService;
    @Resource
    private RedisUtil redis;

    public static String nrc() {
        return snowflake.nextIdStr();
    }

    public static boolean isNotBlank(String ss) {
        return StringUtils.isNotBlank((CharSequence)ss);
    }

    public static boolean isBlank(String ss) {
        return StringUtils.isBlank((CharSequence)ss);
    }

    public static String encryptPassword(String password) {
        return hoBCryptPasswordEncoder.encode(password);
    }

    public static boolean matchesPassword(String rawPassword, String encodedPassword) {
        return hoBCryptPasswordEncoder.matches(rawPassword, encodedPassword);
    }

    public static String getUsername(String token) {
        return token + "-anonymous";
    }

    public static boolean isEmpty(Object emptyObect) {
        boolean result = true;
        if (emptyObect == null) {
            return true;
        }
        result = emptyObect instanceof String ? emptyObect.toString().trim().length() == 0 || emptyObect.toString().trim().equals("null") : (emptyObect instanceof Collection ? ((Collection)emptyObect).size() == 0 : (emptyObect instanceof Object[] ? ((Object[])emptyObect).length == 0 : (emptyObect instanceof JSONObject ? ((JSONObject)emptyObect).isEmpty() : emptyObect == null || emptyObect.toString().trim().length() < 1)));
        return result;
    }

    public static boolean isNotEmpty(Object emptyObect) {
        return !CommonUtil.isEmpty(emptyObect);
    }

    public static String killNull(BigDecimal o) {
        return CommonUtil.killNull(o, NULL_STRING);
    }

    public static String killNull(Double o) {
        return CommonUtil.killNull(o, NULL_STRING);
    }

    public static String killNull(long o) {
        return String.valueOf(o);
    }

    public static String killNull(Long o) {
        return o == null ? NULL_STRING : String.valueOf(o);
    }

    public static String killNull(Object o) {
        return CommonUtil.killNull(o, NULL_STRING);
    }

    public static String killNull(Object o, String ds) {
        return o != null ? String.valueOf(o) : ds;
    }

    public static String getDateStrYYYYMMDDHH() {
        return CommonUtil.formatDate(new Date(), "yyyyMMddHH");
    }

    public static String getDateStrYYYYMMDD() {
        return CommonUtil.formatDate(new Date(), "yyyyMMdd");
    }

    public static String getDateStrYYYYMMDDHHmm() {
        return CommonUtil.formatDate(new Date(), "yyyyMMddHHmm");
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        if (date != null && !NULL_STRING.equals(date)) {
            return simpleDateFormat.format(date);
        }
        return null;
    }

    public static Date parseDate(String dateStr, String format) {
        try {
            if (dateStr == null || dateStr.equals(NULL_STRING)) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            return simpleDateFormat.parse(dateStr);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static Date parseDateFormat(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (str.length() == 6) {
            return CommonUtil.parseDate(str, "yyyyMM");
        }
        if (str.length() == 7) {
            return CommonUtil.parseDate(str, "yyyy-MM");
        }
        if (str.length() == 10) {
            return CommonUtil.parseDate(str, "yyyy-MM-dd");
        }
        if (str.length() == 9) {
            if (CommonUtil.parseDate(str, "yyyy-MM-d") == null) {
                return CommonUtil.parseDate(str, "yyyy-M-dd");
            }
            return CommonUtil.parseDate(str, "yyyy-MM-d");
        }
        if (str.length() == 8) {
            return CommonUtil.parseDate(str, "yyyy-M-d");
        }
        if (str.length() == 13) {
            return CommonUtil.parseDate(str, "yyyy-MM-dd HH");
        }
        if (str.length() == 14) {
            return CommonUtil.parseDate(str, "yyyyMMddHHmmss");
        }
        if (str.length() == 16) {
            return CommonUtil.parseDate(str, "yyyy-MM-dd HH:mm");
        }
        if (str.length() == 19) {
            return CommonUtil.parseDate(str, "yyyy-MM-dd HH:mm:ss");
        }
        if (str.length() >= 21) {
            return CommonUtil.parseDate(str, "yyyy-MM-dd HH:mm:ss.S");
        }
        return null;
    }

    public <T> T readValue(String content, Class<T> valueType) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(content, valueType);
        }
        catch (IOException e) {
            log.error("CommonUtil readValue", (Throwable)e);
            return null;
        }
    }

    public <T> T readValue(String content, TypeReference<T> valueTypeRef) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(content, valueTypeRef);
        }
        catch (IOException e) {
            log.error("Json\u8f6c\u6362\u5f02\u5e38:{}", (Object)content, (Object)e);
            return null;
        }
    }

    public String writeValueAsString(Object value, List<String> withoutAttributes) {
        ObjectWriter writer = this.mapper.writer();
        if (withoutAttributes != null) {
            for (String key : withoutAttributes) {
                writer.withoutAttribute((Object)key);
            }
        }
        try {
            return writer.writeValueAsString(value);
        }
        catch (Exception e) {
            log.error(NULL_STRING, (Throwable)e);
            return null;
        }
    }

    public String writeValueAsString(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            log.error(NULL_STRING, (Throwable)e);
            return null;
        }
    }

    public String writeValueAsString(Object value, boolean encode, String enc) {
        String result = NULL_STRING;
        try {
            String jsonStr = this.writeValueAsString(value);
            String encodeStr = encode ? URLEncoder.encode(jsonStr, enc) : jsonStr;
            result = StringUtils.isNotBlank((CharSequence)jsonStr) ? encodeStr : result;
        }
        catch (Exception e) {
            log.error("CommonUtil URLEncoder.encode", (Throwable)e);
        }
        return result;
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializerFactory(mapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new HoSerializerModifier()));
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return new MappingJackson2HttpMessageConverter(mapper);
    }

    public LoginUser getCurrLoginUser(HttpServletRequest request) {
        return this.tokenService.getLoginUser(request);
    }

    public SysUser geUser(HttpServletRequest request) {
        LoginUser loginUser = this.getCurrLoginUser(request);
        if (loginUser != null) {
            SysUser user = loginUser.getUser();
            if (user != null) {
                // empty if block
            }
            return user;
        }
        return null;
    }

    public SysUser getCurrLoginUserBySessionId(String sessionID) {
        return this.tokenService.getCurrLoginUserBySessionId(sessionID);
    }
}

