/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.security.filter;

import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;

public class MyAuthorizationFilter
extends AuthorizationFilter {
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        Subject subject;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setHeader("P3P", "CP=\"IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT\"");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String url = httpServletRequest.getRequestURI();
        if (url != null && url.endsWith(".html")) {
            httpResponse.setHeader("Cache-Control", "no-cache");
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setDateHeader("Expires", 0L);
        }
        if (!(subject = this.getSubject(request, response)).isAuthenticated()) {
            return false;
        }
        Object[] rolesArray = (String[])mappedValue;
        if (rolesArray == null || rolesArray.length == 0) {
            return true;
        }
        Set roles = CollectionUtils.asSet((Object[])rolesArray);
        for (String role : roles) {
            if (!subject.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Subject subject = this.getSubject(request, response);
        if (subject.getPrincipal() == null) {
            if (httpRequest.getHeader("X-Requested-With") != null && httpRequest.getHeader("X-Requested-With").equalsIgnoreCase("XMLHttpRequest")) {
                httpResponse.addHeader("sessionstatus", "timeout");
            } else {
                this.saveRequestAndRedirectToLogin(request, response);
            }
        } else if (httpRequest.getHeader("X-Requested-With") != null && httpRequest.getHeader("X-Requested-With").equalsIgnoreCase("XMLHttpRequest")) {
            httpResponse.addHeader("sessionstatus", "401");
        } else {
            String unauthorizedUrl = this.getUnauthorizedUrl();
            if (StringUtils.hasText((String)unauthorizedUrl)) {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)unauthorizedUrl);
            } else {
                WebUtils.toHttp((ServletResponse)response).sendError(401);
            }
        }
        return false;
    }
}

