/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.springframework.web.filter.OncePerRequestFilter;

public class SSOSaveSuccessUrlFilter
extends OncePerRequestFilter {
    private static final Log logger = LogFactory.getLog(SSOSaveSuccessUrlFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String uri = request.getRequestURI();
        if (uri.endsWith(".html") || uri.endsWith(".htm")) {
            Session session = SecurityUtils.getSubject().getSession();
            StringBuilder url = new StringBuilder(request.getRequestURI());
            if (request.getQueryString() != null) {
                url.append("?").append(request.getQueryString());
            }
            if (!url.toString().equals(request.getContextPath() + "/html/PlatForm.html")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sso_saved_success_url:" + url.toString()));
                }
                session.setAttribute((Object)"__sso_saved_success_url", (Object)url.toString());
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static final String getSuccessUrl() {
        Session session = SecurityUtils.getSubject().getSession();
        return (String)session.getAttribute((Object)"__sso_saved_success_url");
    }
}

