/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.security.realm;

import com.chinaunicom.cbss2.sc.manage.busi.entity.QueryGeniusUsedByAuthBusiService;
import com.chinaunicom.cbss2.sc.manage.busi.entity.QueryMainEntityUsedByAuthBusiService;
import com.chinaunicom.cbss2.sc.manage.busi.entity.QueryStoreUsedByAuthBusiService;
import com.chinaunicom.cbss2.sc.manage.busi.entity.bo.QueryGeniusUsedByAuthRspBO;
import com.chinaunicom.cbss2.sc.manage.busi.entity.bo.QueryMainEntityUsedByAuthRspBO;
import com.chinaunicom.cbss2.sc.manage.busi.entity.bo.QueryStoreListUsedByAuthRspBO;
import com.chinaunicom.number.security.realm.MenuInfo;
import com.chinaunicom.number.security.realm.MenuLayOut;
import com.chinaunicom.permission.bo.ReqInfoBO;
import com.chinaunicom.permission.busi.PermInfoService;
import com.chinaunicom.permission.busi.StaffInfoService;
import com.chinaunicom.permission.busi.UserCheckService;
import com.chinaunicom.permission.busi.bo.PermInfoBO;
import com.chinaunicom.permission.busi.bo.ReqHomePageByIdsBO;
import com.chinaunicom.permission.busi.bo.ReqPermsByStaffsBO;
import com.chinaunicom.permission.busi.bo.ReqStaffsByStaffIdsBO;
import com.chinaunicom.permission.busi.bo.ReqUserCheckBO;
import com.chinaunicom.permission.busi.bo.RspAuthMenuListBO;
import com.chinaunicom.permission.busi.bo.RspHomePageByIdsBO;
import com.chinaunicom.permission.busi.bo.RspPermsByCodesBO;
import com.chinaunicom.permission.busi.bo.RspPermsByStaffsBO;
import com.chinaunicom.permission.busi.bo.RspStaffsByStaffIdsBO;
import com.chinaunicom.permission.busi.bo.RspUserCheckBO;
import com.chinaunicom.permission.busi.bo.StaffInfoBO;
import com.chinaunicom.permission.busi.bo.StaffNoBO;
import com.ohaotian.base.cache.CacheService;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasAuthenticationException;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCasRealm
extends CasRealm {
    private static Logger log = LoggerFactory.getLogger(MyCasRealm.class);
    public static final Integer MENU_LEVEL_3 = 3;
    public static final String COMMON_MENU = "\u5e38\u7528\u83dc\u5355";
    private static final String MAIN_ENTITY = "MAIN_ENTITY";
    private static final String STORE_INFORMATION = "STORE_INFORMATION";
    private static final String GENIUS_ENTITY = "GENIUS_ENTITY";
    private StaffInfoService staffInfoService;
    private UserCheckService userCheckService;
    private CacheService cacheService;
    private PermInfoService permInfoService;
    private QueryMainEntityUsedByAuthBusiService queryMainEntityUsedByAuthBusiService;
    private QueryStoreUsedByAuthBusiService queryStoreUsedByAuthBusiService;
    private QueryGeniusUsedByAuthBusiService queryGeniusUsedByAuthBusiService;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        CasToken casToken = (CasToken)token;
        if (token == null) {
            return null;
        }
        String ticket = (String)casToken.getCredentials();
        if (!StringUtils.hasText((String)ticket)) {
            return null;
        }
        TicketValidator ticketValidator = this.ensureTicketValidator();
        try {
            Object mis;
            boolean isRemembered;
            Assertion casAssertion = ticketValidator.validate(ticket, this.getCasService());
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String userId = casPrincipal.getName();
            String loginname = userId.substring(3);
            ReqUserCheckBO userCheckBO = new ReqUserCheckBO();
            userCheckBO.setUserName(loginname);
            RspUserCheckBO rspUserCheckBO = this.userCheckService.checkVerifyByUsername(userCheckBO);
            if (rspUserCheckBO.isIdentifyingCode()) {
                userId = loginname;
            }
            log.debug("Validate ticket : {} in CAS server : {} to retrieve user : {}", new Object[]{ticket, this.getCasServerUrlPrefix(), userId});
            Map attributes = casPrincipal.getAttributes();
            casToken.setUserId(userId);
            String rememberMeAttributeName = this.getRememberMeAttributeName();
            String rememberMeStringValue = (String)attributes.get(rememberMeAttributeName);
            String lastLoginTM = (String)attributes.get("lastLoginTM");
            SecurityUtils.getSubject().getSession().setAttribute((Object)"lastLoginTM", (Object)lastLoginTM);
            SecurityUtils.getSubject().getSession().setAttribute((Object)"loginId", (Object)userId);
            boolean bl = isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
            if (isRemembered) {
                casToken.setRememberMe(true);
            }
            log.debug("========\u83b7\u53d6\u7684\u7528\u6237ID\u4e3a\uff1a" + userId);
            ReqStaffsByStaffIdsBO reqStaffsBO = new ReqStaffsByStaffIdsBO();
            ArrayList<StaffNoBO> staffIdList = new ArrayList<StaffNoBO>();
            StaffNoBO staffBO = new StaffNoBO();
            staffBO.setStaffNo(userId);
            staffIdList.add(staffBO);
            reqStaffsBO.setStaffIdList(staffIdList);
            RspStaffsByStaffIdsBO rspStaffsBO = this.staffInfoService.queryStaffsByStaffIds(reqStaffsBO);
            List staffInfos = rspStaffsBO.getStaffInfoList();
            StaffInfoBO userDetails = (StaffInfoBO)staffInfos.get(0);
            com.ohaotian.base.common.bo.ReqInfoBO acct = new com.ohaotian.base.common.bo.ReqInfoBO();
            acct.setStaffId(userDetails.getStaffNo());
            acct.setProvinceCode(userDetails.getProvince());
            acct.setCityCode(userDetails.getEparchy());
            acct.setDistrictCode(userDetails.getCounty());
            acct.setChannelId(userDetails.getChnlCode());
            HashMap<String, Object> busiData = new HashMap<String, Object>();
            String mainCode = userDetails.getDepartCode();
            if (userDetails.getChnlCode() != null && userDetails.getChnlCode().length() > 0) {
                mainCode = userDetails.getChnlCode();
            }
            QueryMainEntityUsedByAuthRspBO mainEntityBO = this.queryMainEntityUsedByAuthBusiService.getByMainCode(mainCode);
            busiData.put(MAIN_ENTITY, mainEntityBO);
            QueryStoreListUsedByAuthRspBO storeUsedByAuthRspBO = this.queryStoreUsedByAuthBusiService.queryStoreByEntityCode(userDetails.getStaffNo());
            busiData.put(STORE_INFORMATION, storeUsedByAuthRspBO);
            QueryGeniusUsedByAuthRspBO geniusUsedByAuthRspBO = this.queryGeniusUsedByAuthBusiService.queryGeniusByEntityCode(userDetails.getStaffNo());
            busiData.put(GENIUS_ENTITY, geniusUsedByAuthRspBO);
            acct.setBusiData(busiData);
            acct.setDepartId(userDetails.getDepartCode());
            acct.setDepartLevel(userDetails.getChnlLevel());
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237\u767b\u5f55\uff1a" + acct);
            }
            ReqPermsByStaffsBO permsByStaffsBO = new ReqPermsByStaffsBO();
            permsByStaffsBO.setStaffId(acct.getStaffId());
            RspPermsByStaffsBO permsRspBO = this.permInfoService.queryPermsByStaff(permsByStaffsBO);
            List menuList = permsRspBO.getPermList();
            RspAuthMenuListBO allSecondMenuList = this.permInfoService.getAllSecondMenus();
            MenuLayOut mlo = new MenuLayOut();
            ArrayList<MenuInfo> navMenuList = new ArrayList<MenuInfo>();
            ArrayList<Object> allNavMenuList = new ArrayList<Object>();
            HashMap<Long, MenuInfo> navMenuCodes = new HashMap<Long, MenuInfo>();
            ArrayList<Long> firstLevelMenuIds = new ArrayList<Long>();
            for (PermInfoBO menu : menuList) {
                if (menu.getParentId() == null || menu.getAutoId().equals(menu.getRootId()) || !menu.getParentId().equals(menu.getRootId())) continue;
                MenuInfo mi = new MenuInfo();
                mi.setMenuId(menu.getAutoId());
                mi.setClassName(menu.getMenuCss());
                mi.setModuleType(menu.getMenuCode());
                mi.setFlag(menu.getMenuUrl());
                mi.setLabel(menu.getMenuName());
                mi.setState(menu.getMenuCode());
                mi.setTargetNewWindow(true);
                navMenuList.add(mi);
                navMenuCodes.put(menu.getAutoId(), mi);
                firstLevelMenuIds.add(menu.getAutoId());
            }
            ReqHomePageByIdsBO reqHomePageByIdsBO = new ReqHomePageByIdsBO();
            reqHomePageByIdsBO.setIdList(firstLevelMenuIds);
            RspHomePageByIdsBO rspBO = this.permInfoService.queryHomePageByIds(reqHomePageByIdsBO);
            List homePageList = rspBO.getHomePageList();
            String homePage = null;
            if (homePageList != null && homePageList.size() > 0) {
                homePage = (String)((Map)homePageList.get(0)).get("HOME_PAGE");
            }
            acct.setHomePage(homePage);
            ArrayList centerCodes = new ArrayList();
            for (Map map : homePageList) {
                centerCodes.add(map.get("CENTER_CODE"));
            }
            acct.setCenterCodes(centerCodes);
            for (PermInfoBO menu : allSecondMenuList.getAuthMenuList()) {
                if (menu.getParentId() == null || menu.getAutoId().equals(menu.getRootId()) || !menu.getParentId().equals(menu.getRootId())) continue;
                MenuInfo mi = new MenuInfo();
                mi.setMenuId(menu.getAutoId());
                mi.setClassName(menu.getMenuCss());
                mi.setModuleType(menu.getMenuCode());
                mi.setFlag(menu.getMenuUrl());
                mi.setLabel(menu.getMenuName());
                mi.setState(menu.getMenuCode());
                mi.setTargetNewWindow(true);
                allNavMenuList.add(mi);
            }
            HashMap<String, ArrayList<MenuInfo>> leftNav = new HashMap<String, ArrayList<MenuInfo>>();
            HashMap<Long, MenuInfo> leftNavCodes = new HashMap<Long, MenuInfo>();
            for (PermInfoBO menu : menuList) {
                if (!navMenuCodes.containsKey(menu.getParentId())) continue;
                MenuInfo mi = new MenuInfo();
                mi.setMenuId(menu.getAutoId());
                mi.setClassName(menu.getMenuCss());
                mi.setFlag(menu.getMenuUrl());
                mi.setLabel(menu.getMenuName());
                mi.setState(menu.getMenuCode());
                mi.setTargetNewWindow(false);
                ArrayList<MenuInfo> mis2 = (List)leftNav.get(((MenuInfo)navMenuCodes.get(menu.getParentId())).getState());
                if (mis2 == null) {
                    mis2 = new ArrayList<MenuInfo>();
                    leftNav.put(((MenuInfo)navMenuCodes.get(menu.getParentId())).getState(), mis2);
                }
                mis2.add(mi);
                leftNavCodes.put(menu.getAutoId(), mi);
            }
            ReqInfoBO infoBO = new ReqInfoBO();
            infoBO.setStaffId(acct.getStaffId());
            RspPermsByCodesBO menuBO = this.permInfoService.queryUserMenuList(infoBO);
            HashMap<Long, Object> thirdLevelMenu = new HashMap<Long, Object>();
            for (PermInfoBO menu : menuList) {
                if (menu.getDeep().equals(MENU_LEVEL_3) && COMMON_MENU.equals(menu.getMenuName())) {
                    ArrayList<MenuInfo> mis3 = new ArrayList<MenuInfo>();
                    for (PermInfoBO bo : menuBO.getPermInfoList()) {
                        MenuInfo mi = new MenuInfo();
                        mi.setMenuId(bo.getAutoId());
                        mi.setClassName("");
                        mi.setFlag(bo.getMenuUrl());
                        mi.setLabel(bo.getMenuName());
                        mi.setState(bo.getMenuCode());
                        mis3.add(mi);
                    }
                    thirdLevelMenu.put(menu.getAutoId(), mis3);
                }
                if (!leftNavCodes.containsKey(menu.getParentId())) continue;
                MenuInfo mi = new MenuInfo();
                mi.setMenuId(menu.getAutoId());
                mi.setClassName(menu.getMenuCss());
                mi.setFlag(menu.getMenuUrl());
                mi.setLabel(menu.getMenuName());
                mi.setState(menu.getMenuCode());
                mis = (List)thirdLevelMenu.get(menu.getParentId());
                if (mis == null) {
                    mis = new ArrayList();
                    thirdLevelMenu.put(menu.getParentId(), mis);
                }
                mis.add(mi);
            }
            for (MenuInfo mi : leftNavCodes.values()) {
                List menus = (List)thirdLevelMenu.get(mi.getMenuId());
                if (menus == null) continue;
                mis = new MenuInfo[menus.size()];
                menus.toArray((T[])mis);
                mi.setSubMenu((MenuInfo[])mis);
            }
            MenuInfo[] navMenu = new MenuInfo[navMenuList.size()];
            navMenuList.toArray(navMenu);
            mlo.setNavMenu(navMenu);
            MenuInfo[] allNavMenu = new MenuInfo[allNavMenuList.size()];
            allNavMenuList.toArray(allNavMenu);
            mlo.setAllNavMenu(allNavMenu);
            HashMap<String, MenuInfo[]> leftMenu = new HashMap<String, MenuInfo[]>();
            for (Map.Entry mie : leftNav.entrySet()) {
                MenuInfo[] mis4 = new MenuInfo[((List)mie.getValue()).size()];
                ((List)mie.getValue()).toArray(mis4);
                leftMenu.put((String)mie.getKey(), mis4);
            }
            mlo.setLeftMenu(leftMenu);
            SecurityUtils.getSubject().getSession().setAttribute((Object)"MenuLayOut:MENU_LAY_OUT", (Object)mlo);
            SecurityUtils.getSubject().getSession().setAttribute((Object)"MenuLayOut:MENU_LAY_OUT_AS_STRING", (Object)mlo.toString());
            HashMap<String, Object> loginedInfo = new HashMap<String, Object>();
            String[] staffIds = acct.getStaffId().split("_");
            if (staffIds.length >= 2) {
                String newStaffId = acct.getStaffId().substring(staffIds[0].length() + 1, acct.getStaffId().length());
                loginedInfo.put("staffId", newStaffId);
            } else {
                loginedInfo.put("staffId", acct.getStaffId());
            }
            loginedInfo.put("staffName", userDetails.getStaffName());
            loginedInfo.put("departCode", userDetails.getDepartCode());
            loginedInfo.put("departLevel", userDetails.getChnlLevel());
            loginedInfo.put("departName", userDetails.getDepartOrChnlName());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userDetails.getChnlCode())) {
                loginedInfo.put("departCode", userDetails.getChnlCode());
            }
            loginedInfo.put("isChange", "1");
            loginedInfo.put("userRelationList", new ArrayList());
            SecurityUtils.getSubject().getSession().setAttribute((Object)"LOGINED_INFO", loginedInfo);
            log.debug("=========\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\u662f\uff1a" + acct);
            SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)acct, this.getName());
            return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)ticket);
        }
        catch (Throwable t) {
            log.error("\u5355\u70b9\u767b\u5f55\u5931\u8d25", t);
            if (t instanceof TicketValidationException) {
                throw new CasAuthenticationException("Unable to validate ticket [" + ticket + "]", t);
            }
            throw new CasAuthenticationException("\u5355\u70b9\u767b\u5f55\u5931\u8d25 [" + ticket + "]", t);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        log.debug("----doGetAuthorizationInfo start ------");
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        log.debug("----doGetAuthorizationInfo end ------");
        return authorizationInfo;
    }

    public void setPermInfoService(PermInfoService permInfoService) {
        this.permInfoService = permInfoService;
    }

    public void setStaffInfoService(StaffInfoService staffInfoService) {
        this.staffInfoService = staffInfoService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setQueryMainEntityUsedByAuthBusiService(QueryMainEntityUsedByAuthBusiService queryMainEntityUsedByAuthBusiService) {
        this.queryMainEntityUsedByAuthBusiService = queryMainEntityUsedByAuthBusiService;
    }

    public void setUserCheckService(UserCheckService userCheckService) {
        this.userCheckService = userCheckService;
    }

    public void setQueryStoreUsedByAuthBusiService(QueryStoreUsedByAuthBusiService queryStoreUsedByAuthBusiService) {
        this.queryStoreUsedByAuthBusiService = queryStoreUsedByAuthBusiService;
    }

    public void setQueryGeniusUsedByAuthBusiService(QueryGeniusUsedByAuthBusiService queryGeniusUsedByAuthBusiService) {
        this.queryGeniusUsedByAuthBusiService = queryGeniusUsedByAuthBusiService;
    }

    static {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Throwable e) {
            throw new IllegalStateException("\u521b\u5efaSSL\u5de5\u5382\u5931\u8d25", e);
        }
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

