/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.security.redis;

import com.ohaotian.base.cache.RedisManager;
import com.ohaotian.base.common.util.SerializeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCache<K, V>
implements Cache<K, V> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedisManager cache;
    private String keyPrefix = "shiro_redis_session:";

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public RedisCache(RedisManager cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.cache = cache;
    }

    public RedisCache(RedisManager cache, String prefix) {
        this(cache);
        this.keyPrefix = prefix;
    }

    private byte[] getByteKey(K key) {
        if (key instanceof String) {
            String preKey = this.keyPrefix + key;
            return preKey.getBytes();
        }
        return SerializeUtils.serialize(key);
    }

    public V get(K key) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4eceRedis\u4e2d\u83b7\u53d6\u5bf9\u8c61 key [" + key + "]");
        try {
            if (key == null) {
                return null;
            }
            byte[] rawValue = this.cache.get(this.getByteKey(key));
            Object value = SerializeUtils.deserialize((byte[])rawValue);
            return (V)value;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V put(K key, V value) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4ece\u5b58\u50a8 key [" + key + "]");
        try {
            this.cache.set(this.getByteKey(key), SerializeUtils.serialize(value));
            return value;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V remove(K key) throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664 key [" + key + "]");
        try {
            V previous = this.get(key);
            this.cache.del(this.getByteKey(key));
            return previous;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void clear() throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664\u6240\u6709\u5143\u7d20");
        try {
            this.cache.flushDB();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public int size() {
        try {
            Long longSize = new Long(this.cache.dbSize());
            return longSize.intValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Set<K> keys() {
        try {
            Set keys = this.cache.keys(this.keyPrefix + "*");
            if (CollectionUtils.isEmpty((Collection)keys)) {
                return Collections.emptySet();
            }
            HashSet<byte[]> newKeys = new HashSet<byte[]>();
            for (byte[] key : keys) {
                newKeys.add(key);
            }
            return newKeys;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Collection<V> values() {
        try {
            Set keys = this.cache.keys(this.keyPrefix + "*");
            if (!CollectionUtils.isEmpty((Collection)keys)) {
                ArrayList<V> values = new ArrayList<V>(keys.size());
                for (byte[] key : keys) {
                    V value = this.get(key);
                    if (value == null) continue;
                    values.add(value);
                }
                return Collections.unmodifiableList(values);
            }
            return Collections.emptyList();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }
}

