/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.security.redis;

import com.chinaunicom.number.security.redis.RedisCache;
import com.ohaotian.base.cache.RedisManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCacheManager
implements CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheManager.class);
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private RedisManager redisManager;
    private String keyPrefix = "shiro_redis_cache:";

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        logger.debug("\u83b7\u53d6\u540d\u79f0\u4e3a: " + name + " \u7684RedisCache\u5b9e\u4f8b");
        RedisCache c = (RedisCache)this.caches.get(name);
        if (c == null) {
            this.redisManager.init();
            c = new RedisCache(this.redisManager, this.keyPrefix);
            this.caches.put(name, c);
        }
        return c;
    }

    public RedisManager getRedisManager() {
        return this.redisManager;
    }

    public void setRedisManager(RedisManager redisManager) {
        this.redisManager = redisManager;
    }
}

