/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.controller;

import com.chinaunicom.number.bo.JumpBO;
import com.chinaunicom.number.utils.ApplicationUtils;
import com.chinaunicom.number.utils.HttpRequestUtils;
import com.chinaunicom.number.utils.JumpUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.base.common.bo.ReqInfoBO;
import com.ohaotian.base.common.bo.RspFileInfoBO;
import com.ohaotian.base.common.bo.RspInfoBO;
import com.ohaotian.base.common.exception.ResourceException;
import com.ohaotian.base.file.FileProcessing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class RequestJumpController
implements ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(RequestJumpController.class);
    private ApplicationContext applicationContext;
    private static int sumTimes = 0;
    private static long sumAllDate = 0L;
    private static long sumReqDate = 0L;
    private static long sumUserDate = 0L;
    private static long sumInvokDate = 0L;
    private static final Map<String, Object> serviceMap = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Method> methodMap = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Class<?>> classMap = new ConcurrentHashMap();
    private Set<String> noNeedPermissions = null;
    private String webAppName;

    public Object getServiceMap(String serviceType) {
        return serviceMap.get(serviceType);
    }

    public void setServiceMap(String serviceType, Object obj) {
        serviceMap.put(serviceType, obj);
    }

    public Method getMethodMap(String methodName) {
        return methodMap.get(methodName);
    }

    public void setMethodMap(String methodName, Method m) {
        methodMap.put(methodName, m);
    }

    public Class<?> getClassMap(String className) {
        return classMap.get(className);
    }

    public void setClassMap(String className, Class<?> c) {
        classMap.put(className, c);
    }

    @RequestMapping(value={"/service/routing"})
    @ResponseBody
    public Object getServiceRouting(String service, HttpServletRequest request) {
        long start = System.currentTimeMillis();
        Object obj = this.invokeService(service, request);
        long end = System.currentTimeMillis();
        long times = end - start;
        long sumAllDateLs = sumAllDate += times;
        log.info("\u5b8c\u6574\u6d41\u7a0b\u6267\u884c\u65f6\u95f4=" + times);
        log.info("\u6267\u884c\u6b21\u6570=" + ++sumTimes);
        log.info("\u6267\u884c\u603b\u65f6\u95f4=" + sumAllDateLs);
        return obj;
    }

    @RequestMapping(value={"/getFunPermission"})
    @ResponseBody
    public Object getFunPermission(String service, HttpServletRequest request) {
        RspInfoBO permissionBo = new RspInfoBO();
        String menuPath = request.getParameter("menuPath");
        if (StringUtils.isBlank((CharSequence)menuPath)) {
            throw new ResourceException("8888", "\u7f3a\u5c11\u53c2\u6570menuPath\uff01");
        }
        Subject subject = SecurityUtils.getSubject();
        permissionBo.setRespCode("0000");
        permissionBo.setRespDesc("\u9875\u9762\u65e0\u6743\u9650\u529f\u80fd\u83b7\u53d6\u6210\u529f\uff01");
        return permissionBo;
    }

    private static Class<?> getClass(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return RequestJumpController.getGenericClass((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return RequestJumpController.getClass(((TypeVariable)type).getBounds()[0], 0);
        }
        return (Class)type;
    }

    private static Class<?> getGenericClass(ParameterizedType parameterizedType, int i) {
        Type genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericClass).getRawType();
        }
        if (genericClass instanceof GenericArrayType) {
            return (Class)((GenericArrayType)genericClass).getGenericComponentType();
        }
        if (genericClass instanceof TypeVariable) {
            return RequestJumpController.getClass(((TypeVariable)genericClass).getBounds()[0], 0);
        }
        return (Class)genericClass;
    }

    private Object invokeService(String service, HttpServletRequest request) {
        JumpBO jumpBO = this.getJumpBOByCId(service);
        log.debug("jumpBO=={}", (Object)jumpBO);
        if (jumpBO == null) {
            throw new ResourceException("", "\u672a\u914d\u7f6e\u8bf7\u6c42\u8df3\u8f6c\u63a5\u53e3\uff01");
        }
        String menuPath = request.getParameter("menuPath");
        String cid = request.getParameter("cid");
        if (StringUtils.isNotBlank((CharSequence)cid)) {
            if (this.webAppName == null) {
                this.webAppName = request.getContextPath();
                log.debug("\u5de5\u7a0b\u540d\u79f0webAppName=" + this.webAppName);
            }
            if (StringUtils.isBlank((CharSequence)menuPath)) {
                throw new ResourceException("8888", "\u53c2\u6570menuPath\u4e3a\u7a7a\uff01");
            }
        }
        String serviceType = jumpBO.getServiceName();
        String method2 = jumpBO.getMethodName();
        long start = System.currentTimeMillis();
        Object[] objs = ApplicationUtils.parameterConversion(request, serviceType, method2);
        long end = System.currentTimeMillis();
        long times = end - start;
        long sumReqDatels = sumReqDate += times;
        log.info("\u5c01\u88c5\u5165\u53c2\u8017\u65f6={}", (Object)times);
        log.info("\u5c01\u88c5\u53c2\u6570\u603b\u65f6\u95f4={}", (Object)sumReqDatels);
        log.debug("\u5165\u53c2\u4e3a=\u3010{}\u3011", objs);
        this.packageRequestParameters(objs, request);
        log.debug("\u5165\u53c2\u6dfb\u52a0\u7528\u6237\u4fe1\u606f\u540e\u4e3a=\u3010{}\u3011", objs);
        long end2 = System.currentTimeMillis();
        long times2 = end2 - end;
        long sumUserDateLs = sumUserDate += times2;
        log.info("\u6dfb\u52a0\u7528\u6237\u4fe1\u606f\u8017\u65f6={}", (Object)times2);
        log.info("\u6dfb\u52a0\u7528\u6237\u603b\u8017\u65f6={}", (Object)sumUserDateLs);
        Object returnObj = this.invokeMethod(serviceType, method2, objs);
        long end3 = System.currentTimeMillis();
        long times3 = end3 - end2;
        long sumInvokDateLs = sumInvokDate += times3;
        log.info("\u6267\u884c\u4e1a\u52a1\u670d\u52a1\u8017\u65f6{}", (Object)times3);
        log.info("\u6267\u884c\u4e1a\u52a1\u603b\u8017\u65f6={}", (Object)sumInvokDateLs);
        log.debug("returnObj = {}", returnObj);
        ReqInfoBO infoBO = ApplicationUtils.getUserInfo();
        return returnObj;
    }

    protected void packageRequestParameters(Object[] objs, HttpServletRequest request) {
        String sessionId = request.getSession().getId();
        for (Object obj : objs) {
            this.packageReqInfoParam(sessionId, obj);
        }
    }

    private void packageReqInfoParam(String sessionId, Object obj) {
        Subject subject;
        if (obj instanceof ReqInfoBO && (subject = SecurityUtils.getSubject()).isAuthenticated()) {
            ReqInfoBO infoBO = ApplicationUtils.getUserInfo();
            log.debug("session\u4e2d\u7684\u7528\u6236\u4fe1\u606finfoBO {} ", (Object)infoBO);
            try {
                Field field = ReqInfoBO.class.getDeclaredField("sysCode");
                field.setAccessible(true);
                field.set(obj, "A1");
                field = ReqInfoBO.class.getDeclaredField("departId");
                field.setAccessible(true);
                field.set(obj, infoBO.getDepartId());
                field = ReqInfoBO.class.getDeclaredField("staffId");
                field.setAccessible(true);
                field.set(obj, infoBO.getStaffId());
                field = ReqInfoBO.class.getDeclaredField("provinceCode");
                field.setAccessible(true);
                field.set(obj, infoBO.getProvinceCode());
                field = ReqInfoBO.class.getDeclaredField("cityCode");
                field.setAccessible(true);
                field.set(obj, infoBO.getCityCode());
                field = ReqInfoBO.class.getDeclaredField("districtCode");
                field.setAccessible(true);
                field.set(obj, infoBO.getDistrictCode());
                field = ReqInfoBO.class.getDeclaredField("channelId");
                field.setAccessible(true);
                field.set(obj, infoBO.getChannelId());
                field = ReqInfoBO.class.getDeclaredField("channelType");
                field.setAccessible(true);
                field.set(obj, infoBO.getChannelType());
                field = ReqInfoBO.class.getDeclaredField("departLevel");
                field.setAccessible(true);
                field.set(obj, infoBO.getDepartLevel());
                field = ReqInfoBO.class.getDeclaredField("sessionId");
                field.setAccessible(true);
                field.set(obj, sessionId);
            }
            catch (Exception e) {
                log.error("\u53cd\u5c04\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
    }

    private Object invokeMethod(String serviceType, String methodName, Object[] obj) {
        Class<?> c;
        Object returnObj = null;
        Method method2 = methodMap.get(serviceType + methodName);
        Object service = serviceMap.get(serviceType);
        if (service == null) {
            c = classMap.get(serviceType);
            if (c == null) {
                try {
                    c = Class.forName(serviceType);
                    classMap.put(serviceType, c);
                }
                catch (ClassNotFoundException e) {
                    log.error("9996", (Object)"\u63a5\u53e3\u7c7b\u578b\u9519\u8bef", (Object)e);
                }
            }
            service = this.applicationContext.getBean(c);
            serviceMap.put(serviceType, service);
        }
        if (method2 == null) {
            log.debug(classMap + "");
            c = classMap.get(serviceType);
            if (c == null) {
                try {
                    c = Class.forName(serviceType);
                    classMap.put(serviceType, c);
                }
                catch (ClassNotFoundException e) {
                    log.error("9996", (Object)"\u63a5\u53e3\u7c7b\u578b\u9519\u8bef", (Object)e);
                }
            }
            for (Method method3 : c.getDeclaredMethods()) {
                if (!methodName.equals(method3.getName())) continue;
                method2 = method3;
                methodMap.put(serviceType + methodName, method3);
                break;
            }
            block7: for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                for (Method m : ((Class)genericDeclaration).getDeclaredMethods()) {
                    if (!methodName.equals(m.getName())) continue;
                    method2 = m;
                    methodMap.put(serviceType + methodName, m);
                    continue block7;
                }
            }
        }
        try {
            returnObj = obj == null ? method2.invoke(service, new Object[0]) : method2.invoke(service, obj);
        }
        catch (Exception e) {
            log.error("9995", (Object)"\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff01", (Object)e);
        }
        return returnObj;
    }

    protected JumpBO getJumpBOByCId(String cid) {
        return JumpUtils.jumpMap.get(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/uploadMultiFile"}, method={RequestMethod.POST})
    @ResponseBody
    public RspFileInfoBO uploadMultiFile(MultipartHttpServletRequest request, String busiPath) {
        RspFileInfoBO rspInfo = new RspFileInfoBO();
        String fileName = null;
        String newFileName = null;
        Iterator it = request.getFileNames();
        MultipartFile mf = null;
        if (it.hasNext()) {
            mf = request.getFile((String)it.next());
            if (fileName == null) {
                fileName = mf.getOriginalFilename();
                newFileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
            }
            InputStream is = null;
            try {
                is = mf.getInputStream();
                String string = FileProcessing.uploadToOssByBusiPathInputStream(newFileName, (String)busiPath, (InputStream)is, (boolean)false);
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
                rspInfo.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error("\u5173\u95ed\u6d41\u5f02\u5e38\uff01", (Throwable)e);
                        rspInfo.setRespCode("F008");
                        rspInfo.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
                    }
                }
            }
        }
        rspInfo.setFilePath(fileName);
        rspInfo.setNewFileName(newFileName);
        rspInfo.setRespCode("0000");
        rspInfo.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01");
        return rspInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadFile"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public Object downloadMultiFile(HttpServletRequest request, HttpServletResponse res) throws IOException {
        log.info("\u8fdb\u5165\u6587\u4ef6\u4e0b\u8f7d\u65b9\u6cd5 start");
        String filePath = request.getParameter("provDownFile");
        String fileName = request.getParameter("fileName");
        String busiPath = request.getParameter("busiPath");
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = filePath;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            log.info("\u7701\u4efd\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + filePath);
            log.debug("---downloadFile start ---");
            File file = null;
            ServletOutputStream outStream = null;
            OutputStreamWriter osw = null;
            FileInputStream inStream = null;
            BufferedReader buffer = null;
            res.reset();
            res.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            res.setContentType("application/octet-stream; charset=utf-8");
            res.setCharacterEncoding("utf-8");
            res.setContentType("multipart/form-data");
            res.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
            try {
                outStream = res.getOutputStream();
                osw = new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF-8");
                InputStream in = FileProcessing.downloadFromOssByBusiPathInputStream((String)filePath, (String)busiPath);
                InputStreamReader isr = new InputStreamReader(in, "ISO-8859-1");
                BufferedReader reader = new BufferedReader(isr);
                String tmp = null;
                String htmlRet = "";
                while ((tmp = reader.readLine()) != null) {
                    htmlRet = htmlRet + tmp + "\r\n";
                }
                String a = new String(htmlRet.getBytes("ISO-8859-1"), "GB2312");
                osw.write(a);
                osw.flush();
            }
            catch (ResourceException e) {
                result.put("respCode", e.getMsgCode());
                result.put("respDesc", e.getMessage());
                String dir = System.getProperty("java.io.tmpdir");
                String pathname = dir + File.separator + "error.txt";
                res.setHeader("Content-Disposition", "attachment; filename=error.txt");
                FileWriter fw = new FileWriter(pathname);
                fw.write(e.getMessage());
                fw.flush();
                fw.close();
                file = new File(pathname);
                inStream = new FileInputStream(file);
                byte[] buf = new byte[1024];
                int byteread = -1;
                while ((byteread = inStream.read(buf)) != -1) {
                    outStream.write(buf, 0, byteread);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                result.put("respCode", "8888");
                result.put("respDesc", "\u4e0b\u8f7d\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff0c\u5e76\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff01");
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (buffer != null) {
                    buffer.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
        } else {
            log.info("provDownFile\u53c2\u6570\u4e3anull\uff0c\u65e0\u6cd5\u83b7\u5f97\u7701\u4efd\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84");
        }
        log.info("\u8fdb\u5165\u6587\u4ef6\u4e0b\u8f7d\u65b9\u6cd5 end");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadTempletFile"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public void downloadTempletFile(HttpServletRequest request, HttpServletResponse res, String service) throws UnsupportedEncodingException {
        log.debug("\u8fdb\u5165\u6a21\u677f\u4e0b\u8f7d\u65b9\u6cd5");
        String userAgent = request.getHeader("User-Agent");
        String fileName = request.getParameter("fileName");
        String finalFileName = null;
        finalFileName = StringUtils.contains((CharSequence)userAgent, (CharSequence)"Firefox") ? new String(fileName.getBytes(), "ISO8859-1") : URLEncoder.encode(fileName, "UTF8");
        String downloadPath = request.getServletContext().getRealPath("/");
        log.debug("\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + downloadPath);
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            log.info("\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + fileName);
            File file = new File(downloadPath + "/templet/" + fileName);
            try {
                if (file.getCanonicalPath().indexOf(downloadPath) > -1) {
                    log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
                }
            }
            catch (IOException e1) {
                log.error("\u6587\u4ef6\u4e0b\u8f7dIO\u5f02\u5e38", (Throwable)e1);
            }
            log.debug("\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + file);
            res.reset();
            res.setHeader("Content-Disposition", "attachment; filename=" + finalFileName);
            res.setContentType("application/octet-stream; charset=utf-8");
            FileInputStream is = null;
            OutputStream out = null;
            try {
                is = new FileInputStream(file);
                out = res.getOutputStream();
                byte[] content = new byte[((InputStream)is).available()];
                int length = 0;
                while ((length = ((InputStream)is).read(content)) != -1) {
                    out.write(content, 0, length);
                }
                out.flush();
                res.flushBuffer();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u4e0b\u8f7dIO\u5f02\u5e38", (Throwable)e);
                }
            }
        } else {
            log.error("provDownFile\u53c2\u6570\u4e3anull\uff0c\u65e0\u6cd5\u83b7\u5f97\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84");
        }
    }

    @RequestMapping(value={"/downloadGoodNumValidFile"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public String downloadGoodNumValidFile(HttpServletRequest request, HttpServletResponse res) throws IOException {
        log.info("\u8fdb\u5165\u6587\u4ef6\u4e0b\u8f7d\u65b9\u6cd5 start");
        String filePath = request.getParameter("provDownFile");
        String fileName = request.getParameter("fileName");
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            log.info("\u7701\u4efd\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + filePath);
            log.debug("---downloadFile start ---");
            File file = FileProcessing.downloadFile((String)filePath, (String)"num", (String)"46");
            res.reset();
            res.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            res.setContentType("application/octet-stream; charset=utf-8");
            OutputStream outStream = null;
            FileInputStream inStream = null;
            try {
                res.setCharacterEncoding("utf-8");
                res.setContentType("multipart/form-data");
                res.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
                inStream = new FileInputStream(file);
                outStream = res.getOutputStream();
                byte[] buf = new byte[1024];
                int byteread = -1;
                while ((byteread = inStream.read(buf)) != -1) {
                    outStream.write(buf, 0, byteread);
                }
                log.debug("---downloadFile end ---");
            }
            catch (IOException e) {
                log.error("\u4e0b\u8f7d\u9519\u8bef", (Throwable)e);
                throw new ResourceException("8888", "\u4e0b\u8f7d\u6587\u4ef6\u9519\u8bef ");
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
        } else {
            log.info("provDownFile\u53c2\u6570\u4e3anull\uff0c\u65e0\u6cd5\u83b7\u5f97\u7701\u4efd\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84");
        }
        log.info("\u8fdb\u5165\u6587\u4ef6\u4e0b\u8f7d\u65b9\u6cd5 end");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/uploadMultiFileByOSS"}, method={RequestMethod.POST})
    @ResponseBody
    public RspFileInfoBO uploadMultiFileByOSS(MultipartHttpServletRequest request) {
        RspFileInfoBO rspInfo = new RspFileInfoBO();
        String fileName = null;
        String newFileName = null;
        String qserviceId = request.getParameter("qserviceId");
        Iterator it = request.getFileNames();
        MultipartFile mf = null;
        if (it.hasNext()) {
            mf = request.getFile((String)it.next());
            if (fileName == null) {
                fileName = mf.getOriginalFilename();
                newFileName = UUID.randomUUID().toString().replace("-", "") + fileName.substring(fileName.lastIndexOf("."), fileName.length());
            }
            InputStream is = null;
            try {
                is = mf.getInputStream();
                newFileName = FileProcessing.uploadFileToOSSByInputStream(newFileName, (InputStream)is, (String)qserviceId);
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
                rspInfo.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error("\u5173\u95ed\u6d41\u5f02\u5e38\uff01", (Throwable)e);
                        rspInfo.setRespCode("F008");
                        rspInfo.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
                    }
                }
            }
        }
        rspInfo.setFilePath(fileName);
        rspInfo.setNewFileName(newFileName);
        rspInfo.setRespCode("0000");
        rspInfo.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01");
        return rspInfo;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    public String exception(Throwable e) {
        log.error("controller\u5168\u5c40\u9519\u8bef\uff01", e);
        return e.getMessage();
    }

    @RequestMapping(value={"/getRequestParam"})
    @ResponseBody
    public String getRequestParam(String serviceType, String functionName) throws Exception {
        StringBuffer str = new StringBuffer();
        Class<?> c = Class.forName(serviceType);
        Type[] a = c.getGenericInterfaces();
        if (a != null && a.length > 0) {
            c = RequestJumpController.getClass(a[0], 0);
            ObjectMapper mapper = new ObjectMapper();
            str.append(mapper.writeValueAsString(c.newInstance()));
        }
        return str.toString();
    }

    public static String getParam(String serviceType, String functionName) throws Exception {
        StringBuffer str = new StringBuffer();
        Class<?> c = Class.forName(serviceType);
        Type[] a = c.getGenericInterfaces();
        if (a != null && a.length > 0) {
            c = RequestJumpController.getClass(a[0], 0);
            ObjectMapper mapper = new ObjectMapper();
            str.append(mapper.writeValueAsString(c.newInstance()));
        }
        return str.toString();
    }

    @RequestMapping(value={"/getSessionMenu"})
    public void getSessionMenu(HttpServletResponse response) throws IOException {
        Object menuString = SecurityUtils.getSubject().getSession().getAttribute((Object)"MenuLayOut:MENU_LAY_OUT_AS_STRING");
        if (menuString == null) {
            return;
        }
        response.setContentType("application/json");
        PrintWriter printWriter = response.getWriter();
        printWriter.print(menuString.toString());
        printWriter.flush();
        printWriter.close();
    }

    @RequestMapping(value={"/logout.js"})
    @ResponseBody
    public boolean doLogout() throws IOException {
        if (log.isDebugEnabled()) {
            ReqInfoBO userInfo = null;
            try {
                userInfo = ApplicationUtils.getUserInfo();
            }
            catch (Exception e) {
                log.debug("user is not logined:", (Throwable)e);
            }
            if (userInfo != null) {
                log.debug("call do logout.js for[" + userInfo.getStaffId() + "]");
            } else {
                log.debug("call do logout.js");
            }
        }
        boolean logout = true;
        try {
            SecurityUtils.getSubject().logout();
        }
        catch (Throwable e) {
            logout = false;
            log.debug("call do logout.js error:", e);
        }
        return logout;
    }

    @RequestMapping(value={"/getLoginedInfo"})
    public void getLoginedInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        PrintWriter printWriter = response.getWriter();
        ObjectMapper om = new ObjectMapper();
        Map loginedInfo = (Map)SecurityUtils.getSubject().getSession().getAttribute((Object)"LOGINED_INFO");
        log.debug("control \u5c42\u53d6\u5f97session\u4e2d\u7684\u7528\u6237\u4fe1\u606f\u4e3a" + loginedInfo);
        loginedInfo.put("logoutUrl", request.getContextPath() + "/casLogout");
        Properties props = (Properties)this.applicationContext.getBean("propertyConfigurer", Properties.class);
        String envName = props.getProperty("ENV_NAME");
        log.debug("envName======" + envName);
        if (envName != null && StringUtils.isNotEmpty((CharSequence)envName)) {
            envName = "LOCAL".equals(envName) ? "\u672c\u673a\u73af\u5883" : ("DEV".equals(envName) ? "\u8054\u8c03\u73af\u5883" : ("TEST".equals(envName) ? "\u6d4b\u8bd5\u73af\u5883" : ""));
            loginedInfo.put("envName", envName);
        } else {
            loginedInfo.put("envName", "");
        }
        ReqInfoBO userInfo = ApplicationUtils.getUserInfo();
        loginedInfo.put("homePage", userInfo.getHomePage());
        om.writeValue((Writer)printWriter, (Object)loginedInfo);
        printWriter.flush();
        printWriter.close();
    }

    @RequestMapping(value={"/getUserInfo"})
    public void getUserInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        PrintWriter printWriter = response.getWriter();
        ObjectMapper om = new ObjectMapper();
        ReqInfoBO userInfo = ApplicationUtils.getUserInfo();
        om.writeValue((Writer)printWriter, (Object)userInfo);
        printWriter.flush();
        printWriter.close();
    }

    @RequestMapping(value={"/loadDirectories"})
    public void loadDirectories(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        Properties props = (Properties)this.applicationContext.getBean("propertyConfigurer", Properties.class);
        String server = props.getProperty("help_center_server");
        log.debug("help_center_server = " + server);
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        String httpUrl = server + "DoLoadDirectories";
        String result = HttpRequestUtils.httpGet(httpUrl);
        PrintWriter printWriter = response.getWriter();
        printWriter.print(result);
        printWriter.close();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

