/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLDecoder;
import java.text.Collator;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralHelper {
    private static final Pattern PATTERN_NUMERIC;
    private static final Pattern PATTERN_EMAIL_ADDR;
    private static final Pattern PATTERN_IP_ADDR;
    private static final Pattern PATTERN_LINK;
    private static final Pattern PATTERN_HTTP_URL;
    private static final Pattern PATTERN_XML_ESCAPES;
    private static final String[] SHORT_DATE_PATTERN;
    private static final String[] LONG_DATE_PATTERN;
    private static final String[] LONG_DATE_PATTERN_WITH_MILSEC;
    private static final Map<String, Locale> AVAILABLE_LOCALES;
    private static final char[][] XML_ESCAPE_CHARS;
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String OS_PLATFORM;
    public static final boolean IS_WINDOWS_PLATFORM;
    public static final String NEWLINE_CHAR;

    public static final Map<String, Locale> getAvailableLocales() {
        return AVAILABLE_LOCALES;
    }

    public static final Locale getAvailableLocale(String locale) {
        return AVAILABLE_LOCALES.get(locale);
    }

    public static final boolean isStrNotEmpty(String str) {
        return str != null && str.length() != 0;
    }

    public static final boolean isTrimStrNotEmpty(String str) {
        boolean result = GeneralHelper.isStrNotEmpty(str);
        return result ? GeneralHelper.isStrNotEmpty(str.trim()) : result;
    }

    public static final boolean isStrEmpty(String str) {
        return !GeneralHelper.isStrNotEmpty(str);
    }

    public static final boolean isTrimStrEmpty(String str) {
        boolean result = GeneralHelper.isStrEmpty(str);
        return result ? result : GeneralHelper.isStrEmpty(str.trim());
    }

    public static final String safeString(String str) {
        if (str == null) {
            str = EMPTY_STRING;
        }
        return str;
    }

    public static final String safeString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return obj.toString();
    }

    public static final String safeTrimString(String str) {
        return GeneralHelper.safeString(str).trim();
    }

    public static final String trimLeft(String str, String word) {
        if (word != null && word.length() > 0) {
            int index = -1;
            int length = word.length();
            for (int i = 0; str.indexOf(word, i) == i; i += length) {
                index = i;
            }
            if (index != -1) {
                str = str.substring(index += length);
            }
        }
        return str;
    }

    public static final String trimRight(String str, String word) {
        if (word != null && word.length() > 0) {
            int index = -1;
            int length = word.length();
            int j = -1;
            int i = str.length() - 1;
            while ((j = i - (length - 1)) >= 0 && str.lastIndexOf(word, i) == j) {
                index = i;
                i -= length;
            }
            if (index != -1) {
                str = str.substring(0, index -= length - 1);
            }
        }
        return str;
    }

    public static final String trim(String str, String word) {
        str = GeneralHelper.trimLeft(str, word);
        str = GeneralHelper.trimRight(str, word);
        return str;
    }

    public static final boolean isStrNumeric(String str) {
        return PATTERN_NUMERIC.matcher(str).matches();
    }

    public static final boolean isStrEmailAddress(String str) {
        return PATTERN_EMAIL_ADDR.matcher(str).matches();
    }

    public static final boolean isStrIPAddress(String str) {
        return PATTERN_IP_ADDR.matcher(str).matches();
    }

    public static final boolean isStrLink(String str) {
        return PATTERN_LINK.matcher(str).matches();
    }

    public static final boolean isStrURL(String str) {
        return PATTERN_HTTP_URL.matcher(str).matches();
    }

    public static final String escapeXML(String str) {
        if (!PATTERN_XML_ESCAPES.matcher(str).matches()) {
            return str;
        }
        char[] src = str.toCharArray();
        StringBuilder sb = new StringBuilder(src.length);
        for (char c : src) {
            if (c > '>' || c < '\"') {
                sb.append(c);
                continue;
            }
            char[] dest = XML_ESCAPE_CHARS[c];
            if (dest == null) {
                sb.append(c);
                continue;
            }
            sb.append(dest);
        }
        return sb.toString();
    }

    public static final String escapeRegexChars(String str, char ... ignores) {
        int i;
        char[] REGEX_CHARS;
        int ESCAPE_CHAR = 92;
        char[] regex_chars = REGEX_CHARS = new char[]{'.', ',', '?', '+', '-', '*', '^', '$', '|', '&', '{', '}', '[', ']', '(', ')', '\\'};
        if (ignores.length > 0) {
            HashSet<Character> cs = new HashSet<Character>(REGEX_CHARS.length);
            for (i = 0; i < REGEX_CHARS.length; ++i) {
                cs.add(Character.valueOf(REGEX_CHARS[i]));
            }
            for (i = 0; i < ignores.length; ++i) {
                cs.remove(Character.valueOf(ignores[i]));
            }
            i = 0;
            regex_chars = new char[cs.size()];
            Iterator it = cs.iterator();
            while (it.hasNext()) {
                regex_chars[i++] = ((Character)it.next()).charValue();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (int j = 0; j < regex_chars.length; ++j) {
                if (c != regex_chars[j]) continue;
                sb.append('\\');
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String[] splitStr(String str) {
        return GeneralHelper.splitStr(str, " \t\n\r\f,;");
    }

    public static final String[] splitStr(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] array = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i++] = st.nextToken();
        }
        return array;
    }

    public static final boolean waitFor(long period) {
        if (period > 0L) {
            try {
                Thread.sleep(period);
            }
            catch (Exception e) {
                return false;
            }
        } else {
            Thread.yield();
        }
        return true;
    }

    public static final boolean waitFor(long period, TimeUnit unit) {
        return GeneralHelper.waitFor(unit.toMillis(period));
    }

    public static final Integer str2Int(String s) {
        Integer returnVal;
        try {
            returnVal = Integer.decode(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static final int str2Int(String s, int d) {
        int returnVal;
        try {
            returnVal = Integer.parseInt(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = d;
        }
        return returnVal;
    }

    public static final int str2Int_0(String s) {
        return GeneralHelper.str2Int(s, 0);
    }

    public static final Short str2Short(String s) {
        Short returnVal;
        try {
            returnVal = Short.decode(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static final short str2Short(String s, short d) {
        short returnVal;
        try {
            returnVal = Short.parseShort(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = d;
        }
        return returnVal;
    }

    public static final short str2Short_0(String s) {
        return GeneralHelper.str2Short(s, (short)0);
    }

    public static final Long str2Long(String s) {
        Long returnVal;
        try {
            returnVal = Long.decode(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static final long str2Long(String s, long d) {
        long returnVal;
        try {
            returnVal = Long.parseLong(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = d;
        }
        return returnVal;
    }

    public static final long str2Long_0(String s) {
        return GeneralHelper.str2Long(s, 0L);
    }

    public static final Float str2Float(String s) {
        Float returnVal;
        try {
            returnVal = Float.valueOf(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static final float str2Float(String s, float d) {
        float returnVal;
        try {
            returnVal = Float.parseFloat(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = d;
        }
        return returnVal;
    }

    public static final float str2Float_0(String s) {
        return GeneralHelper.str2Float(s, 0.0f);
    }

    public static final Double str2Double(String s) {
        Double returnVal;
        try {
            returnVal = Double.valueOf(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static final double str2Double(String s, double d) {
        double returnVal;
        try {
            returnVal = Double.parseDouble(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = d;
        }
        return returnVal;
    }

    public static final double str2Double_0(String s) {
        return GeneralHelper.str2Double(s, 0.0);
    }

    public static final Byte str2Byte(String s) {
        Byte returnVal;
        try {
            returnVal = Byte.decode(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static final byte str2Byte(String s, byte d) {
        byte returnVal;
        try {
            returnVal = Byte.parseByte(GeneralHelper.safeTrimString(s));
        }
        catch (Exception e) {
            returnVal = d;
        }
        return returnVal;
    }

    public static final byte str2Byte_0(String s) {
        return GeneralHelper.str2Byte(s, (byte)0);
    }

    public static final Character str2Char(String s) {
        Character returnVal;
        try {
            returnVal = Character.valueOf(GeneralHelper.safeTrimString(s).charAt(0));
        }
        catch (Exception e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static final char str2Char(String s, char d) {
        char returnVal;
        try {
            returnVal = GeneralHelper.safeTrimString(s).charAt(0);
        }
        catch (Exception e) {
            returnVal = d;
        }
        return returnVal;
    }

    public static final char str2Char_0(String s) {
        return GeneralHelper.str2Char(s, '\u0000');
    }

    public static final Boolean str2Boolean(String s) {
        return Boolean.valueOf(GeneralHelper.safeTrimString(s));
    }

    public static final boolean str2Boolean(String s, boolean d) {
        if ((s = GeneralHelper.safeTrimString(s)).equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        return d;
    }

    public static final boolean str2Boolean_False(String s) {
        return GeneralHelper.str2Boolean(s, false);
    }

    public static final Date str2Date(String str, String format) {
        Date date = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            date = df.parse(GeneralHelper.safeTrimString(str));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static final Date str2Date(String str) {
        Date date = null;
        try {
            int SEPARATOR = 45;
            String[] PATTERN = new String[]{"yyyy", "MM", "dd", "HH", "mm", "ss", "SSS"};
            String[] values = GeneralHelper.safeTrimString(str).split("\\D");
            String[] element = new String[values.length];
            int length = 0;
            for (String e : values) {
                if ((e = e.trim()).length() == 0) continue;
                element[length++] = e;
                if (length == PATTERN.length) break;
            }
            if (length > 0) {
                StringBuilder value = new StringBuilder();
                if (length > 1) {
                    for (int i = 0; i < length; ++i) {
                        value.append(element[i]);
                        value.append('-');
                    }
                } else {
                    int v_length;
                    String src = element[0];
                    int remain = src.length();
                    int pos = 0;
                    int i = 0;
                    for (i = 0; remain > 0 && i < PATTERN.length; remain -= v_length, ++i) {
                        int p_length = PATTERN[i].length();
                        v_length = Math.min(p_length, remain);
                        String v = src.substring(pos, pos + v_length);
                        pos += v_length;
                        value.append(v);
                        value.append('-');
                    }
                    length = i;
                }
                StringBuilder format = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    format.append(PATTERN[i]);
                    format.append('-');
                }
                date = GeneralHelper.str2Date(value.toString(), format.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static final Date str2Date(String str, String[] Patterns) {
        Date date = null;
        for (int i = 0; i < Patterns.length && (date = GeneralHelper.str2Date(str, Patterns[i])) == null; ++i) {
        }
        return date;
    }

    public static final Date str2ShortDate(String str) {
        return GeneralHelper.str2Date(str, SHORT_DATE_PATTERN);
    }

    public static final Date str2LongDate(String str) {
        return GeneralHelper.str2Date(str, LONG_DATE_PATTERN);
    }

    public static final Date str2LongDateWithMilliSecond(String str) {
        return GeneralHelper.str2Date(str, LONG_DATE_PATTERN_WITH_MILSEC);
    }

    public static final <T> T str2Object(Class<T> type, String v) {
        return GeneralHelper.str2Object(type, v, null);
    }

    public static final <T> T str2Object(Class<T> type, String v, TypeHandler<T> handler) {
        Object param = null;
        if (handler != null) {
            return handler.handle(v);
        }
        if (type == String.class) {
            param = GeneralHelper.safeTrimString(v);
        } else if (type == Integer.TYPE) {
            param = GeneralHelper.str2Int_0(v);
        } else if (type == Long.TYPE) {
            param = GeneralHelper.str2Long_0(v);
        } else if (type == Byte.TYPE) {
            param = GeneralHelper.str2Byte_0(v);
        } else if (type == Character.TYPE) {
            param = Character.valueOf(GeneralHelper.str2Char_0(v));
        } else if (type == Float.TYPE) {
            param = Float.valueOf(GeneralHelper.str2Float_0(v));
        } else if (type == Double.TYPE) {
            param = GeneralHelper.str2Double_0(v);
        } else if (type == Short.TYPE) {
            param = GeneralHelper.str2Short_0(v);
        } else if (type == Boolean.TYPE) {
            param = GeneralHelper.str2Boolean_False(v);
        } else if (type == Integer.class) {
            param = GeneralHelper.str2Int(v);
        } else if (type == Long.class) {
            param = GeneralHelper.str2Long(v);
        } else if (type == Byte.class) {
            param = GeneralHelper.str2Byte(v);
        } else if (type == Character.class) {
            param = GeneralHelper.str2Char(v);
        } else if (type == Float.class) {
            param = GeneralHelper.str2Float(v);
        } else if (type == Double.class) {
            param = GeneralHelper.str2Double(v);
        } else if (type == Short.class) {
            param = GeneralHelper.str2Short(v);
        } else if (type == Boolean.class) {
            param = GeneralHelper.str2Boolean(v);
        } else if (Date.class.isAssignableFrom(type)) {
            param = GeneralHelper.str2Date(v);
        } else {
            throw new IllegalArgumentException(String.format("object type '%s' not valid", type));
        }
        return (T)param;
    }

    public static final Object[] object2Array(Object obj) {
        Object[] array;
        if (obj == null) {
            array = new Object[]{obj};
        } else if (obj.getClass().isArray()) {
            Class<?> clazz = obj.getClass().getComponentType();
            if (Object.class.isAssignableFrom(clazz)) {
                array = (Object[])obj;
            } else {
                int length = Array.getLength(obj);
                if (length > 0) {
                    array = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        array[i] = Array.get(obj, i);
                    }
                } else {
                    array = new Object[]{};
                }
            }
        } else if (obj instanceof Collection) {
            array = ((Collection)obj).toArray();
        } else if (obj instanceof Iterable) {
            ArrayList list = new ArrayList();
            Iterator it = ((Iterable)obj).iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
            array = list.toArray();
        } else if (obj instanceof Iterator) {
            ArrayList list = new ArrayList();
            Iterator it = (Iterator)obj;
            while (it.hasNext()) {
                list.add(it.next());
            }
            array = list.toArray();
        } else if (obj instanceof Enumeration) {
            ArrayList list = new ArrayList();
            Enumeration it = (Enumeration)obj;
            while (it.hasMoreElements()) {
                list.add(it.nextElement());
            }
            array = list.toArray();
        } else {
            array = new Object[]{obj};
        }
        return array;
    }

    public static final Date addDate(Date date, int value) {
        return GeneralHelper.addDate(date, value, true);
    }

    public static final Date addDate(Date date, int value, boolean trimTime) {
        return GeneralHelper.addTime(date, 5, value, trimTime);
    }

    public static final Date addTime(Date date, int field, int value) {
        return GeneralHelper.addTime(date, field, value, false);
    }

    public static final Date addTime(Date date, int field, int value, boolean trimTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(field, value);
        if (trimTime) {
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        return c.getTime();
    }

    public static final String date2Str(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static final String regularSQLStr(String str, boolean includeWidlcard) {
        str = str.replace("'", "''");
        if (includeWidlcard) {
            str = str.replace('*', '%');
            str = str.replace('?', '_');
        }
        return str;
    }

    public static final ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    public static final Class<?> loadClass(String className) {
        Class<?> clazz = null;
        ClassLoader loader = GeneralHelper.getClassLoader(GeneralHelper.class);
        try {
            clazz = loader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static final Class<?> classForName(String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static final Class<?> classForName(String name, boolean initialize, ClassLoader loader) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name, initialize, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static final URL getClassResource(Class<?> clazz, String resPath) {
        URL url = clazz.getResource(resPath);
        if (url == null) {
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                url = loader.getResource(resPath);
            }
            if (url == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
                url = loader.getResource(resPath);
            }
        }
        return url;
    }

    public static final List<URL> getClassResources(Class<?> clazz, String resPath) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        Enumeration<URL> urls = null;
        try {
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                urls = loader.getResources(resPath);
            }
            if (!(urls != null && urls.hasMoreElements() || (loader = Thread.currentThread().getContextClassLoader()) == null)) {
                urls = loader.getResources(resPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (urls != null) {
            while (urls.hasMoreElements()) {
                urlList.add(urls.nextElement());
            }
        }
        return urlList;
    }

    public static final InputStream getClassResourceAsStream(Class<?> clazz, String resPath) {
        InputStream is = clazz.getResourceAsStream(resPath);
        if (is == null) {
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                is = loader.getResourceAsStream(resPath);
            }
            if (is == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
                is = loader.getResourceAsStream(resPath);
            }
        }
        return is;
    }

    public static final String getClassResourcePath(Class<?> clazz, String resPath) {
        return GeneralHelper.getClassResourcePath(clazz, resPath, DEFAULT_ENCODING);
    }

    public static final String getClassResourcePath(Class<?> clazz, String resPath, String pathEnc) {
        String path = null;
        try {
            URL url = GeneralHelper.getClassResource(clazz, resPath);
            if (url != null) {
                path = url.getPath();
                path = URLDecoder.decode(path, pathEnc);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public static final List<String> getClassResourcePaths(Class<?> clazz, String resPath) {
        return GeneralHelper.getClassResourcePaths(clazz, resPath, DEFAULT_ENCODING);
    }

    public static final List<String> getClassResourcePaths(Class<?> clazz, String resPath, String pathEnc) {
        ArrayList<String> pathList = new ArrayList<String>();
        try {
            List<URL> urlList = GeneralHelper.getClassResources(clazz, resPath);
            for (URL url : urlList) {
                String path = URLDecoder.decode(url.getPath(), pathEnc);
                pathList.add(path);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return pathList;
    }

    public static final String getClassPath(Class<?> clazz) {
        return GeneralHelper.getClassResourcePath(clazz, ".");
    }

    public static final String getResourceMessage(Locale locale, String resource, String key, Object ... params) {
        ResourceBundle bundle = ResourceBundle.getBundle(resource, locale);
        String msg = bundle.getString(key);
        if (params != null && params.length > 0) {
            msg = MessageFormat.format(msg, params);
        }
        return msg;
    }

    public static final String getResourceMessage(String resource, String key, Object ... params) {
        return GeneralHelper.getResourceMessage(Locale.getDefault(), resource, key, params);
    }

    public static final String getExceptionMessageStackString(Throwable e, int levels) {
        StringBuilder sb = new StringBuilder();
        if (levels == 0) {
            levels = Integer.MAX_VALUE;
        }
        for (int i = 0; i < levels; ++i) {
            if (i > 0) {
                sb.append("Caused by -> ");
            }
            sb.append(e.getClass().getName());
            String msg = e.getLocalizedMessage();
            if (msg != null) {
                sb.append(": ").append(msg);
            }
            if ((e = e.getCause()) == null) break;
        }
        return sb.toString();
    }

    public static final String getExceptionMessageStackString(Throwable e) {
        return GeneralHelper.getExceptionMessageStackString(e, 0);
    }

    public static final List<String> getExceptionMessageStack(Throwable e, int levels) {
        ArrayList<String> list = new ArrayList<String>();
        if (levels == 0) {
            levels = Integer.MAX_VALUE;
        }
        for (int i = 0; i < levels; ++i) {
            StringBuilder sb = new StringBuilder();
            if (i > 0) {
                sb.append("Caused by -> ");
            }
            sb.append(e.getClass().getName());
            String msg = e.getLocalizedMessage();
            if (msg != null) {
                sb.append(": ").append(msg);
            }
            list.add(sb.toString());
            e = e.getCause();
            if (e == null) break;
        }
        return list;
    }

    public static final List<String> getExceptionMessageStack(Throwable e) {
        return GeneralHelper.getExceptionMessageStack(e, 0);
    }

    public static final void printExceptionMessageStack(Throwable e, int levels, PrintStream ps) {
        List<String> list = GeneralHelper.getExceptionMessageStack(e, levels);
        for (String msg : list) {
            ps.println(msg);
        }
    }

    public static final void printExceptionMessageStack(Throwable e, int levels) {
        GeneralHelper.printExceptionMessageStack(e, levels, System.err);
    }

    public static final void printExceptionMessageStack(Throwable e, PrintStream ps) {
        GeneralHelper.printExceptionMessageStack(e, 0, ps);
    }

    public static final void printExceptionMessageStack(Throwable e) {
        GeneralHelper.printExceptionMessageStack(e, 0);
    }

    public static final <K, V> boolean tryPut(Map<K, V> map, K key, V value) {
        return GeneralHelper.tryPut(map, key, value, false);
    }

    public static final <K, V> boolean tryPut(Map<K, V> map, K key, V value, boolean replace) {
        if (replace || !map.containsKey(key)) {
            map.put(key, value);
            return true;
        }
        return false;
    }

    public static final <K, V> boolean syncTryPut(Map<K, V> map, K key, V value) {
        return GeneralHelper.syncTryPut(map, key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <K, V> boolean syncTryPut(Map<K, V> map, K key, V value, boolean replace) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return GeneralHelper.tryPut(map, key, value, replace);
        }
    }

    public static final <K, V> int tryPutAll(Map<K, V> map, Map<K, V> src) {
        return GeneralHelper.tryPutAll(map, src, false);
    }

    public static final <K, V> int tryPutAll(Map<K, V> map, Map<K, V> src, boolean replace) {
        if (replace) {
            map.putAll(src);
            return src.size();
        }
        int count = 0;
        Set<Map.Entry<K, V>> entries = src.entrySet();
        for (Map.Entry<K, V> e : entries) {
            if (map.containsKey(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
            ++count;
        }
        return count;
    }

    public static final <K, V> int syncTryPutAll(Map<K, V> map, Map<K, V> src) {
        return GeneralHelper.syncTryPutAll(map, src, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <K, V> int syncTryPutAll(Map<K, V> map, Map<K, V> src, boolean replace) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return GeneralHelper.tryPutAll(map, src, replace);
        }
    }

    public static final <K, V> boolean tryRemove(Map<K, V> map, K key) {
        if (map.containsKey(key)) {
            map.remove(key);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <K, V> boolean syncTryRemove(Map<K, V> map, K key) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return GeneralHelper.tryRemove(map, key);
        }
    }

    public static final <K, V> void tryClear(Map<K, V> map) {
        map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <K, V> void syncTryClear(Map<K, V> map) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            GeneralHelper.tryClear(map);
        }
    }

    public static final int getProcessId() {
        return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static final String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static final String getOSName() {
        return System.getProperty("os.name");
    }

    public static final boolean isWindowsPlatform() {
        return File.pathSeparatorChar == ';';
    }

    static {
        Locale[] locales;
        PATTERN_NUMERIC = Pattern.compile("^0$|^\\-?[1-9]+[0-9]*$");
        PATTERN_EMAIL_ADDR = Pattern.compile("^[a-z0-9_\\-]+(\\.[_a-z0-9\\-]+)*@([_a-z0-9\\-]+\\.)+([a-z]{2}|aero|arpa|biz|com|coop|edu|gov|info|int|jobs|mil|museum|name|nato|net|org|pro|travel)$");
        PATTERN_IP_ADDR = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        PATTERN_LINK = Pattern.compile("<a[^>]*href=\\\"[^\\s\\\"]+\\\"[^>]*>[^<]*<\\/a>");
        PATTERN_HTTP_URL = Pattern.compile("^(https?:\\/\\/)?([a-z]([a-z0-9\\-]*\\.)+([a-z]{2}|aero|arpa|biz|com|coop|edu|gov|info|int|jobs|mil|museum|name|nato|net|org|pro|travel)|(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))(\\/[a-z0-9_\\-\\.~]+)*(\\/([a-z0-9_\\-\\.]*)(\\?[a-z0-9+_\\-\\.%=&amp;]*)?)?(#[a-z][a-z0-9_]*)?$");
        PATTERN_XML_ESCAPES = Pattern.compile(".*[&|\"|'|<|>].*");
        SHORT_DATE_PATTERN = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy\\MM\\dd", "yyyyMMdd"};
        LONG_DATE_PATTERN = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy\\MM\\dd HH:mm:ss", "yyyyMMddHHmmss"};
        LONG_DATE_PATTERN_WITH_MILSEC = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy\\MM\\dd HH:mm:ss.SSS", "yyyyMMddHHmmssSSS"};
        AVAILABLE_LOCALES = new HashMap<String, Locale>();
        XML_ESCAPE_CHARS = new char[63][];
        OS_PLATFORM = GeneralHelper.getOSName();
        IS_WINDOWS_PLATFORM = GeneralHelper.isWindowsPlatform();
        NEWLINE_CHAR = IS_WINDOWS_PLATFORM ? "\r\n" : "\n";
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            AVAILABLE_LOCALES.put(locale.toString(), locale);
        }
        GeneralHelper.XML_ESCAPE_CHARS[38] = "&amp;".toCharArray();
        GeneralHelper.XML_ESCAPE_CHARS[60] = "&lt;".toCharArray();
        GeneralHelper.XML_ESCAPE_CHARS[62] = "&gt;".toCharArray();
        GeneralHelper.XML_ESCAPE_CHARS[34] = "&quot;".toCharArray();
        GeneralHelper.XML_ESCAPE_CHARS[39] = "&apos;".toCharArray();
    }

    public static class FileNameFileFilter
    implements FileFilter {
        protected static final int FLAGS = IS_WINDOWS_PLATFORM ? 2 : 0;
        Pattern pattern;

        public FileNameFileFilter(String name) {
            String exp = name;
            exp = exp.replace('.', '#');
            exp = exp.replaceAll("#", "\\\\.");
            exp = exp.replace('*', '#');
            exp = exp.replaceAll("#", ".*");
            exp = exp.replace('?', '#');
            exp = exp.replaceAll("#", ".?");
            exp = "^" + exp + "$";
            this.pattern = Pattern.compile(exp, FLAGS);
        }

        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            return matcher.matches();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PinYinComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Collator cmp = Collator.getInstance(Locale.CHINA);
            return cmp.compare(o1, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeHandler<T> {
        public T handle(String var1);
    }
}

