/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.utils;

import java.io.IOException;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);
    private static HttpClient client = null;

    public static String httpGet(String url) {
        String jsonStr = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpGet.getURI());
            }
        }
        catch (IOException e) {
            logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        return jsonStr;
    }

    public static String httpPost(String url, String param) {
        String jsonStr = null;
        JSONObject jsonParam = null;
        try {
            HttpResponse response;
            HttpPost httpPost = new HttpPost(url);
            if (null != param) {
                jsonParam = JSONObject.fromObject((Object)param);
            }
            if (null != jsonParam) {
                StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpPost.getURI());
            }
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        return jsonStr;
    }

    static {
        if (null == client) {
            client = HttpClients.createDefault();
        }
    }
}

