/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.pay.Util;

import com.chinaunicom.pay.Util.RsaEncodeUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class EncodeUtil {
    public static String publicEncode(String paramStr, String publicKey, String signKey) throws Exception {
        String sign = EncodeUtil.getSign(paramStr, signKey);
        Map<String, Object> map = RsaEncodeUtil.getMapFromJson(paramStr);
        map.put("sign", sign);
        String paramStr1 = RsaEncodeUtil.getJsonFromMap(map);
        PublicKey pk = RsaEncodeUtil.restorePublicKey(publicKey);
        byte[] encodedText = RsaEncodeUtil.rsaPublicEncode(pk, paramStr1.getBytes("UTF-8"));
        String result = Base64.encodeBase64String((byte[])encodedText);
        return result;
    }

    public static String publicDecode(String encodeStr, String publicKey) throws Exception {
        PublicKey pk = RsaEncodeUtil.restorePublicKey(publicKey);
        byte[] decodeBytes = RsaEncodeUtil.rsaPublicDecode(pk, Base64.decodeBase64((String)encodeStr));
        String result = new String(decodeBytes, "UTF-8");
        return result;
    }

    public static boolean signValid(String str, String signKey) throws Exception {
        Map<String, Object> paramMap = RsaEncodeUtil.getMapFromJson(str);
        String reqSign = paramMap.get("sign").toString();
        paramMap.remove("sign");
        String sign = EncodeUtil.getSign(paramMap, signKey);
        return reqSign.equals(sign);
    }

    public static String privateEncode(String paramStr, String privateKey, String signKey) throws Exception {
        String sign = EncodeUtil.getSign(paramStr, signKey);
        Map<String, Object> map = RsaEncodeUtil.getMapFromJson(paramStr);
        map.put("sign", sign);
        String paramStr1 = RsaEncodeUtil.getJsonFromMap(map);
        PrivateKey pk = RsaEncodeUtil.restorePrivateKey(privateKey);
        byte[] encodedText = RsaEncodeUtil.rsaPrivateEncode(pk, paramStr1.getBytes("UTF-8"));
        String result = Base64.encodeBase64String((byte[])encodedText);
        return result;
    }

    public static String privateDecode(String encodeStr, String privateKey) throws Exception {
        PrivateKey pk = RsaEncodeUtil.restorePrivateKey(privateKey);
        byte[] decodeBytes = RsaEncodeUtil.rsaPrivateDecode(pk, Base64.decodeBase64((String)encodeStr));
        String result = new String(decodeBytes, "UTF-8");
        return result;
    }

    public static String getSign(String param, String signKey) throws NoSuchAlgorithmException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Map<String, Object> paramMap = RsaEncodeUtil.getMapFromJson(param);
        return RsaEncodeUtil.sha1Sign(paramMap, signKey);
    }

    public static String getSign(Map<String, Object> paramMap, String signKey) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return RsaEncodeUtil.sha1Sign(paramMap, signKey);
    }

    public static String transcodeUtf(String json) {
        try {
            json = URLEncoder.encode(json, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static String decodeUtf(String json) {
        try {
            json = URLDecoder.decode(json, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return json;
    }
}

