/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseParameterMetaData;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@Deprecated
public class TableBasedPreparedStatement
extends AbstractPreparedStatement
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(TableBasedPreparedStatement.class);
    private static final String ERROR_SET_TABLE = "Please use setObject(ClickHouseExternalTable) method instead";
    private final ClickHouseSqlStatement parsedStmt;
    private final List<String> tables;
    private final ClickHouseExternalTable[] values;
    private final ClickHouseParameterMetaData paramMetaData;
    private final List<List<ClickHouseExternalTable>> batch;

    protected TableBasedPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, ClickHouseSqlStatement parsedStmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        Set<String> set;
        Set<String> set2 = set = parsedStmt != null ? parsedStmt.getTempTables() : null;
        if (set == null) {
            throw SqlExceptionUtils.clientError("Non-null table list is required");
        }
        this.parsedStmt = parsedStmt;
        int size = set.size();
        this.tables = new ArrayList<String>(size);
        this.tables.addAll(set);
        this.values = new ClickHouseExternalTable[size];
        ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(size);
        for (String name : set) {
            list.add(ClickHouseColumn.of((String)name, (ClickHouseDataType)ClickHouseDataType.JSON, (boolean)false, (ClickHouseColumn[])new ClickHouseColumn[0]));
        }
        this.paramMetaData = new ClickHouseParameterMetaData(Collections.unmodifiableList(list), this.mapper, connection.getTypeMap());
        this.batch = new LinkedList<List<ClickHouseExternalTable>>();
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            list.add(this.tables.get(i));
        }
        if (!list.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing table(s): %s", (Object[])new Object[]{list}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeAny(boolean asBatch) throws SQLException {
        this.ensureOpen();
        boolean continueOnError = false;
        if (asBatch) {
            if (this.batch.isEmpty()) {
                return ClickHouseValues.EMPTY_LONG_ARRAY;
            }
            continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        } else {
            if (!this.batch.isEmpty()) {
                throw SqlExceptionUtils.undeterminedExecutionError();
            }
            this.addBatch();
        }
        long[] results = new long[this.batch.size()];
        int index = 0;
        try {
            String sql = this.getSql();
            for (List<ClickHouseExternalTable> list : this.batch) {
                try (ClickHouseResponse r = this.executeStatement(sql, null, list, null);
                     ResultSet rs = this.updateResult(this.parsedStmt, r);){
                    if (asBatch && rs != null && this.parsedStmt.isQuery()) {
                        throw SqlExceptionUtils.queryInBatchError(results);
                    }
                    long rows = this.getLargeUpdateCount();
                    results[index] = rows > 0L ? rows : 0L;
                }
                catch (Exception e) {
                    if (!asBatch) {
                        throw SqlExceptionUtils.handle(e, new Throwable[0]);
                    }
                    results[index] = -3L;
                    if (!continueOnError) {
                        throw SqlExceptionUtils.batchUpdateError(e, results);
                    }
                    log.error((Object)"Failed to execute batch insert at %d of %d", new Object[]{index + 1, this.batch.size(), e});
                }
                ++index;
            }
        }
        finally {
            this.clearBatch();
        }
        return results;
    }

    @Override
    protected int getMaxParameterIndex() {
        return this.values.length;
    }

    protected String getSql() {
        return (String)this.getRequest().getStatements(false).get(0);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        if (!this.batch.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        ClickHouseSqlStatement stmt = new ClickHouseSqlStatement(this.getSql());
        return this.updateResult(this.parsedStmt, this.executeStatement(stmt, null, Arrays.asList(this.values), null));
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.ensureParams();
        if (!this.batch.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        try (ClickHouseResponse r = this.executeStatement(this.getSql(), null, Arrays.asList(this.values), null);){
            this.updateResult(this.parsedStmt, r);
            long l = this.getLargeUpdateCount();
            return l;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        if (!(x instanceof ClickHouseExternalTable)) {
            throw SqlExceptionUtils.clientError("Only ClickHouseExternalTable is allowed");
        }
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx] = (ClickHouseExternalTable)x;
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        if (!this.batch.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        ClickHouseSqlStatement stmt = new ClickHouseSqlStatement(this.getSql());
        return this.updateResult(this.parsedStmt, this.executeStatement(stmt, null, Arrays.asList(this.values), null)) != null;
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        this.ensureParams();
        this.batch.add(Collections.unmodifiableList(Arrays.asList(this.values)));
        this.clearParameters();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.paramMetaData;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }
}

