/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class ClickHouseEnum
implements Serializable {
    private static final long serialVersionUID = -978231193821209918L;
    public static final ClickHouseEnum EMPTY = new ClickHouseEnum(Collections.emptyList());
    private final int size;
    private final String[] names;
    private final int[] values;

    public static ClickHouseEnum of(Class<? extends Enum> clazz) {
        if (clazz == null || !Enum.class.isAssignableFrom(clazz)) {
            return EMPTY;
        }
        Enum[] constants = clazz.getEnumConstants();
        int size = constants.length;
        String[] names = new String[size];
        int[] values = new int[size];
        int i = 0;
        for (Enum e : clazz.getEnumConstants()) {
            names[i] = e.name();
            values[i] = e.ordinal();
            ++i;
        }
        return new ClickHouseEnum(names, values);
    }

    protected ClickHouseEnum(Collection<String> params) {
        this.size = params.size();
        this.names = new String[this.size];
        this.values = new int[this.size];
        int i = 0;
        for (String p : params) {
            int index = p.lastIndexOf(61);
            if (index <= 0) {
                throw new IllegalArgumentException("Invalid enum entry: " + p);
            }
            this.names[i] = ClickHouseUtils.unescape(p.substring(0, index));
            this.values[i] = Integer.parseInt(p.substring(index + 1));
            ++i;
        }
    }

    public ClickHouseEnum(String[] names, int[] values) {
        if (names == null || values == null) {
            throw new IllegalArgumentException("Non-null names and values are required");
        }
        if (names.length != values.length) {
            throw new IllegalArgumentException("Names and values should have same length");
        }
        this.size = names.length;
        this.names = names;
        this.values = values;
    }

    public String validate(String name) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].equals(name)) continue;
            return name;
        }
        throw new IllegalArgumentException("Unknown enum name: " + name);
    }

    public int validate(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != value) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    public String name(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != value) continue;
            return this.names[i];
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    public String nameNullable(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != value) continue;
            return this.names[i];
        }
        return null;
    }

    public int value(String name) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].equals(name)) continue;
            return this.values[i];
        }
        throw new IllegalArgumentException("Unknown enum name: " + name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.size;
        result = 31 * result + Arrays.hashCode(this.names);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseEnum other = (ClickHouseEnum)obj;
        return this.size == other.size && Arrays.equals(this.names, other.names) && Arrays.equals(this.values, other.values);
    }

    public String toSqlException() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            builder.append('\'').append(ClickHouseUtils.escape(this.names[i], '\'')).append('\'').append('=').append(this.values[i]).append(',');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public int size() {
        return this.size;
    }

    public String[] getNames() {
        return this.names;
    }

    public int[] getValues() {
        return this.values;
    }
}

