/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.network;

import com.contentsquare.android.error.analysis.ErrorAnalysis;
import com.contentsquare.android.error.analysis.network.ErrorAnalysisOkHttpClientKt;
import com.contentsquare.android.error.analysis.network.InstrumentOkHttpEnqueueCallback;
import com.contentsquare.android.internal.features.logging.Logger;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/contentsquare/android/error/analysis/network/ErrorAnalysisOkHttpClient;", "", "()V", "BODY_MAX_SIZE", "", "logger", "Lcom/contentsquare/android/internal/features/logging/Logger;", "enqueue", "", "call", "Lokhttp3/Call;", "callback", "Lokhttp3/Callback;", "execute", "Lokhttp3/Response;", "error-analysis_release"})
public final class ErrorAnalysisOkHttpClient {
    public static final ErrorAnalysisOkHttpClient INSTANCE = new ErrorAnalysisOkHttpClient();
    private static final Logger logger = new Logger("ErrorAnalysisOkHttpClient");
    public static final long BODY_MAX_SIZE = 0x100000L;

    private ErrorAnalysisOkHttpClient() {
    }

    @JvmStatic
    public static final Response execute(Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            long l = System.currentTimeMillis();
            try {
                call = call.execute();
            }
            catch (IOException iOException) {
                logger.d((Throwable)iOException, "Exception received", new Object[0]);
                throw iOException;
            }
            long l2 = System.currentTimeMillis();
            ErrorAnalysisOkHttpClientKt.sendNetworkMetric(ErrorAnalysis.Companion.getInstance(), (Response)call, l, l2);
        } else {
            call = call.execute();
        }
        return call;
    }

    @JvmStatic
    public static final void enqueue(Call object, Callback callback) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"call");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            InstrumentOkHttpEnqueueCallback instrumentOkHttpEnqueueCallback;
            Call call = object;
            long l = System.currentTimeMillis();
            object = instrumentOkHttpEnqueueCallback;
            instrumentOkHttpEnqueueCallback = new InstrumentOkHttpEnqueueCallback(callback, l);
            call.enqueue((Callback)object);
        } else {
            object.enqueue(callback);
        }
    }
}

