/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.network;

import com.contentsquare.android.error.analysis.ErrorAnalysis;
import com.contentsquare.android.error.analysis.network.InstrumentApacheHttpResponseHandler;
import com.contentsquare.android.error.analysis.network.NetworkEventBuilder;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ;\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010JA\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\u000f2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011JE\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014JK\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0016H\u0007J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fJ1\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0017J7\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0019JA\u0010\u0003\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u001b"}, d2={"Lcom/contentsquare/android/error/analysis/network/ErrorHttpClient;", "", "()V", "execute", "Lorg/apache/http/HttpResponse;", "client", "Lorg/apache/http/client/HttpClient;", "target", "Lorg/apache/http/HttpHost;", "request", "Lorg/apache/http/HttpRequest;", "errorAnalysis", "Lcom/contentsquare/android/error/analysis/ErrorAnalysis;", "T", "responseHandler", "Lorg/apache/http/client/ResponseHandler;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;Lcom/contentsquare/android/error/analysis/ErrorAnalysis;)Ljava/lang/Object;", "context", "Lorg/apache/http/protocol/HttpContext;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;Lcom/contentsquare/android/error/analysis/ErrorAnalysis;)Ljava/lang/Object;", "Lorg/apache/http/client/methods/HttpUriRequest;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;Lcom/contentsquare/android/error/analysis/ErrorAnalysis;)Ljava/lang/Object;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;", "(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;Lcom/contentsquare/android/error/analysis/ErrorAnalysis;)Ljava/lang/Object;", "error-analysis_release"})
public final class ErrorHttpClient {
    public static final ErrorHttpClient INSTANCE = new ErrorHttpClient();

    private ErrorHttpClient() {
    }

    @JvmStatic
    public static final HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest, (String)"request");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            httpClient = INSTANCE.execute(httpClient, httpUriRequest, ErrorAnalysis.Companion.getInstance());
        } else {
            httpClient = httpClient.execute(httpUriRequest);
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"{\n            client.execute(request)\n        }");
        }
        return httpClient;
    }

    @JvmStatic
    public static final HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest, HttpContext httpContext) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest, (String)"request");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            HttpClient httpClient2 = httpClient;
            httpClient = ErrorAnalysis.Companion.getInstance();
            httpClient = INSTANCE.execute(httpClient2, httpUriRequest, httpContext, (ErrorAnalysis)httpClient);
        } else {
            httpClient = httpClient.execute(httpUriRequest, httpContext);
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"{\n            client.exe\u2026quest, context)\n        }");
        }
        return httpClient;
    }

    @JvmStatic
    public static final <T> T execute(HttpClient httpClient, HttpUriRequest httpUriRequest, ResponseHandler<T> responseHandler) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            HttpClient httpClient2 = httpClient;
            httpClient = ErrorAnalysis.Companion.getInstance();
            object = INSTANCE.execute(httpClient2, httpUriRequest, responseHandler, (ErrorAnalysis)httpClient);
        } else {
            object = httpClient.execute(httpUriRequest, responseHandler);
        }
        return (T)object;
    }

    @JvmStatic
    public static final <T> T execute(HttpClient httpClient, HttpUriRequest httpUriRequest, ResponseHandler<T> responseHandler, HttpContext httpContext) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            HttpClient httpClient2 = httpClient;
            httpClient = ErrorAnalysis.Companion.getInstance();
            object = INSTANCE.execute(httpClient2, httpUriRequest, responseHandler, httpContext, (ErrorAnalysis)httpClient);
        } else {
            object = httpClient.execute(httpUriRequest, responseHandler, httpContext);
        }
        return (T)object;
    }

    @JvmStatic
    public static final HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            HttpClient httpClient2 = httpClient;
            httpClient = ErrorAnalysis.Companion.getInstance();
            httpClient = INSTANCE.execute(httpClient2, httpHost, httpRequest, (ErrorAnalysis)httpClient);
        } else {
            httpClient = httpClient.execute(httpHost, httpRequest);
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"{\n            client.exe\u2026arget, request)\n        }");
        }
        return httpClient;
    }

    @JvmStatic
    public static final HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            HttpClient httpClient2 = httpClient;
            httpClient = ErrorAnalysis.Companion.getInstance();
            httpClient = INSTANCE.execute(httpClient2, httpHost, httpRequest, httpContext, (ErrorAnalysis)httpClient);
        } else {
            httpClient = httpClient.execute(httpHost, httpRequest, httpContext);
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"{\n            client.exe\u2026quest, context)\n        }");
        }
        return httpClient;
    }

    @JvmStatic
    public static final <T> T execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            HttpClient httpClient2 = httpClient;
            httpClient = ErrorAnalysis.Companion.getInstance();
            object = INSTANCE.execute(httpClient2, httpHost, httpRequest, responseHandler, (ErrorAnalysis)httpClient);
        } else {
            object = httpClient.execute(httpHost, httpRequest, responseHandler);
        }
        return (T)object;
    }

    @JvmStatic
    public static final <T> T execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        if (ErrorAnalysis.Companion.getInstance().isEnabled()) {
            HttpClient httpClient2 = httpClient;
            httpClient = ErrorAnalysis.Companion.getInstance();
            object = INSTANCE.execute(httpClient2, httpHost, httpRequest, responseHandler, httpContext, (ErrorAnalysis)httpClient);
        } else {
            object = httpClient.execute(httpHost, httpRequest, responseHandler, httpContext);
        }
        return (T)object;
    }

    public final HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest, ErrorAnalysis errorAnalysis) {
        NetworkEventBuilder networkEventBuilder;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest, (String)"request");
        Intrinsics.checkNotNullParameter((Object)errorAnalysis, (String)"errorAnalysis");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        networkEventBuilder2(errorAnalysis);
        try {
            networkEventBuilder.setUrl(httpUriRequest.getURI().toString()).setHttpMethod(httpUriRequest.getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        httpClient = httpClient.execute(httpUriRequest);
        Object object = networkEventBuilder2;
        Object object2 = object;
        Object object3 = object;
        HttpClient httpClient2 = httpClient;
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client.execute(request)");
        networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
        ((NetworkEventBuilder)object2).setHttpResponseCode(httpClient2.getStatusLine().getStatusCode());
        ((NetworkEventBuilder)object3).build();
        return httpClient;
    }

    public final HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest, HttpContext httpContext, ErrorAnalysis errorAnalysis) {
        NetworkEventBuilder networkEventBuilder;
        HttpUriRequest httpUriRequest2 = httpUriRequest;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest2, (String)"request");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        ErrorAnalysis errorAnalysis2 = errorAnalysis;
        Intrinsics.checkNotNull((Object)errorAnalysis2);
        networkEventBuilder2(errorAnalysis2);
        try {
            networkEventBuilder.setUrl(httpUriRequest.getURI().toString()).setHttpMethod(httpUriRequest.getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        httpClient = httpClient.execute(httpUriRequest2, httpContext);
        Object object = networkEventBuilder2;
        Object object2 = object;
        Object object3 = object;
        HttpClient httpClient2 = httpClient;
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client.execute(request, context)");
        networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
        ((NetworkEventBuilder)object2).setHttpResponseCode(httpClient2.getStatusLine().getStatusCode());
        ((NetworkEventBuilder)object3).build();
        return httpClient;
    }

    public final <T> T execute(HttpClient object, HttpUriRequest httpUriRequest, ResponseHandler<T> responseHandler, ErrorAnalysis errorAnalysis) {
        InstrumentApacheHttpResponseHandler<T> instrumentApacheHttpResponseHandler;
        NetworkEventBuilder networkEventBuilder;
        HttpClient httpClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        Intrinsics.checkNotNullParameter((Object)errorAnalysis, (String)"errorAnalysis");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        networkEventBuilder2(errorAnalysis);
        try {
            networkEventBuilder.setUrl(httpUriRequest.getURI().toString()).setHttpMethod(httpUriRequest.getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        object = instrumentApacheHttpResponseHandler;
        instrumentApacheHttpResponseHandler = new InstrumentApacheHttpResponseHandler<T>(responseHandler, networkEventBuilder2);
        return (T)httpClient.execute(httpUriRequest, (ResponseHandler)object);
    }

    public final <T> T execute(HttpClient object, HttpUriRequest httpUriRequest, ResponseHandler<T> responseHandler, HttpContext httpContext, ErrorAnalysis errorAnalysis) {
        InstrumentApacheHttpResponseHandler<T> instrumentApacheHttpResponseHandler;
        NetworkEventBuilder networkEventBuilder;
        HttpClient httpClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUriRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        Intrinsics.checkNotNullParameter((Object)errorAnalysis, (String)"errorAnalysis");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        networkEventBuilder2(errorAnalysis);
        try {
            networkEventBuilder.setUrl(httpUriRequest.getURI().toString()).setHttpMethod(httpUriRequest.getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        object = instrumentApacheHttpResponseHandler;
        instrumentApacheHttpResponseHandler = new InstrumentApacheHttpResponseHandler<T>(responseHandler, networkEventBuilder2);
        return (T)httpClient.execute(httpUriRequest, (ResponseHandler)object, httpContext);
    }

    public final HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, ErrorAnalysis errorAnalysis) {
        NetworkEventBuilder networkEventBuilder;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        Intrinsics.checkNotNullParameter((Object)errorAnalysis, (String)"errorAnalysis");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        networkEventBuilder2(errorAnalysis);
        try {
            networkEventBuilder.setUrl(httpHost.toURI() + httpRequest.getRequestLine().getUri()).setHttpMethod(httpRequest.getRequestLine().getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        httpClient = httpClient.execute(httpHost, httpRequest);
        Object object = networkEventBuilder2;
        Object object2 = object;
        Object object3 = object;
        HttpClient httpClient2 = httpClient;
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client.execute(target, request)");
        networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
        ((NetworkEventBuilder)object2).setHttpResponseCode(httpClient2.getStatusLine().getStatusCode());
        ((NetworkEventBuilder)object3).build();
        return httpClient;
    }

    public final HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext, ErrorAnalysis errorAnalysis) {
        NetworkEventBuilder networkEventBuilder;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        Intrinsics.checkNotNullParameter((Object)errorAnalysis, (String)"errorAnalysis");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        networkEventBuilder2(errorAnalysis);
        try {
            networkEventBuilder.setUrl(httpHost.toURI() + httpRequest.getRequestLine().getUri()).setHttpMethod(httpRequest.getRequestLine().getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        httpClient = httpClient.execute(httpHost, httpRequest, httpContext);
        Object object = networkEventBuilder2;
        Object object2 = object;
        Object object3 = object;
        HttpClient httpClient2 = httpClient;
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client.execute(target, request, context)");
        networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
        ((NetworkEventBuilder)object2).setHttpResponseCode(httpClient2.getStatusLine().getStatusCode());
        ((NetworkEventBuilder)object3).build();
        return httpClient;
    }

    public final <T> T execute(HttpClient object, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, ErrorAnalysis errorAnalysis) {
        InstrumentApacheHttpResponseHandler<? extends T> instrumentApacheHttpResponseHandler;
        NetworkEventBuilder networkEventBuilder;
        HttpClient httpClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        Intrinsics.checkNotNullParameter((Object)errorAnalysis, (String)"errorAnalysis");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        networkEventBuilder2(errorAnalysis);
        try {
            networkEventBuilder.setUrl(httpHost.toURI() + httpRequest.getRequestLine().getUri()).setHttpMethod(httpRequest.getRequestLine().getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        object = instrumentApacheHttpResponseHandler;
        instrumentApacheHttpResponseHandler = new InstrumentApacheHttpResponseHandler<T>(responseHandler, networkEventBuilder2);
        return (T)httpClient.execute(httpHost, httpRequest, (ResponseHandler)object);
    }

    public final <T> T execute(HttpClient object, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext, ErrorAnalysis errorAnalysis) {
        InstrumentApacheHttpResponseHandler<? extends T> instrumentApacheHttpResponseHandler;
        NetworkEventBuilder networkEventBuilder;
        HttpClient httpClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpHost, (String)"target");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        Intrinsics.checkNotNullParameter((Object)errorAnalysis, (String)"errorAnalysis");
        NetworkEventBuilder networkEventBuilder2 = networkEventBuilder;
        networkEventBuilder2(errorAnalysis);
        try {
            networkEventBuilder.setUrl(httpHost.toURI() + httpRequest.getRequestLine().getUri()).setHttpMethod(httpRequest.getRequestLine().getMethod());
        }
        catch (IOException iOException) {
            networkEventBuilder2.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            throw iOException;
        }
        networkEventBuilder.setRequestStartTimeMillis(System.currentTimeMillis());
        object = instrumentApacheHttpResponseHandler;
        instrumentApacheHttpResponseHandler = new InstrumentApacheHttpResponseHandler<T>(responseHandler, networkEventBuilder2);
        return (T)httpClient.execute(httpHost, httpRequest, (ResponseHandler)object, httpContext);
    }
}

