/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.api.model;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.contentsquare.android.api.Currencies;
import com.contentsquare.android.sdk.e4;
import java.util.Locale;

public final class Transaction {
    @Nullable
    public String mId;
    public int mCurrency;
    @FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38)
    public float mValue;

    public Transaction(@NonNull TransactionBuilder transactionBuilder) {
        this.mId = transactionBuilder.mId;
        this.mCurrency = transactionBuilder.mCurrency;
        this.mValue = transactionBuilder.mValue;
    }

    @NonNull
    public static TransactionBuilder builder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, int n10) {
        return new TransactionBuilder(f10, n10, null);
    }

    @NonNull
    public static TransactionBuilder builder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, @NonNull String string2) {
        return new TransactionBuilder(f10, string2, null);
    }

    public /* synthetic */ Transaction(TransactionBuilder transactionBuilder, a a10) {
        this(transactionBuilder);
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    public int getCurrency() {
        return this.mCurrency;
    }

    public float getValue() {
        return this.mValue;
    }

    public static class TransactionBuilder {
        public static e4 sLogger = new e4("TransactionBuilder");
        @Nullable
        public String mId;
        public int mCurrency;
        public float mValue;

        public TransactionBuilder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, int n10) {
            objectArray2.mValue = f10;
            objectArray2.mCurrency = Currencies.fromInteger(n10);
            if (objectArray2.mCurrency == -1) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n10;
                sLogger.c("Invalid currency code: \"%d\". Transaction currency is set to \"unknown(-1)\".", objectArray2);
            }
        }

        public TransactionBuilder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, @NonNull String string2) {
            objectArray2.mValue = f10;
            objectArray2.mCurrency = Currencies.fromString(string2.toUpperCase(Locale.ROOT));
            if (objectArray2.mCurrency == -1) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string2;
                sLogger.c("Invalid currency string: \"%s\". Transaction currency is set to \"unknown(-1)\".", objectArray2);
            }
        }

        public /* synthetic */ TransactionBuilder(float f10, int n10, a a10) {
            this(f10, n10);
        }

        public /* synthetic */ TransactionBuilder(float f10, String string2, a a10) {
            this(f10, string2);
        }

        public TransactionBuilder id(@NonNull String string2) {
            this.mId = string2;
            return this;
        }

        public Transaction build() {
            return new Transaction(this, null);
        }
    }
}

