/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.features.logging;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.common.android.instantiables.BuildConfigInstantiable;
import com.contentsquare.android.common.features.logging.CsLogPrinter;
import java.util.Locale;

public class Logger {
    @VisibleForTesting
    @NonNull
    static CsLogPrinter sLogPrinter = new CsLogPrinter();
    @NonNull
    static final CsLogPrinter.Printer DEFAULT_PRINTER;
    @VisibleForTesting
    @NonNull
    public static CsLogPrinter.Printer sPrinter;
    @VisibleForTesting
    static final String CS_LIB = "CSLIB";
    @VisibleForTesting
    @NonNull
    public static BuildConfigInstantiable sBuildConfigInstantiable;
    @NonNull
    private final String mTag;

    public Logger() {
        this.mTag = CS_LIB;
    }

    public Logger(String string) {
        this.mTag = Logger.buildTag(string);
    }

    public static void setLogLevel(CsLogPrinter.LogType logType) {
        sPrinter = !sBuildConfigInstantiable.isDebug() && logType != CsLogPrinter.LogType.VERBOSE ? sLogPrinter.createPrinter(logType) : sLogPrinter.createPrinter(CsLogPrinter.LogType.VERBOSE);
    }

    public static void v(String string, String string2) {
        sPrinter.v(Logger.buildTag(string), string2);
    }

    public static void v(String string, String string2, Throwable throwable) {
        sPrinter.v(Logger.buildTag(string), string2, throwable);
    }

    public static void d(String string, String string2) {
        sPrinter.d(Logger.buildTag(string), string2);
    }

    public static void d(String string, String string2, Throwable throwable) {
        sPrinter.d(Logger.buildTag(string), string2, throwable);
    }

    public static void i(String string) {
        sPrinter.i(CS_LIB, string);
    }

    public static void i(String string, Throwable throwable) {
        sPrinter.i(CS_LIB, string, throwable);
    }

    public static void w(String string, String string2) {
        sPrinter.w(Logger.buildTag(string), string2);
    }

    public static void w(String string, String string2, Throwable throwable) {
        sPrinter.w(Logger.buildTag(string), string2, throwable);
    }

    public static void e(String string, String string2) {
        sPrinter.e(Logger.buildTag(string), string2);
    }

    public static void e(String string, String string2, Throwable throwable) {
        sPrinter.e(Logger.buildTag(string), string2, throwable);
    }

    public static void p(String string) {
        sPrinter.p(CS_LIB, string);
    }

    public static void p(String string, Object ... objectArray) {
        sPrinter.p(CS_LIB, String.format(string, objectArray));
    }

    @NonNull
    private static String buildTag(String string) {
        return "CSLIB|" + string;
    }

    static {
        sPrinter = DEFAULT_PRINTER = sLogPrinter.createPrinter(CsLogPrinter.LogType.PUBLIC);
        sBuildConfigInstantiable = new BuildConfigInstantiable();
    }

    public void d(String string) {
        sPrinter.d(this.mTag, string);
    }

    public void d(String string, Object ... objectArray) {
        String string2 = ((Logger)((Object)string2)).mTag;
        sPrinter.d(string2, String.format(string, objectArray));
    }

    public void d(Throwable throwable, String string, Object ... objectArray) {
        String string2 = ((Logger)((Object)string2)).mTag;
        sPrinter.d(string2, String.format(string, objectArray), throwable);
    }

    public void i(String string, Object ... objectArray) {
        sPrinter.i(CS_LIB, String.format(Locale.ENGLISH, string, objectArray));
    }

    public void i(Throwable throwable, String string, Object ... objectArray) {
        sPrinter.i(CS_LIB, String.format(Locale.ENGLISH, string, objectArray), throwable);
    }

    public void w(String string, Object ... objectArray) {
        String string2 = ((Logger)((Object)string2)).mTag;
        sPrinter.w(string2, String.format(string, objectArray));
    }

    public void w(Throwable throwable, String string, Object ... objectArray) {
        String string2 = ((Logger)((Object)string2)).mTag;
        sPrinter.w(string2, String.format(string, objectArray), throwable);
    }

    public void e(String string, Object ... objectArray) {
        String string2 = ((Logger)((Object)string2)).mTag;
        sPrinter.e(string2, String.format(string, objectArray));
    }

    public void e(Throwable throwable, String string, Object ... objectArray) {
        String string2 = ((Logger)((Object)string2)).mTag;
        sPrinter.e(string2, String.format(string, objectArray), throwable);
    }
}

