/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.features.logging;

import androidx.annotation.NonNull;
import com.contentsquare.android.common.features.logging.CsLogPrinter;
import com.contentsquare.android.common.features.logging.Logger;
import com.contentsquare.android.common.features.preferences.PreferencesKey;
import com.contentsquare.android.common.features.preferences.PreferencesStore;

public class LoggerLevelChooser
implements PreferencesStore.PreferencesStoreListener {
    @NonNull
    private final PreferencesStore mPreferencesStore;
    @NonNull
    private final LoggerNonStatic mLoggerNonStatic;

    public LoggerLevelChooser(LoggerNonStatic loggerNonStatic, PreferencesStore preferencesStore) {
        this.mPreferencesStore = preferencesStore;
        preferencesStore.registerOnChangedListener(this);
        this.mLoggerNonStatic = loggerNonStatic;
        this.resolveLogLevel();
    }

    private void resolveLogLevel() {
        CsLogPrinter.LogType logType = CsLogPrinter.LogType.PUBLIC;
        if (this.mPreferencesStore.getBoolean(PreferencesKey.CLIENT_MODE_ACTIVATION_STATE, false)) {
            logType = CsLogPrinter.LogType.INFO;
        }
        if (this.mPreferencesStore.getBoolean(PreferencesKey.VERBOSE_LOG, false)) {
            logType = CsLogPrinter.LogType.VERBOSE;
        }
        this.mLoggerNonStatic.setLogLevel(logType);
    }

    @Override
    public void onPreferenceChanged(String string) {
        if (PreferencesKey.VERBOSE_LOG.isEqualTo(string) || PreferencesKey.CLIENT_MODE_ACTIVATION_STATE.isEqualTo(string)) {
            this.resolveLogLevel();
        }
    }

    public static class LoggerNonStatic {
        public void setLogLevel(CsLogPrinter.LogType logType) {
            Logger.setLogLevel(logType);
        }
    }
}

