/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.features.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.common.features.logging.Logger;
import com.contentsquare.android.common.features.preferences.PreferencesKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class PreferencesStore
implements SharedPreferences.OnSharedPreferenceChangeListener {
    @NonNull
    private static final String CONTENTSQUARE_SHARED_PREFS = "CONTENTSQUARE_SHARED_PREFS";
    @NonNull
    @VisibleForTesting
    public static Logger sLogger = new Logger("PreferencesStore");
    @VisibleForTesting
    @Nullable
    public static PreferencesStore sPreferencesStore;
    @NonNull
    private final Map<PreferencesStoreListener, Boolean> mListeners = new WeakHashMap<PreferencesStoreListener, Boolean>();
    @NonNull
    private final Context mApplicationContext;

    @NonNull
    private SharedPreferences getSharedPreferences() {
        return this.mApplicationContext.getSharedPreferences(CONTENTSQUARE_SHARED_PREFS, 0);
    }

    public PreferencesStore(Context context) {
        this.mApplicationContext = context;
        this.getSharedPreferences().registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void putString(PreferencesKey preferencesKey, String string) {
        this.getSharedPreferences().edit().putString(preferencesKey.toString(), string).apply();
    }

    public void putStringSet(PreferencesKey preferencesKey, Set<String> set) {
        this.getSharedPreferences().edit().putStringSet(preferencesKey.toString(), set).apply();
    }

    public void putInt(PreferencesKey preferencesKey, int n10) {
        this.getSharedPreferences().edit().putInt(preferencesKey.toString(), n10).apply();
    }

    public void putLong(PreferencesKey preferencesKey, long l10) {
        this.getSharedPreferences().edit().putLong(preferencesKey.toString(), l10).apply();
    }

    public void putFloat(PreferencesKey preferencesKey, float f10) {
        this.getSharedPreferences().edit().putFloat(preferencesKey.toString(), f10).apply();
    }

    public void putBoolean(PreferencesKey preferencesKey, boolean bl) {
        this.getSharedPreferences().edit().putBoolean(preferencesKey.toString(), bl).apply();
    }

    @Nullable
    public String getString(PreferencesKey preferencesKey, String string) {
        return this.getSharedPreferences().getString(preferencesKey.toString(), string);
    }

    @Nullable
    public Set<String> getStringSet(PreferencesKey preferencesKey, Set<String> set) {
        return this.getSharedPreferences().getStringSet(preferencesKey.toString(), set);
    }

    public int getInt(PreferencesKey preferencesKey, int n10) {
        return this.getSharedPreferences().getInt(preferencesKey.toString(), n10);
    }

    public long getLong(PreferencesKey preferencesKey, long l10) {
        return this.getSharedPreferences().getLong(preferencesKey.toString(), l10);
    }

    public float getFloat(PreferencesKey preferencesKey, float f10) {
        return this.getSharedPreferences().getFloat(preferencesKey.toString(), f10);
    }

    public boolean getBoolean(PreferencesKey preferencesKey, boolean bl) {
        return this.getSharedPreferences().getBoolean(preferencesKey.toString(), bl);
    }

    public void registerOnChangedListener(PreferencesStoreListener preferencesStoreListener) {
        this.mListeners.put(preferencesStoreListener, Boolean.TRUE);
    }

    public void unregisterOnChangedListener(PreferencesStoreListener preferencesStoreListener) {
        this.mListeners.remove(preferencesStoreListener);
    }

    public void removeGdprKeys() {
        PreferencesStore preferencesStore = preferencesStore.getSharedPreferences().edit();
        for (PreferencesKey preferencesKey : PreferencesKey.values()) {
            if (!preferencesKey.isGdpr()) continue;
            preferencesStore.remove(preferencesKey.toString());
        }
        preferencesStore.apply();
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string) {
        if (string != null) {
            Iterator<PreferencesStoreListener> iterator = new HashSet<PreferencesStoreListener>(((PreferencesStore)((Object)iterator)).mListeners.keySet()).iterator();
            while (iterator.hasNext()) {
                ((PreferencesStoreListener)iterator.next()).onPreferenceChanged(string);
            }
        }
    }

    public static interface PreferencesStoreListener {
        public void onPreferenceChanged(String var1);
    }
}

