/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.utils.http;

import android.net.Uri;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.common.features.logging.Logger;
import com.contentsquare.android.common.utils.ExtensionsKt;
import com.contentsquare.android.common.utils.http.HttpStatusCode;
import com.contentsquare.android.common.utils.http.HttpStatusCodeCategory;
import com.contentsquare.android.common.utils.string.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpConnection {
    static final String GET = "GET";
    static final String POST = "POST";
    static final String HEAD = "HEAD";
    static final String OPTIONS = "OPTIONS";
    static final String PUT = "PUT";
    static final String DELETE = "DELETE";
    static final String TRACE = "TRACE";
    static final int TIMEOUT_CONNECT = 1000;
    private static final int TIMEOUT_READ = 10000;
    private static final char EQUALS = '=';
    private static final char AND = '&';
    private final Logger mLog;

    public HttpConnection() {
        Logger logger;
        Logger logger2 = logger;
        logger = new Logger("HttpConnection");
        v1.mLog = logger2;
    }

    private HttpResponse handleError(Exception exception) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(500);
        httpResponse.setException(exception);
        return httpResponse;
    }

    private void logPublicError(String string, Exception exception) {
        block7: {
            URI uRI;
            URI uRI2 = uRI;
            if (!ExtensionsKt.isContentsquareUrl(new URI(string))) break block7;
            String string2 = "Could not dispatch events: [FAILED TO REQUEST: %s://%s | DESCRIPTION: %s]";
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            int n10 = 0;
            objectArray2[n10] = uRI2.getScheme();
            n10 = 1;
            objectArray2[n10] = uRI2.getHost();
            n10 = 2;
            try {
                objectArray[n10] = exception.getLocalizedMessage();
                Logger.p(string2, objectArray);
            }
            catch (URISyntaxException uRISyntaxException) {
                Object[] objectArray3 = new Object[1];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = string;
                objectArray4.mLog.d(uRISyntaxException, "Cannot parse url: %s", objectArray4);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public HttpResponse performGetWithFormdata(String string, List<Pair> object) {
        Throwable throwable2;
        HttpURLConnection httpURLConnection;
        block16: {
            HttpResponse httpResponse;
            block17: {
                block15: {
                    block14: {
                        HttpResponse httpResponse2;
                        httpURLConnection = null;
                        httpResponse = httpResponse2;
                        HttpConnection httpConnection = string2;
                        httpResponse();
                        try {
                            object = httpConnection.buildGetUrl(string, (List<Pair>)object);
                            httpURLConnection = httpConnection.openConnection(GET, (String)object);
                        }
                        catch (NullPointerException nullPointerException) {
                            break block14;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                            break block14;
                        }
                        try {
                            httpURLConnection.connect();
                            httpResponse.setStatus(httpURLConnection.getResponseCode());
                            {
                                ((HttpConnection)((Object)string2)).mLog.d("GET: Connection open, status %d, url : %s ", httpResponse.getStatus(), object);
                            }
                        }
                        catch (Throwable throwable2) {}
                        {
                            if (httpResponse2.positive()) {
                                httpResponse.setStringResponse(((HttpConnection)((Object)string2)).readStream(httpURLConnection.getInputStream()));
                            }
                            break block15;
                        }
                        break block16;
                    }
                    HttpConnection httpConnection = string2;
                    String string2 = "Exception while processing HttpGet Request on %s ";
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    {
                        void var2_6;
                        objectArray[0] = string;
                        ((HttpConnection)((Object)string2)).mLog.e((Throwable)var2_6, string2, objectArray2);
                        httpConnection.logPublicError(string, (Exception)var2_6);
                        httpResponse.setStatus(500);
                        httpResponse.setException((Throwable)var2_6);
                    }
                    if (httpURLConnection == null) break block17;
                }
                httpURLConnection.disconnect();
            }
            return httpResponse;
        }
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        throw throwable2;
    }

    @NonNull
    public HttpResponse performPostWithJson(String string, JSONObject jSONObject) {
        return this.performPostWithJson(string, jSONObject, Collections.emptyMap());
    }

    @NonNull
    public HttpResponse performPostWithJson(String string, JSONObject object, Map<String, String> map) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = object;
        objectArray[2] = map;
        this.mLog.d("Performing post on %s with %s and %s", objectArray2);
        object = object.toString();
        object = object == null ? null : (Object)object.trim().getBytes(Charset.forName("UTF-8"));
        return this.performHttpPost(string, (byte[])object, map);
    }

    @NonNull
    public HttpResponse performPostWithJsonArray(String string, JSONArray object) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = object;
        this.mLog.d("Performing post on %s with %s ", objectArray2);
        object = object.toString();
        object = object == null ? null : (Object)object.trim().getBytes(Charset.forName("UTF-8"));
        return this.performHttpPost(string, (byte[])object);
    }

    @NonNull
    public HttpResponse performHttpPost(String string, byte[] byArray) {
        return this.performHttpPost(string, byArray, Collections.emptyMap());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public HttpResponse performHttpPost(String string, byte[] byArray, Map<String, String> map) {
        Throwable throwable2;
        HttpURLConnection httpURLConnection;
        block13: {
            Object[] objectArray;
            void v62;
            Logger logger;
            String string2;
            HttpConnection httpConnection;
            void v22;
            void var3_7;
            HttpConnection httpConnection2;
            HttpURLConnection httpURLConnection2;
            Object object;
            block12: {
                if (byArray == null) {
                    return ((HttpConnection)object).handleError(new NullPointerException("[toString] : return null"));
                }
                httpURLConnection = null;
                try {
                    httpURLConnection = ((HttpConnection)object).openConnection(POST, string);
                    if (!map.isEmpty()) {
                        for (String string3 : map.keySet()) {
                            httpURLConnection.setRequestProperty(string3, map.get(string3));
                        }
                    }
                    object = ((HttpConnection)object).performPost(httpURLConnection, string, byArray);
                    if (httpURLConnection == null) break block12;
                }
                catch (Throwable throwable2) {
                    break block13;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                httpURLConnection.disconnect();
            }
            return object;
            {
                httpURLConnection2 = httpURLConnection;
                httpConnection2 = object;
                v22 = var3_7;
                httpConnection = object;
                string2 = string;
                logger = ((HttpConnection)object).mLog;
                v62 = var3_7;
                object = "Exception while processing HttpPOST Request on %s \n  for json: %s";
                objectArray = new Object[2];
            }
            Object[] objectArray2 = objectArray;
            {
                objectArray[0] = string;
                objectArray[1] = byArray;
                logger.e((Throwable)v62, (String)object, objectArray2);
                httpConnection.logPublicError(string2, (Exception)var3_7);
                object = httpConnection2.handleError((Exception)v22);
            }
            if (httpURLConnection2 != null) {
                httpURLConnection.disconnect();
            }
            return object;
        }
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        throw throwable2;
    }

    @NonNull
    @VisibleForTesting
    public HttpResponse performPost(HttpURLConnection httpURLConnection, String string, byte[] objectArray) {
        HttpResponse httpResponse;
        HttpResponse httpResponse2 = httpResponse;
        httpResponse2();
        long l10 = System.currentTimeMillis();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write((byte[])objectArray);
        outputStream.flush();
        outputStream.close();
        long l11 = System.currentTimeMillis();
        httpResponse2.setStatus(httpURLConnection.getResponseCode());
        httpResponse2.setDataSentBytes(objectArray.length);
        httpResponse2.setTimeSpentMsec(l11 - l10);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = String.valueOf(httpResponse2.getStatus());
        objectArray2[1] = string;
        objectArray4.mLog.d("POST: Connection open, status %s, url : %s", objectArray);
        if (httpResponse.positive()) {
            httpResponse2.setStringResponse(objectArray4.readStream(httpURLConnection.getInputStream()));
        } else {
            httpResponse2.setException(new UnsupportedOperationException("Server error status : " + httpResponse2.getStatus()));
        }
        Object[] objectArray3 = new Object[1];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = httpResponse2.getStringResponse();
        objectArray4.mLog.d("Received response : %s", objectArray4);
        return httpResponse2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    @VisibleForTesting
    public HttpURLConnection openConnection(String string, String string2) {
        String string3 = string;
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        objectArray[0] = string;
        objectArray[1] = string2;
        ((HttpConnection)object).mLog.d("opening a %s connection to %s", (Object[])object);
        object = (HttpURLConnection)new URL(string2).openConnection();
        ((HttpURLConnection)object).setRequestMethod(string);
        ((URLConnection)object).setRequestProperty("Charset", "UTF-8");
        ((URLConnection)object).setUseCaches(false);
        ((URLConnection)object).setAllowUserInteraction(false);
        ((URLConnection)object).setConnectTimeout(1000);
        ((URLConnection)object).setReadTimeout(10000);
        string3.getClass();
        if (!string3.equals(GET)) {
            if (!string.equals(POST)) throw new RuntimeException("HTTP Methods other than POST and GET are not implemented.");
            Object object2 = object;
            ((URLConnection)object2).setDoInput(true);
            ((URLConnection)object2).setDoOutput(true);
            ((URLConnection)object2).setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            return object;
        } else {
            ((URLConnection)object).setRequestProperty("Content-length", "0");
        }
        return object;
    }

    @VisibleForTesting
    public String buildGetUrl(String string, List<Pair> builder) {
        if (builder == null) {
            return string;
        }
        Uri.Builder builder2 = builder;
        builder = Uri.parse((String)string).buildUpon();
        for (Pair pair : builder2) {
            builder.appendQueryParameter(pair.first.toString(), pair.second.toString());
        }
        String string2 = builder.build().toString();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = "";
        objectArray2.mLog.d("Get URL transformed to %s", objectArray2);
        return string2;
    }

    @Nullable
    @VisibleForTesting
    public String urlEncodeRequestParameters(List<Pair> list) {
        StringBuilder stringBuilder;
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n10 = list.size();
        for (int i10 = 0; i10 < n10; ++i10) {
            Pair pair = list.get(i10);
            stringBuilder2.append(Strings.encode(String.valueOf(pair.first))).append('=').append(Strings.encode(String.valueOf(pair.second)));
            if (i10 >= n10 - 1) continue;
            stringBuilder2.append('&');
        }
        return stringBuilder2.toString();
    }

    @VisibleForTesting
    public String readStream(InputStream object) {
        StringBuilder stringBuilder;
        InputStreamReader inputStreamReader;
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2 = bufferedReader;
        Object object2 = inputStreamReader;
        inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
        bufferedReader = new BufferedReader((Reader)object2);
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        while ((object2 = bufferedReader2.readLine()) != null) {
            ((StringBuilder)object).append((String)object2).append('\n');
        }
        bufferedReader2.close();
        return ((StringBuilder)object).toString();
    }

    public static class HttpResponse {
        private int mStatus = -1;
        private String mStringResponse = null;
        private Throwable mException = null;
        private long mTimeSpentMsec = 0L;
        private long mDataSentBytes = 0L;

        public int getStatus() {
            return this.mStatus;
        }

        public void setStatus(int n10) {
            this.mStatus = n10;
        }

        public long getTimeSpentMsec() {
            return this.mTimeSpentMsec;
        }

        public void setTimeSpentMsec(long l10) {
            this.mTimeSpentMsec = l10;
        }

        public long getDataSentBytes() {
            return this.mDataSentBytes;
        }

        public void setDataSentBytes(int n10) {
            this.mDataSentBytes = n10;
        }

        @Nullable
        public String getStringResponse() {
            return this.mStringResponse;
        }

        public void setStringResponse(String string) {
            this.mStringResponse = string;
        }

        @Nullable
        public Throwable getException() {
            return this.mException;
        }

        public void setException(Throwable throwable) {
            this.mException = throwable;
        }

        public boolean positive() {
            return HttpStatusCode.checkStatus(this.getStatus()) == HttpStatusCodeCategory.SUCCESS;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpMethod {
    }
}

