/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.utils.recycler;

import com.contentsquare.android.common.utils.recycler.CreateInstance;
import com.contentsquare.android.common.utils.recycler.RecyclerWrapper;
import com.contentsquare.android.common.utils.recycler.RecyclerWrapperQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00028\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/contentsquare/android/common/utils/recycler/Recycler;", "T", "", "()V", "recyclerIn", "Lcom/contentsquare/android/common/utils/recycler/RecyclerWrapperQueue;", "recyclerOut", "obtain", "createInstance", "Lcom/contentsquare/android/common/utils/recycler/CreateInstance;", "(Lcom/contentsquare/android/common/utils/recycler/CreateInstance;)Ljava/lang/Object;", "recycle", "", "item", "(Ljava/lang/Object;)V", "toString", "", "common_release"})
public final class Recycler<T> {
    @NotNull
    private final RecyclerWrapperQueue<T> recyclerIn;
    @NotNull
    private final RecyclerWrapperQueue<T> recyclerOut;

    public Recycler() {
        RecyclerWrapperQueue recyclerWrapperQueue;
        RecyclerWrapperQueue recyclerWrapperQueue2;
        Object object = recyclerWrapperQueue2;
        recyclerWrapperQueue2 = new RecyclerWrapperQueue();
        v1.recyclerIn = object;
        object = recyclerWrapperQueue;
        recyclerWrapperQueue = new RecyclerWrapperQueue();
        v1.recyclerOut = object;
    }

    public final synchronized T obtain(CreateInstance<T> createInstance) {
        Intrinsics.checkNotNullParameter(createInstance, (String)"createInstance");
        RecyclerWrapper<T> recyclerWrapper = this.recyclerOut.obtain();
        T t10 = recyclerWrapper.getItem();
        if (t10 == null) {
            t10 = createInstance.create();
            recyclerWrapper.setItem(t10);
        }
        this.recyclerIn.recycle(recyclerWrapper);
        return t10;
    }

    public final synchronized void recycle(T t10) {
        Recycler recycler = recyclerWrapper;
        RecyclerWrapper<T> recyclerWrapper = recycler.recyclerIn.obtain();
        recyclerWrapper.setItem(t10);
        recycler.recyclerOut.recycle(recyclerWrapper);
    }

    @NotNull
    public String toString() {
        return "Recycler{in=" + this.recyclerIn + ", out=" + this.recyclerOut + "}";
    }
}

