/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.utils.string;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.contentsquare.android.common.features.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Strings {
    public static final String UTF_8 = "UTF-8";
    @NonNull
    private static final Logger LOGGER = new Logger("Strings");

    private Strings() {
    }

    @NonNull
    public static String nullToEmpty(String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public static String emptyToNull(String string) {
        if (Strings.isNullOrEmpty(string)) {
            string = null;
        }
        return string;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isBoolean(String string) {
        return "true".equals(string) || "false".equals(string);
    }

    public static boolean isInteger(String string) {
        return TextUtils.isDigitsOnly((CharSequence)string) && !string.isEmpty();
    }

    public static String encode(String string) {
        if (Strings.isNullOrEmpty(string)) {
            return string;
        }
        try {
            return URLEncoder.encode(string, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.w(unsupportedEncodingException, "Failed to encode sting to UTF, exception : ", new Object[0]);
            return null;
        }
    }

    @NonNull
    public static String capitalizeFirstLetter(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            char c10 = cArray[0];
            if (Character.isLowerCase(c10)) {
                cArray[0] = Character.toUpperCase(c10);
                return String.valueOf(cArray);
            }
            return string;
        }
        return string;
    }
}

