/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.common.error.analysis.NetworkEvent;
import com.contentsquare.android.common.features.logging.Logger;
import com.contentsquare.android.common.utils.ScreenViewTracker;
import com.contentsquare.android.error.analysis.NetworkMetric;
import com.contentsquare.android.error.analysis.internal.crash.AndroidThreadReport;
import com.contentsquare.android.error.analysis.internal.crash.CrashEventReporter;
import com.contentsquare.android.error.analysis.internal.crash.CrashEventWriterReader;
import com.contentsquare.android.error.analysis.internal.crash.NetworkDispatcher;
import com.contentsquare.android.error.analysis.internal.network.NativeNetworkEventProcessor;
import com.contentsquare.android.error.analysis.internal.network.NetworkEventCounter;
import com.contentsquare.android.error.analysis.internal.network.WebViewNetworkEventProcessor;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventCompressor;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventConfigurator;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventEncryptor;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventFilterKt;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventPIIAnonymizer;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventUrlProcessor;
import com.contentsquare.android.error.analysis.internal.network.processors.encryption.AsymmetricCryptor;
import com.contentsquare.android.error.analysis.internal.network.processors.encryption.SymmetricCryptor;
import com.contentsquare.android.error.analysis.internal.util.SdkDataProvider;
import com.contentsquare.android.error.analysis.internal.util.SdkDataProviderImpl;
import com.contentsquare.android.sdk.d6;
import com.contentsquare.android.sdk.e2;
import com.contentsquare.android.sdk.e6;
import com.contentsquare.android.sdk.fd;
import com.contentsquare.android.sdk.i2;
import com.contentsquare.android.sdk.r1;
import com.contentsquare.android.sdk.rb;
import com.contentsquare.android.sdk.s1;
import com.contentsquare.android.sdk.s7;
import com.contentsquare.android.sdk.w1;
import com.contentsquare.android.sdk.wa;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 32\u00020\u0001:\u000234B'\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0007J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u000f\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020!H\u0007J\u0017\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020!H\u0002J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020&2\b\b\u0002\u0010-\u001a\u00020&J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u00102\u001a\u00020\u0018H\u0007R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/contentsquare/android/error/analysis/ErrorAnalysis;", "", "nativeNetworkEventProcessor", "Lcom/contentsquare/android/error/analysis/internal/network/NativeNetworkEventProcessor;", "webViewNetworkEventProcessor", "Lcom/contentsquare/android/error/analysis/internal/network/WebViewNetworkEventProcessor;", "networkEventCounter", "Lcom/contentsquare/android/error/analysis/internal/network/NetworkEventCounter;", "sdkDataProvider", "Lcom/contentsquare/android/error/analysis/internal/util/SdkDataProvider;", "(Lcom/contentsquare/android/error/analysis/internal/network/NativeNetworkEventProcessor;Lcom/contentsquare/android/error/analysis/internal/network/WebViewNetworkEventProcessor;Lcom/contentsquare/android/error/analysis/internal/network/NetworkEventCounter;Lcom/contentsquare/android/error/analysis/internal/util/SdkDataProvider;)V", "crashReporter", "Lcom/contentsquare/android/error/analysis/internal/crash/CrashEventReporter;", "getCrashReporter", "()Lcom/contentsquare/android/error/analysis/internal/crash/CrashEventReporter;", "crashReporter$delegate", "Lkotlin/Lazy;", "logger", "Lcom/contentsquare/android/common/features/logging/Logger;", "screenViewTracker", "Lcom/contentsquare/android/common/utils/ScreenViewTracker;", "getScreenViewTracker", "()Lcom/contentsquare/android/common/utils/ScreenViewTracker;", "checkForSendingBeforeFirstScreen", "", "deletePendingCrashEvents", "dispatchNativeEvent", "rawEvent", "Lcom/contentsquare/android/common/error/analysis/NetworkEvent;", "dispatchWebViewEvent", "getEventLogGenerated", "Lorg/json/JSONObject;", "isCrashReportingEnabled", "", "()Ljava/lang/Boolean;", "isEnabled", "isFlagEnabled", "flag", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "isNetworkEventLimitReached", "newNetworkMetric", "Lcom/contentsquare/android/error/analysis/NetworkMetric;", "url", "httpMethod", "source", "saveCrashEvent", "event", "Lcom/contentsquare/android/error/analysis/internal/crash/AndroidThreadReport;", "sendEvent", "sendPendingCrashEvents", "Companion", "HttpMethod", "library_release"})
public final class ErrorAnalysis {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final NetworkEventUrlProcessor urlProcessor;
    @NotNull
    private static final NetworkEventCompressor networkEventCompressor;
    @NotNull
    private static final NetworkEventEncryptor encryptor;
    @NotNull
    private static final ErrorAnalysis instance;
    @NotNull
    private final NativeNetworkEventProcessor nativeNetworkEventProcessor;
    @NotNull
    private final WebViewNetworkEventProcessor webViewNetworkEventProcessor;
    @NotNull
    private final NetworkEventCounter networkEventCounter;
    @NotNull
    private final SdkDataProvider sdkDataProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy crashReporter$delegate;

    @VisibleForTesting
    public ErrorAnalysis(@NotNull NativeNetworkEventProcessor nativeNetworkEventProcessor, @NotNull WebViewNetworkEventProcessor webViewNetworkEventProcessor, @NotNull NetworkEventCounter networkEventCounter, @NotNull SdkDataProvider sdkDataProvider) {
        ErrorAnalysis errorAnalysis = this;
        Intrinsics.checkNotNullParameter((Object)nativeNetworkEventProcessor, (String)"nativeNetworkEventProcessor");
        Intrinsics.checkNotNullParameter((Object)webViewNetworkEventProcessor, (String)"webViewNetworkEventProcessor");
        Intrinsics.checkNotNullParameter((Object)networkEventCounter, (String)"networkEventCounter");
        Intrinsics.checkNotNullParameter((Object)sdkDataProvider, (String)"sdkDataProvider");
        this.nativeNetworkEventProcessor = nativeNetworkEventProcessor;
        this.webViewNetworkEventProcessor = webViewNetworkEventProcessor;
        this.networkEventCounter = networkEventCounter;
        errorAnalysis.sdkDataProvider = sdkDataProvider;
        errorAnalysis.logger = new Logger("ErrorAnalysis");
        errorAnalysis.crashReporter$delegate = LazyKt.lazy((Function0)new Function0<CrashEventReporter>(){

            public final Object invoke() {
                NetworkDispatcher networkDispatcher;
                Object object = networkDispatcher;
                networkDispatcher = new NetworkDispatcher(null, 1, null);
                return new CrashEventReporter(sdkDataProvider, new CrashEventWriterReader(sdkDataProvider.getFilesDirAbsolutePath()), (NetworkDispatcher)object);
            }
        });
    }

    private final ScreenViewTracker getScreenViewTracker() {
        return this.sdkDataProvider.getScreenViewTracker();
    }

    private final CrashEventReporter getCrashReporter() {
        return (CrashEventReporter)this.crashReporter$delegate.getValue();
    }

    private final boolean isNetworkEventLimitReached() {
        ScreenViewTracker screenViewTracker = this.getScreenViewTracker();
        if (screenViewTracker != null && screenViewTracker.isScreenNumberChanged()) {
            ErrorAnalysis errorAnalysis = this;
            errorAnalysis.networkEventCounter.resetCounter();
            screenViewTracker = errorAnalysis.getScreenViewTracker();
            if (screenViewTracker != null) {
                screenViewTracker.updateLastScreenNumber();
            }
        }
        return this.networkEventCounter.isMaxNetworkEventLimitReached();
    }

    private final void dispatchWebViewEvent(NetworkEvent networkEvent) {
        if (NetworkEventFilterKt.isAccepted(networkEvent = this.webViewNetworkEventProcessor.processEvent(networkEvent))) {
            this.checkForSendingBeforeFirstScreen();
            Object object = fd.h;
            if (object != null) {
                s7 s72;
                fd fd2 = object;
                object = s72;
                s72 = new s7(networkEvent);
                fd2.a((s7)object);
            }
            this.networkEventCounter.incrementCounter();
        }
    }

    private final void dispatchNativeEvent(NetworkEvent networkEvent) {
        if (NetworkEventFilterKt.isAccepted(networkEvent = this.nativeNetworkEventProcessor.processEvent(networkEvent)) && this.isEnabled()) {
            ErrorAnalysis errorAnalysis = this;
            errorAnalysis.checkForSendingBeforeFirstScreen();
            NetworkEvent networkEvent2 = networkEvent;
            Object object = networkEvent2.getHttpMethod();
            errorAnalysis.logger.i("API Error - " + networkEvent.getStatusCode() + " " + (String)object + " " + networkEvent2.getUrl(), new Object[0]);
            object = fd.a.a();
            if (object != null) {
                s7 s72;
                Object object2 = object;
                object = s72;
                s72 = new s7(networkEvent);
                ((fd)object2).a((s7)object);
            }
            if ((object = i2.a()) != null && (object = ((i2)object).b()) != null) {
                ((wa)object).a(networkEvent);
            }
            this.networkEventCounter.incrementCounter();
        }
    }

    private final void checkForSendingBeforeFirstScreen() {
        Object object = this.getScreenViewTracker();
        if (object != null && ((ScreenViewTracker)object).isSentBeforeFirstScreen()) {
            this.logger.i("No screenview detected. API error is linked to screenviews. Please implement screenview tracking to enable it.", new Object[0]);
            object = e2.w;
            if (object != null && (object = ((e2)object).s) != null) {
                ((e6)object).b(this.getEventLogGenerated());
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Boolean isFlagEnabled(String var1_1) {
        block10: {
            block8: {
                block9: {
                    try {
                        var2_3 = w1.b;
                        if (var2_3 == null) break block8;
                    }
                    catch (Throwable var1_2) {}
                    var2_3 = s1.a((w1)var2_3);
                    if (var2_3 == null) break block8;
                    var3_4 = e2.w;
                    if (var3_4 == null) ** GOTO lbl17
                    Intrinsics.checkNotNullParameter((Object)var3_4, (String)"<this>");
                    var4_5 /* !! */  = v0;
                    v0 = new r1(var3_4);
                    break block9;
lbl17:
                    // 1 sources

                    var4_5 /* !! */  = c.a;
                }
                this = (Boolean)var4_5 /* !! */ .invoke(var2_3, var1_1);
                return this;
                ** finally { 
lbl22:
                // 1 sources

                break block10;
            }
            return null;
        }
        this.logger.e(var1_2, "Cannot found if error analysis is enabled", new Object[0]);
        this = null;
        return this;
    }

    public static /* synthetic */ NetworkMetric newNetworkMetric$default(ErrorAnalysis errorAnalysis, String string, String string2, String string3, int n10, Object object) {
        if ((n10 & 4) != 0) {
            string3 = "native";
        }
        return errorAnalysis.newNetworkMetric(string, string2, string3);
    }

    @JvmStatic
    public static final void setUrlMaskingPatterns(@NotNull List<String> list) {
        Companion.setUrlMaskingPatterns(list);
    }

    @JvmStatic
    @NotNull
    public static final ErrorAnalysis getInstance() {
        return Companion.getInstance();
    }

    static {
        SdkDataProviderImpl sdkDataProviderImpl;
        NetworkEventCounter networkEventCounter;
        WebViewNetworkEventProcessor webViewNetworkEventProcessor;
        NetworkEventPIIAnonymizer networkEventPIIAnonymizer;
        NetworkEventConfigurator networkEventConfigurator;
        AsymmetricCryptor asymmetricCryptor;
        NetworkEventEncryptor networkEventEncryptor;
        NetworkEventCompressor networkEventCompressor;
        NetworkEventUrlProcessor networkEventUrlProcessor;
        Companion = new Companion(null);
        Object object = networkEventUrlProcessor;
        urlProcessor = new NetworkEventUrlProcessor();
        Object object2 = networkEventCompressor;
        ErrorAnalysis.networkEventCompressor = new NetworkEventCompressor();
        NetworkEventEncryptor networkEventEncryptor2 = networkEventEncryptor;
        Object object3 = asymmetricCryptor;
        asymmetricCryptor = new AsymmetricCryptor(a.a, null, 2, null);
        encryptor = new NetworkEventEncryptor(new SymmetricCryptor(null, null, 3, null), (AsymmetricCryptor)object3);
        object3 = networkEventConfigurator;
        networkEventConfigurator = new NetworkEventConfigurator();
        NetworkEventPIIAnonymizer networkEventPIIAnonymizer2 = networkEventPIIAnonymizer;
        networkEventPIIAnonymizer = new NetworkEventPIIAnonymizer();
        NativeNetworkEventProcessor nativeNetworkEventProcessor = new NativeNetworkEventProcessor((NetworkEventUrlProcessor)object, (NetworkEventConfigurator)object3, networkEventPIIAnonymizer2, (NetworkEventCompressor)object2, networkEventEncryptor2);
        object3 = webViewNetworkEventProcessor;
        webViewNetworkEventProcessor = new WebViewNetworkEventProcessor((NetworkEventUrlProcessor)object, (NetworkEventCompressor)object2, networkEventEncryptor2);
        object = networkEventCounter;
        networkEventCounter = new NetworkEventCounter();
        object2 = sdkDataProviderImpl;
        sdkDataProviderImpl = new SdkDataProviderImpl();
        instance = new ErrorAnalysis(nativeNetworkEventProcessor, (WebViewNetworkEventProcessor)object3, (NetworkEventCounter)object, (SdkDataProvider)object2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void saveCrashEvent(@NotNull AndroidThreadReport androidThreadReport) {
        Intrinsics.checkNotNullParameter((Object)androidThreadReport, (String)"event");
        this.getCrashReporter().saveCrashEvent(androidThreadReport, f.a);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void deletePendingCrashEvents() {
        this.getCrashReporter().deletePendingCrashEvents();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void sendPendingCrashEvents() {
        this.getCrashReporter().sendPendingCrashEvents();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void sendEvent(@NotNull NetworkEvent objectArray) {
        String string;
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"rawEvent");
        try {
            if (this.isNetworkEventLimitReached()) {
                this.logger.i("Limit of 20 API errors per screenview has been reached for the current screenview. API Error collection is paused until next screenview", new Object[0]);
                return;
            }
            string = objectArray.getSource();
        }
        catch (Throwable throwable) {
            objectArray = new Object[]{};
            new Logger("ErrorAnalysis").d(throwable, "Exception received while sending api error", objectArray);
            return;
        }
        {
            if (Intrinsics.areEqual((Object)string, (Object)"webview")) {
                this.dispatchWebViewEvent((NetworkEvent)objectArray);
                return;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"native")) return;
            this.dispatchNativeEvent((NetworkEvent)objectArray);
            return;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isEnabled() {
        return (this = ((ErrorAnalysis)this).isFlagEnabled("api_errors")) != null ? (Boolean)this : false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Boolean isCrashReportingEnabled() {
        Object object = e2.w;
        return object != null && (object = ((e2)object).k) != null && ((rb)object).j ? this.isFlagEnabled("crash_reporter") : Boolean.FALSE;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final JSONObject getEventLogGenerated() {
        d6 d62 = new d6();
        Intrinsics.checkNotNullParameter((Object)"Event sent before 1st screen view: API Error", (String)"additionalContext");
        d62.n = "Event sent before 1st screen view: API Error";
        Intrinsics.checkNotNullParameter((Object)"Informational log", (String)"logTypeDescription");
        d62.l = "Informational log";
        Intrinsics.checkNotNullParameter((Object)"INFO", (String)"logType");
        d62.m = "INFO";
        Intrinsics.checkNotNullParameter((Object)"NetworkRequestMetric", (String)"message");
        d62.h = "NetworkRequestMetric";
        return d62.a();
    }

    @NotNull
    public final NetworkMetric newNetworkMetric(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        Function1<NetworkEvent, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)string, (String)"url");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"httpMethod");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"source");
        Function1<NetworkEvent, Unit> function12 = function1;
        function1 = new Function1<NetworkEvent, Unit>(object){

            public final Object invoke(Object object) {
                d d10 = object2;
                Object object2 = (NetworkEvent)object;
                Intrinsics.checkNotNullParameter((Object)object2, (String)"p0");
                ((ErrorAnalysis)d10.receiver).sendEvent((NetworkEvent)object2);
                return Unit.INSTANCE;
            }
        };
        Object object = e.a;
        return new NetworkMetric(string, string2, string3, (Function0<Long>)object, (Function1<? super NetworkEvent, Unit>)function12);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0007J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/contentsquare/android/error/analysis/ErrorAnalysis$Companion;", "", "()V", "encryptor", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventEncryptor;", "instance", "Lcom/contentsquare/android/error/analysis/ErrorAnalysis;", "networkEventCompressor", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventCompressor;", "urlProcessor", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventUrlProcessor;", "getInstance", "setUrlMaskingPatterns", "", "patterns", "", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @JvmStatic
        public final void setUrlMaskingPatterns(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"patterns");
            this.getInstance().nativeNetworkEventProcessor.getPiiAnonymizer().setUrlMaskingPatterns(list);
        }

        @JvmStatic
        @NotNull
        public final ErrorAnalysis getInstance() {
            return instance;
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/contentsquare/android/error/analysis/ErrorAnalysis$HttpMethod;", "", "Companion", "library_release"})
    public static @interface HttpMethod {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String GET = "GET";
        @NotNull
        public static final String PUT = "PUT";
        @NotNull
        public static final String POST = "POST";
        @NotNull
        public static final String DELETE = "DELETE";
        @NotNull
        public static final String HEAD = "HEAD";
        @NotNull
        public static final String PATCH = "PATCH";
        @NotNull
        public static final String OPTIONS = "OPTIONS";
        @NotNull
        public static final String TRACE = "TRACE";
        @NotNull
        public static final String CONNECT = "CONNECT";

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/contentsquare/android/error/analysis/ErrorAnalysis$HttpMethod$Companion;", "", "()V", "CONNECT", "", "DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT", "TRACE", "all", "", "getAll$library_release", "()Ljava/util/List;", "library_release"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            public static final String GET = "GET";
            @NotNull
            public static final String PUT = "PUT";
            @NotNull
            public static final String POST = "POST";
            @NotNull
            public static final String DELETE = "DELETE";
            @NotNull
            public static final String HEAD = "HEAD";
            @NotNull
            public static final String PATCH = "PATCH";
            @NotNull
            public static final String OPTIONS = "OPTIONS";
            @NotNull
            public static final String TRACE = "TRACE";
            @NotNull
            public static final String CONNECT = "CONNECT";
            @NotNull
            private static final List<String> all;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
                all = CollectionsKt.listOf((Object[])new String[]{"GET", "PUT", "POST", "DELETE", "HEAD", "PATCH", "OPTIONS", "TRACE", "CONNECT"});
            }

            @NotNull
            public final List<String> getAll$library_release() {
                return all;
            }
        }
    }
}

