/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.internal.crash;

import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.common.features.logging.Logger;
import com.contentsquare.android.common.utils.FileStorageUtil;
import com.contentsquare.android.sdk.y6;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0011\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\n\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\bR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R \u0010\u0012\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/contentsquare/android/error/analysis/internal/crash/CrashEventWriterReader;", "", "Lcom/contentsquare/android/sdk/y6;", "crashEvent", "", "crashEventToZippedBytes", "", "saveCrashToDisk", "", "Lcom/contentsquare/android/error/analysis/internal/crash/CrashEventWriterReader$CrashFile;", "getPendingCrashFiles", "Lcom/contentsquare/android/common/features/logging/Logger;", "logger", "Lcom/contentsquare/android/common/features/logging/Logger;", "Lcom/contentsquare/android/common/utils/FileStorageUtil;", "storageUtil", "Lcom/contentsquare/android/common/utils/FileStorageUtil;", "", "storagePath", "Ljava/lang/String;", "getStoragePath", "()Ljava/lang/String;", "getStoragePath$annotations", "()V", "appFilesLocation", "<init>", "(Ljava/lang/String;)V", "Companion", "CrashFile", "library_release"})
public final class CrashEventWriterReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CRASH_EVENT_CONTAINER = "crashes";
    @NotNull
    private final Logger logger = new Logger("CrashEventWriterReader");
    @NotNull
    private final FileStorageUtil storageUtil = new FileStorageUtil();
    @NotNull
    private final String storagePath;

    public CrashEventWriterReader(@Nullable String string) {
        String string2 = File.separator;
        this.storagePath = string + string2 + "cs" + string2 + CRASH_EVENT_CONTAINER;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStoragePath$annotations() {
    }

    private final byte[] crashEventToZippedBytes(y6 y62) {
        byte[] byArray;
        GZIPOutputStream gZIPOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        Object object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream2 = gZIPOutputStream;
        gZIPOutputStream2((OutputStream)object);
        object = null;
        try {
            ((OutputStream)gZIPOutputStream).write(y62.toByteArray());
            gZIPOutputStream.finish();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)gZIPOutputStream2, (Throwable)throwable);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)gZIPOutputStream2, (Throwable)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"GZIPOutputStream(os).use\u2026s.toByteArray()\n        }");
        return byArray;
    }

    @NotNull
    public final String getStoragePath() {
        return this.storagePath;
    }

    public final void saveCrashToDisk(@NotNull y6 object) {
        CrashEventWriterReader crashEventWriterReader = this;
        y6 y62 = object;
        Intrinsics.checkNotNullParameter((Object)y62, (String)"crashEvent");
        byte[] byArray = crashEventWriterReader.crashEventToZippedBytes(y62);
        String string = crashEventWriterReader.storagePath;
        y6 y63 = object;
        object = File.separator;
        long l10 = y63.b();
        object = string + (String)object + l10;
        crashEventWriterReader.logger.d("Saving crash to event to file: " + (String)object);
        crashEventWriterReader.storageUtil.mkdirs(this.storagePath);
        try {
            crashEventWriterReader.storageUtil.writeBytesToFile((String)object, byArray, true);
        }
        catch (IOException iOException) {
            this.logger.e(iOException, "Failed to write crash event to file", new Object[0]);
        }
    }

    @NotNull
    public final List<CrashFile> getPendingCrashFiles() {
        List list;
        Object object = this.storageUtil.listFolder(this.storagePath);
        if (object != null && (object = ArraysKt.asList((Object[])object)) != null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                CrashEventWriterReader crashEventWriterReader = this;
                list.add(crashEventWriterReader.new CrashFile(crashEventWriterReader.storagePath + File.separator + string));
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/contentsquare/android/error/analysis/internal/crash/CrashEventWriterReader$Companion;", "", "()V", "CRASH_EVENT_CONTAINER", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/contentsquare/android/error/analysis/internal/crash/CrashEventWriterReader$CrashFile;", "", "filename", "", "(Lcom/contentsquare/android/error/analysis/internal/crash/CrashEventWriterReader;Ljava/lang/String;)V", "getFilename", "()Ljava/lang/String;", "deleteFile", "", "getRawData", "", "library_release"})
    public final class CrashFile {
        @NotNull
        private final String filename;

        public CrashFile(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"filename");
            this.filename = string;
        }

        @NotNull
        public final String getFilename() {
            return this.filename;
        }

        @NotNull
        public final byte[] getRawData() {
            byte[] byArray = CrashEventWriterReader.this.storageUtil.readFileContentAsBytes(this.filename);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"storageUtil.readFileContentAsBytes(filename)");
            return byArray;
        }

        public final void deleteFile() {
            CrashEventWriterReader.this.storageUtil.deleteFileOrFolder(this.filename);
        }
    }
}

