/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.internal.network;

import com.contentsquare.android.common.error.analysis.NetworkEvent;
import com.contentsquare.android.error.analysis.internal.network.NetworkEventProcessor;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventCompressor;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventConfigurator;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventEncryptor;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventFilterKt;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventPIIAnonymizer;
import com.contentsquare.android.error.analysis.internal.network.processors.NetworkEventUrlProcessor;
import com.contentsquare.android.internal.features.config.models.JsonConfig;
import com.contentsquare.android.sdk.s1;
import com.contentsquare.android.sdk.w1;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/contentsquare/android/error/analysis/internal/network/NativeNetworkEventProcessor;", "Lcom/contentsquare/android/error/analysis/internal/network/NetworkEventProcessor;", "urlProcessor", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventUrlProcessor;", "eventConfigurator", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventConfigurator;", "piiAnonymizer", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventPIIAnonymizer;", "eventCompressor", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventCompressor;", "encryptor", "Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventEncryptor;", "(Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventUrlProcessor;Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventConfigurator;Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventPIIAnonymizer;Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventCompressor;Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventEncryptor;)V", "config", "Lcom/contentsquare/android/internal/features/config/models/JsonConfig$ProjectConfiguration;", "getConfig", "()Lcom/contentsquare/android/internal/features/config/models/JsonConfig$ProjectConfiguration;", "getPiiAnonymizer", "()Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventPIIAnonymizer;", "processEvent", "Lcom/contentsquare/android/common/error/analysis/NetworkEvent;", "event", "library_release"})
public final class NativeNetworkEventProcessor
implements NetworkEventProcessor {
    @NotNull
    private final NetworkEventUrlProcessor urlProcessor;
    @NotNull
    private final NetworkEventConfigurator eventConfigurator;
    @NotNull
    private final NetworkEventPIIAnonymizer piiAnonymizer;
    @NotNull
    private final NetworkEventCompressor eventCompressor;
    @NotNull
    private final NetworkEventEncryptor encryptor;

    public NativeNetworkEventProcessor(@NotNull NetworkEventUrlProcessor networkEventUrlProcessor, @NotNull NetworkEventConfigurator networkEventConfigurator, @NotNull NetworkEventPIIAnonymizer networkEventPIIAnonymizer, @NotNull NetworkEventCompressor networkEventCompressor, @NotNull NetworkEventEncryptor networkEventEncryptor) {
        Intrinsics.checkNotNullParameter((Object)networkEventUrlProcessor, (String)"urlProcessor");
        Intrinsics.checkNotNullParameter((Object)networkEventConfigurator, (String)"eventConfigurator");
        Intrinsics.checkNotNullParameter((Object)networkEventPIIAnonymizer, (String)"piiAnonymizer");
        Intrinsics.checkNotNullParameter((Object)networkEventCompressor, (String)"eventCompressor");
        Intrinsics.checkNotNullParameter((Object)networkEventEncryptor, (String)"encryptor");
        this.urlProcessor = networkEventUrlProcessor;
        this.eventConfigurator = networkEventConfigurator;
        this.piiAnonymizer = networkEventPIIAnonymizer;
        this.eventCompressor = networkEventCompressor;
        this.encryptor = networkEventEncryptor;
    }

    private final JsonConfig.ProjectConfiguration getConfig() {
        w1 w12 = w1.b;
        return w12 != null ? s1.a(w12) : null;
    }

    @NotNull
    public final NetworkEventPIIAnonymizer getPiiAnonymizer() {
        return this.piiAnonymizer;
    }

    @Override
    @NotNull
    public NetworkEvent processEvent(@NotNull NetworkEvent networkEvent) {
        Intrinsics.checkNotNullParameter((Object)networkEvent, (String)"event");
        List<String> list = this.getConfig();
        list = list != null ? ((JsonConfig.ProjectConfiguration)((Object)list)).o : null;
        NativeNetworkEventProcessor nativeNetworkEventProcessor = this;
        networkEvent = nativeNetworkEventProcessor.urlProcessor.process(networkEvent);
        networkEvent = nativeNetworkEventProcessor.eventConfigurator.configure(networkEvent, (JsonConfig.ApiErrors)((Object)list));
        networkEvent = nativeNetworkEventProcessor.piiAnonymizer.anonymize(networkEvent);
        networkEvent = nativeNetworkEventProcessor.eventCompressor.compress(networkEvent);
        list = list != null ? ((JsonConfig.ApiErrors)((Object)list)).e : null;
        return NetworkEventFilterKt.isValidUrl(networkEvent, list) ? this.encryptor.encrypt(networkEvent) : networkEvent.copyWithoutDetails();
    }
}

