/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.internal.network.processors;

import com.contentsquare.android.common.error.analysis.NetworkEvent;
import com.contentsquare.android.error.analysis.internal.network.processors.UrlMasker;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010\r\u001a\u00020\f*\u00020\fH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventPIIAnonymizer;", "", "()V", "urlMasker", "Lcom/contentsquare/android/error/analysis/internal/network/processors/UrlMasker;", "anonymize", "Lcom/contentsquare/android/common/error/analysis/NetworkEvent;", "event", "setUrlMaskingPatterns", "", "urlMaskingPatterns", "", "", "anonymizeFields", "filterQueryString", "Ljava/net/URI;", "Companion", "library_release"})
public final class NetworkEventPIIAnonymizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EMAIL_REGEX = "[a-zA-Z0-9._%+-]+(?:@|%40)[a-zA-Z0-9.%-_]+((?:\\.|%2[eE])[a-zA-Z0-9-]+)+";
    @NotNull
    private static final String FAST_LOOKUP_EMAIL_REGEX = "[a-zA-Z0-9+_-](?:@|%40)";
    @NotNull
    public static final String EMAIL_REPLACEMENT = "CS_ANONYMIZED_EMAIL";
    @NotNull
    private final UrlMasker urlMasker;

    public NetworkEventPIIAnonymizer() {
        UrlMasker urlMasker;
        UrlMasker urlMasker2 = urlMasker;
        urlMasker = new UrlMasker();
        v1.urlMasker = urlMasker2;
    }

    private final String anonymizeFields(String string) {
        if (new Regex(FAST_LOOKUP_EMAIL_REGEX, RegexOption.IGNORE_CASE).containsMatchIn((CharSequence)string)) {
            string = new Regex(EMAIL_REGEX, RegexOption.IGNORE_CASE).replace((CharSequence)string, EMAIL_REPLACEMENT);
        }
        return string;
    }

    private final URI filterQueryString(URI object) {
        URI uRI = object;
        String string = uRI.getScheme();
        object = uRI.getAuthority();
        String string2 = uRI.getPath();
        String string3 = uRI.getFragment();
        return new URI(string, (String)object, string2, null, string3);
    }

    @NotNull
    public final NetworkEvent anonymize(@NotNull NetworkEvent networkEvent) {
        NetworkEventPIIAnonymizer networkEventPIIAnonymizer = object;
        NetworkEvent networkEvent2 = networkEvent;
        Intrinsics.checkNotNullParameter((Object)networkEvent2, (String)"event");
        Object object = networkEvent2.getUrl();
        String string = networkEventPIIAnonymizer.filterQueryString(new URI((String)object)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.url.let { URI(it).\u2026}\n            .toString()");
        object = networkEventPIIAnonymizer.anonymizeFields(string);
        object = networkEventPIIAnonymizer.urlMasker.maskUrl((String)object);
        return NetworkEvent.copy$default(networkEvent, 0L, null, (String)object, 0, 0L, 0L, null, null, null, null, null, null, null, null, null, null, null, null, null, 524283, null);
    }

    public final void setUrlMaskingPatterns(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"urlMaskingPatterns");
        this.urlMasker.setUrlMaskingPatterns(list);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/contentsquare/android/error/analysis/internal/network/processors/NetworkEventPIIAnonymizer$Companion;", "", "()V", "EMAIL_REGEX", "", "EMAIL_REPLACEMENT", "FAST_LOOKUP_EMAIL_REGEX", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

