/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document.json;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.utils.Base64;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.encryption.CryptoManager;
import com.couchbase.client.encryption.CryptoProvider;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Serializable {
    private static final long serialVersionUID = 8817717605659870262L;
    private final Map<String, Object> content;
    private volatile Map<String, String> encryptionPathInfo;
    private volatile CryptoManager cryptoManager;
    public static final String ENCRYPTION_PREFIX = "__crypt_";

    private JsonObject() {
        this.content = new HashMap<String, Object>();
    }

    private JsonObject(int initialCapacity) {
        this.content = new HashMap<String, Object>(initialCapacity);
    }

    public static JsonObject empty() {
        return new JsonObject();
    }

    public static JsonObject create() {
        return new JsonObject();
    }

    public static JsonObject from(Map<String, ?> mapData) {
        Objects.requireNonNull(mapData, "Null input Map unsupported");
        JsonObject result = new JsonObject(mapData.size());
        try {
            for (Map.Entry<String, ?> entry : mapData.entrySet()) {
                String key = Objects.requireNonNull(entry.getKey(), "The key is not allowed to be null");
                Object value = entry.getValue();
                result.put(key, JsonObject.coerce(value));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map key must be String", e);
        }
        return result;
    }

    public static JsonObject fromJson(String s) {
        try {
            return CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert string to JsonObject", e);
        }
    }

    public JsonObject put(String name, Object value) {
        if (this == value) {
            throw new IllegalArgumentException("Cannot put self");
        }
        this.content.put(name, JsonObject.coerce(value));
        return this;
    }

    public JsonObject putAndEncrypt(String name, Object value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.put(name, value);
        return this;
    }

    private Object decrypt(JsonObject object, String providerName) throws Exception {
        byte[] decryptedBytes;
        String decryptedString;
        Object decrypted;
        byte[] encryptedBytes;
        String encryptedValueWithConfig;
        String key = object.getString("kid");
        String alg = object.getString("alg");
        CryptoProvider provider = this.cryptoManager.getProvider(providerName);
        if (!provider.checkAlgorithmNameMatch(alg)) {
            this.cryptoManager.throwMissingPublicKeyEx(providerName);
        }
        if (!key.contentEquals(provider.getKeyStoreProvider().publicKeyName())) {
            this.cryptoManager.throwMissingPublicKeyEx(providerName);
        }
        if (object.containsKey("iv")) {
            encryptedValueWithConfig = object.getString("kid") + object.getString("alg") + object.getString("iv") + object.getString("ciphertext");
            byte[] encrypted = Base64.decode((String)object.getString("ciphertext"));
            byte[] iv = Base64.decode((String)object.getString("iv"));
            encryptedBytes = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, encryptedBytes, 0, iv.length);
            System.arraycopy(encrypted, 0, encryptedBytes, iv.length, encrypted.length);
        } else {
            encryptedValueWithConfig = object.getString("kid") + object.getString("alg") + object.getString("ciphertext");
            encryptedBytes = Base64.decode((String)object.getString("ciphertext"));
        }
        if (object.containsKey("sig")) {
            byte[] signature = Base64.decode((String)object.getString("sig"));
            if (!provider.verifySignature(encryptedValueWithConfig.getBytes(), signature)) {
                this.cryptoManager.throwSigningFailedEx(providerName);
            }
        }
        if ((decrypted = JacksonTransformers.MAPPER.readValue(decryptedString = new String(decryptedBytes = provider.decrypt(encryptedBytes), Charset.forName("UTF-8")), Object.class)) instanceof Map) {
            decrypted = JsonObject.from((Map)decrypted);
        } else if (decrypted instanceof List) {
            decrypted = JsonArray.from((List)decrypted);
        }
        return decrypted;
    }

    public Object get(String name) {
        return this.content.get(name);
    }

    public Object getAndDecrypt(String name, String providerName) throws Exception {
        return this.decrypt((JsonObject)this.content.get(ENCRYPTION_PREFIX + name), providerName);
    }

    public JsonObject put(String name, String value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject putAndEncrypt(String name, String value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, value);
        return this;
    }

    public String getString(String name) {
        return (String)this.content.get(name);
    }

    public String getAndDecryptString(String name, String providerName) throws Exception {
        return (String)this.getAndDecrypt(name, providerName);
    }

    public JsonObject put(String name, int value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject putAndEncrypt(String name, int value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, value);
        return this;
    }

    public Integer getInt(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    @InterfaceStability.Committed
    public Integer getAndDecryptInt(String name, String providerName) throws Exception {
        Number number = (Number)this.getAndDecrypt(name, providerName);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public JsonObject put(String name, long value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject putAndEncrypt(String name, long value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, value);
        return this;
    }

    public Long getLong(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public Long getAndDecryptLong(String name, String providerName) throws Exception {
        Number number = (Number)this.getAndDecrypt(name, providerName);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public JsonObject put(String name, double value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject putAndEncrypt(String name, double value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, value);
        return this;
    }

    public Double getDouble(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public Double getAndDecryptDouble(String name, String providerName) throws Exception {
        Number number = (Number)this.getAndDecrypt(name, providerName);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public JsonObject put(String name, boolean value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject putAndEncrypt(String name, boolean value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, value);
        return this;
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.content.get(name);
    }

    public Boolean getAndDecryptBoolean(String name, String providerName) throws Exception {
        return (Boolean)this.getAndDecrypt(name, providerName);
    }

    public JsonObject put(String name, JsonObject value) {
        Map<String, String> paths;
        if (this == value) {
            throw new IllegalArgumentException("Cannot put self");
        }
        this.content.put(name, value);
        if (value != null && (paths = value.encryptionPathInfo()) != null && !paths.isEmpty()) {
            for (Map.Entry<String, String> entry : paths.entrySet()) {
                this.addValueEncryptionInfo(name.replace("~", "~0").replace("/", "~1") + "/" + entry.getKey(), entry.getValue(), false);
            }
            value.clearEncryptionPaths();
        }
        return this;
    }

    public JsonObject putAndEncrypt(String name, JsonObject value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        if (this == value) {
            throw new IllegalArgumentException("Cannot put self");
        }
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, Map<String, ?> value) {
        return this.put(name, JsonObject.from(value));
    }

    public JsonObject putAndEncrypt(String name, Map<String, ?> value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        return this.put(name, JsonObject.from(value));
    }

    public JsonObject getObject(String name) {
        return (JsonObject)this.content.get(name);
    }

    public JsonObject getAndDecryptObject(String name, String providerName) throws Exception {
        return (JsonObject)this.getAndDecrypt(name, providerName);
    }

    public JsonObject put(String name, JsonArray value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject putAndEncrypt(String name, JsonArray value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, Number value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject putAndEncrypt(String name, Number value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, List<?> value) {
        return this.put(name, JsonArray.from(value));
    }

    public JsonObject putAndEncrypt(String name, List<?> value, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        return this.put(name, JsonArray.from(value));
    }

    public JsonArray getArray(String name) {
        return (JsonArray)this.content.get(name);
    }

    public JsonArray getAndDecryptArray(String name, String providerName) throws Exception {
        return (JsonArray)this.getAndDecrypt(name, providerName);
    }

    public BigInteger getBigInteger(String name) {
        return (BigInteger)this.content.get(name);
    }

    public BigInteger getAndDecryptBigInteger(String name, String providerName) throws Exception {
        return (BigInteger)this.getAndDecrypt(name, providerName);
    }

    public BigDecimal getBigDecimal(String name) {
        Object found = this.content.get(name);
        if (found == null) {
            return null;
        }
        if (found instanceof Double) {
            return new BigDecimal((Double)found);
        }
        return (BigDecimal)found;
    }

    public BigDecimal getAndDecryptBigDecimal(String name, String providerName) throws Exception {
        Object found = this.getAndDecrypt(name, providerName);
        if (found == null) {
            return null;
        }
        if (found instanceof Double) {
            return new BigDecimal((Double)found);
        }
        return (BigDecimal)found;
    }

    public Number getNumber(String name) {
        return (Number)this.content.get(name);
    }

    public Number getAndDecryptNumber(String name, String providerName) throws Exception {
        return (Number)this.getAndDecrypt(name, providerName);
    }

    public JsonObject putNull(String name) {
        this.content.put(name, null);
        return this;
    }

    public JsonObject putNullAndEncrypt(String name, String providerName) {
        this.addValueEncryptionInfo(name, providerName, true);
        this.content.put(name, null);
        return this;
    }

    public JsonObject removeKey(String name) {
        this.content.remove(name);
        if (this.encryptionPathInfo != null && this.encryptionPathInfo.entrySet().contains(name)) {
            this.encryptionPathInfo.remove(name);
        }
        return this;
    }

    public Set<String> getNames() {
        return this.content.keySet();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.content.size());
        for (Map.Entry<String, Object> entry : this.content.entrySet()) {
            Object content = entry.getValue();
            if (content instanceof JsonObject) {
                copy.put(entry.getKey(), ((JsonObject)content).toMap());
                continue;
            }
            if (content instanceof JsonArray) {
                copy.put(entry.getKey(), ((JsonArray)content).toList());
                continue;
            }
            copy.put(entry.getKey(), content);
        }
        return copy;
    }

    public Map<String, Object> toDecryptedMap(String providerName) throws Exception {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.content.size());
        for (Map.Entry<String, Object> entry : this.content.entrySet()) {
            Object content = entry.getValue();
            String key = entry.getKey();
            if (entry.getKey().startsWith(ENCRYPTION_PREFIX)) {
                content = this.decrypt((JsonObject)entry.getValue(), providerName);
                key = key.replace(ENCRYPTION_PREFIX, "");
            }
            if (content instanceof JsonObject) {
                JsonObject value = (JsonObject)content;
                value.setCryptoManager(this.cryptoManager);
                copy.put(key, ((JsonObject)content).toDecryptedMap(providerName));
                continue;
            }
            if (content instanceof JsonArray) {
                copy.put(key, ((JsonArray)content).toList());
                continue;
            }
            copy.put(key, content);
        }
        return copy;
    }

    public boolean containsKey(String name) {
        return this.content.containsKey(name);
    }

    public boolean containsValue(Object value) {
        return this.content.containsValue(value);
    }

    public int size() {
        return this.content.size();
    }

    public boolean isEncrypted(String name) {
        return this.containsKey(ENCRYPTION_PREFIX + name);
    }

    @InterfaceAudience.Private
    public Map<String, String> encryptionPathInfo() {
        return this.encryptionPathInfo;
    }

    @InterfaceStability.Committed
    @InterfaceAudience.Private
    public void clearEncryptionPaths() {
        if (this.encryptionPathInfo != null) {
            this.encryptionPathInfo.clear();
        }
    }

    @InterfaceAudience.Private
    public void setCryptoManager(CryptoManager cryptoManager) {
        this.cryptoManager = cryptoManager;
    }

    @InterfaceAudience.Private
    public CryptoManager getCryptoManager() {
        return this.cryptoManager;
    }

    public String toString() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot convert JsonObject to Json String", e);
        }
    }

    public String toDecryptedString(String providerName) throws Exception {
        Map<String, Object> mapData = this.toDecryptedMap(providerName);
        return JacksonTransformers.MAPPER.writeValueAsString((Object)JsonObject.from(mapData));
    }

    @InterfaceAudience.Private
    private void addValueEncryptionInfo(String path, String providerName, boolean escape) {
        if (escape) {
            path = path.replaceAll("~", "~0").replaceAll("/", "~1");
        }
        if (this.encryptionPathInfo == null) {
            this.encryptionPathInfo = new HashMap<String, String>();
        }
        this.encryptionPathInfo.put(path, providerName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject object = (JsonObject)o;
        return !(this.content != null ? !this.content.equals(object.content) : object.content != null);
    }

    public int hashCode() {
        return this.content.hashCode();
    }
}

