/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.busi.api.AgrAgreementAddApprovalBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAuditMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.EacRuTaskMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.EacRuTaskPO;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacBackAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacBackAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAgreementAddApprovalBusiServiceImpl
implements AgrAgreementAddApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementAddApprovalBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAuditMapper agrAuditMapper;
    @Value(value="${hasConfirmLike}")
    private Boolean hasConfirmLike;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;

    @Override
    public AgrAgreementAddApprovalBusiRspBO approvalAgreementAdd(AgrAgreementAddApprovalBusiReqBO busiReqBO) {
        AgrAgreementAddApprovalBusiRspBO rsp = new AgrAgreementAddApprovalBusiRspBO();
        Map<String, Set<Long>> stepAgreementIdMap = this.validAgreementInfo(busiReqBO);
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setBusinessId(busiReqBO.getAgreementIds().get(0).toString());
        if ("1".equals(busiReqBO.getApprovalLink())) {
            eacRuTaskPO.setTacheCode("userStep6");
        } else {
            eacRuTaskPO.setTacheCode("userStep5");
        }
        eacRuTaskPO.setOrderBy("CREATE_TIME");
        List<EacRuTaskPO> eacRuTaskPOList = this.eacRuTaskMapper.getList(eacRuTaskPO);
        for (Long agreementId : busiReqBO.getAgreementIds()) {
            int count;
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setAgreementId(agreementId);
            agreementPO.setSupplierId(busiReqBO.getSupplierId());
            agreementPO.setAuditResult(busiReqBO.getAuditResult());
            agreementPO.setAuditAdvice(busiReqBO.getAuditAdvice());
            AgreementPO apo = this.agreementMapper.getModelBy(agreementPO);
            EacApproveAbilityRspBO eacApproveAbilityRspBO = new EacApproveAbilityRspBO();
            if (AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                EacApproveAbilityReqBO eacApproveAbilityReqBO = new EacApproveAbilityReqBO();
                ArrayList data = new ArrayList();
                eacApproveAbilityReqBO.setData(data);
                for (EacRuTaskPO ruTaskPO : eacRuTaskPOList) {
                    if (!ruTaskPO.getUserId().equals(busiReqBO.getUserId().toString())) continue;
                    EacApproveAbilityReqInfoBO eacApproveAbilityReqInfoBO = new EacApproveAbilityReqInfoBO();
                    eacApproveAbilityReqInfoBO.setTaskId(ruTaskPO.getTaskId());
                    eacApproveAbilityReqInfoBO.setVariables(new HashMap());
                    eacApproveAbilityReqInfoBO.setApproveResult("pass");
                    eacApproveAbilityReqInfoBO.getVariables().put("auditOrderStatus", "1");
                    data.add(eacApproveAbilityReqInfoBO);
                }
                try {
                    log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u901a\u8fc7\u5165\u53c2eacApproveAbilityReqInfoBO:" + JSON.toJSON((Object)eacApproveAbilityReqBO));
                    eacApproveAbilityRspBO = this.eacRuTaskAbilityService.approveByMq(eacApproveAbilityReqBO);
                    log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u901a\u8fc7\u51fa\u53c2eacApproveAbilityRspBO:" + JSON.toJSON((Object)eacApproveAbilityRspBO));
                    if (!"0000".equals(eacApproveAbilityRspBO.getRespCode())) {
                        throw new BusinessException(eacApproveAbilityRspBO.getRespCode(), eacApproveAbilityRspBO.getRespDesc());
                    }
                }
                catch (BusinessException businessException) {
                    throw new BusinessException("11201", businessException.getMessage());
                }
                if (apo == null) {
                    throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u72b6\u6001\u5931\u8d25");
                }
                if ("1".equals(busiReqBO.getApprovalLink())) {
                    agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
                } else {
                    Date date = new Date();
                    Date date2 = apo.getEffDate();
                    int i = date.compareTo(date2);
                    if (i < 0) {
                        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.WAIT_ENABLE);
                    } else {
                        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                    }
                }
            } else if (AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) {
                if (busiReqBO.getType().equals("stop")) {
                    ArrayList list = new ArrayList();
                    eacApproveAbilityRspBO.setData(list);
                    for (EacRuTaskPO eacRuTaskPO2 : eacRuTaskPOList) {
                        if (!eacRuTaskPO2.getUserId().equals(busiReqBO.getUserId().toString())) continue;
                        EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
                        eacRuInstAbilityReqBO.setApproveInstId(eacRuTaskPO2.getApproveInstId());
                        try {
                            log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
                            EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
                            log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u51fa\u53c2eacRuInstAbilityRspBO:" + JSON.toJSON((Object)eacRuInstAbilityRspBO));
                            if ("0000".equals(eacRuInstAbilityRspBO.getRespCode())) continue;
                            throw new BusinessException(eacApproveAbilityRspBO.getRespCode(), eacApproveAbilityRspBO.getRespDesc());
                        }
                        catch (BusinessException e) {
                            throw new BusinessException("11201", e.getMessage());
                        }
                    }
                } else if (busiReqBO.getType().equals("start") || busiReqBO.getType().equals("last") || busiReqBO.getType().equals("history")) {
                    EacBackAbilityReqBO eacRuInstAbilityReqBO = new EacBackAbilityReqBO();
                    ArrayList<EacBackAbilityReqInfoBO> backData = new ArrayList<EacBackAbilityReqInfoBO>();
                    eacRuInstAbilityReqBO.setData(backData);
                    for (EacRuTaskPO each2 : eacRuTaskPOList) {
                        EacBackAbilityReqInfoBO eacBackAbilityReqInfoBO = new EacBackAbilityReqInfoBO();
                        eacBackAbilityReqInfoBO.setTaskId(each2.getTaskId());
                        eacBackAbilityReqInfoBO.setType(busiReqBO.getType());
                        eacBackAbilityReqInfoBO.setBackStepId(busiReqBO.getBackStepId());
                        eacBackAbilityReqInfoBO.setApproveAdvice(busiReqBO.getAuditAdvice());
                        backData.add(eacBackAbilityReqInfoBO);
                    }
                    try {
                        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u56de\u9000\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
                        eacApproveAbilityRspBO = this.eacRuTaskAbilityService.back(eacRuInstAbilityReqBO);
                        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u56de\u9000\u51fa\u53c2eacApproveAbilityRspBO:" + JSON.toJSON((Object)eacApproveAbilityRspBO));
                        if (!"0000".equals(eacApproveAbilityRspBO.getRespCode())) {
                            throw new BusinessException(eacApproveAbilityRspBO.getRespCode(), eacApproveAbilityRspBO.getRespDesc());
                        }
                    }
                    catch (BusinessException businessException) {
                        throw new BusinessException("11201", businessException.getMessage());
                    }
                }
                if ("1".equals(busiReqBO.getApprovalLink())) {
                    agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.NO_CONFIRM);
                } else {
                    agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.REJECT);
                }
            }
            if ((count = this.agreementMapper.updateByCondition(agreementPO)) == 1) continue;
            throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u72b6\u6001\u5931\u8d25");
        }
        if ("2".equals(busiReqBO.getApprovalLink())) {
            List<Long> taskIds = eacRuTaskPOList.stream().map(EacRuTaskPO::getTaskId).collect(Collectors.toList());
            EacRuTaskPO where = new EacRuTaskPO();
            where.setTaskIds(taskIds);
            EacRuTaskPO set = new EacRuTaskPO();
            set.setColumn2(busiReqBO.getAuditResult().toString());
            set.setStatus("COMPLETE");
            set.setDueTime(new Date(System.currentTimeMillis()));
            this.eacRuTaskMapper.updateBy(set, where);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u65b0\u589e\u5ba1\u6279\u6210\u529f\uff01");
        return rsp;
    }

    private Map<String, Set<Long>> validAgreementInfo(AgrAgreementAddApprovalBusiReqBO busiReqBO) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setAgreementIds(busiReqBO.getAgreementIds());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO);
        if (CollectionUtils.isEmpty(agreementPOS)) {
            throw new BusinessException("22001", "\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashSet<Long> statusErrors = new HashSet<Long>();
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementPO po : agreementPOS) {
            if (!AgrCommConstant.AgreementStatus.IN_AUDIT.equals(po.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.TO_CONFIRM.equals(po.getAgreementStatus())) {
                statusErrors.add(po.getAgreementId());
            }
            agreementIds.add(po.getAgreementId());
        }
        if (statusErrors.size() > 0) {
            throw new BusinessException("22002", "\u534f\u8bae\u3010" + ((Object)statusErrors).toString() + "\u3011\u72b6\u6001\u4e0d\u662f\u5ba1\u6838\u4e2d\u6216\u8005\u5f85\u786e\u8ba4");
        }
        if (agreementIds.size() < busiReqBO.getAgreementIds().size()) {
            busiReqBO.getAgreementIds().removeAll(agreementIds);
            throw new BusinessException("22006", "\u534f\u8bae\u3010" + busiReqBO.getAgreementIds() + "\u3011\u4e0d\u5b58\u5728");
        }
        return result;
    }

    private Boolean invokeProcess(AgrAgreementAddApprovalBusiReqBO busiReqBO, String stepId) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setObjId(busiReqBO.getAgreementIds());
        uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(busiReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(busiReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setOperId(busiReqBO.getMemIdIn().toString());
        uacNoTaskAuditOrderAuditReqBO.setUsername(busiReqBO.getUserName());
        uacNoTaskAuditOrderAuditReqBO.setOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditOrderAuditReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }
}

