/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrDicDictionaryBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrDicDictionaryBusiService;
import com.tydic.agreement.busi.bo.AgrOperateDicDictionaryBusiReqBO;
import com.tydic.agreement.busi.bo.AgrOperateDicDictionaryBusiRspBO;
import com.tydic.agreement.busi.bo.AgrQryDicDictionaryByListBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryDicDictionaryByListBusiRspBO;
import com.tydic.agreement.busi.bo.AgrQryDicDictionaryDetailBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryDicDictionaryDetailBusiRspBO;
import com.tydic.agreement.busi.bo.AgrRefreshDicDictionaryBusiReqBO;
import com.tydic.agreement.dao.AgrDicDictionaryMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrDicDictionaryPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="agrDicDictionaryBusiService")
public class AgrDicDictionaryBusiServiceImpl
implements AgrDicDictionaryBusiService {
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrDicDictionaryMapper agrDicDictionaryMapper;
    @Autowired
    private CacheClient cacheService;

    @Override
    public Map<String, String> queryDictBySysCodeAndPcode(String sysCode, String pCode) {
        return this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode(sysCode, pCode);
    }

    @Override
    public List<AgrDicDictionaryBO> queryDictBOBySysCodeAndPcode(String sysCode, String pCode) {
        return this.agrDicDictionaryAtomService.queryDictBOBySysCodeAndPcode(sysCode, pCode);
    }

    @Override
    public AgrQryDicDictionaryByListBusiRspBO queryDicDictionaryByList(AgrQryDicDictionaryByListBusiReqBO busiReqBO) {
        AgrQryDicDictionaryByListBusiRspBO busiRspBO = new AgrQryDicDictionaryByListBusiRspBO();
        AgrDicDictionaryPO agrDicDictionaryPO = new AgrDicDictionaryPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)agrDicDictionaryPO);
        agrDicDictionaryPO.setDelFlag(0);
        List<AgrDicDictionaryPO> pos = null;
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            pos = this.agrDicDictionaryMapper.getListPageByCondition(agrDicDictionaryPO, (Page<AgrDicDictionaryPO>)page);
            busiRspBO.setPageNo(page.getPageNo());
            busiRspBO.setRecordsTotal(page.getTotalCount());
            busiRspBO.setTotal(page.getTotalPages());
        } else {
            pos = this.agrDicDictionaryMapper.getListByCondition(agrDicDictionaryPO);
        }
        ArrayList<AgrDicDictionaryBO> rows = new ArrayList<AgrDicDictionaryBO>();
        if (!CollectionUtils.isEmpty(pos)) {
            for (AgrDicDictionaryPO po : pos) {
                AgrDicDictionaryBO bo = new AgrDicDictionaryBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                rows.add(bo);
            }
        }
        busiRspBO.setRows(rows);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    @Override
    public AgrQryDicDictionaryDetailBusiRspBO qryDicDictionaryDetail(AgrQryDicDictionaryDetailBusiReqBO busiReqBO) {
        return null;
    }

    @Override
    public AgrOperateDicDictionaryBusiRspBO operateDicDictionary(AgrOperateDicDictionaryBusiReqBO busiReqBO) {
        int count;
        AgrOperateDicDictionaryBusiRspBO busiRspBO = new AgrOperateDicDictionaryBusiRspBO();
        if (!StringUtils.hasText((String)busiReqBO.getSysCode())) {
            throw new BusinessException("0001", "\u3010sysCode\u3011\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)busiReqBO.getPCode())) {
            throw new BusinessException("0001", "\u3010pCode\u3011\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)busiReqBO.getCode())) {
            throw new BusinessException("0001", "\u3010code\u3011\u4e3a\u7a7a");
        }
        AgrDicDictionaryPO agrDicDictionaryPO = new AgrDicDictionaryPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)agrDicDictionaryPO);
        if (1 == busiReqBO.getOperType()) {
            agrDicDictionaryPO.setCreateUid(busiReqBO.getMemIdIn());
            agrDicDictionaryPO.setCreateTm(new Date());
            agrDicDictionaryPO.setDelFlag(0);
            count = this.agrDicDictionaryMapper.insert(agrDicDictionaryPO);
            if (count < 1) {
                throw new BusinessException("22003", "\u65b0\u589e\u5b57\u5178\u8868\u5931\u8d25");
            }
        } else if (2 == busiReqBO.getOperType()) {
            count = this.agrDicDictionaryMapper.deleteByCondition(agrDicDictionaryPO);
            if (count < 1) {
                throw new BusinessException("22003", "\u5220\u9664\u5b57\u5178\u8868\u5931\u8d25");
            }
        } else if (3 == busiReqBO.getOperType()) {
            agrDicDictionaryPO.setUpdateUid(busiReqBO.getMemIdIn());
            agrDicDictionaryPO.setUpdateTm(new Date());
            count = this.agrDicDictionaryMapper.updateByCondition(agrDicDictionaryPO);
            if (count < 1) {
                throw new BusinessException("22003", "\u4fee\u6539\u5b57\u5178\u8868\u5931\u8d25");
            }
        } else {
            throw new BusinessException("0002", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        String redisKey = busiReqBO.getSysCode() + "_" + busiReqBO.getPCode() + "_";
        AgrDicDictionaryPO agrDicDictionaryPO1 = new AgrDicDictionaryPO();
        agrDicDictionaryPO1.setSysCode(busiReqBO.getSysCode());
        agrDicDictionaryPO1.setPCode(busiReqBO.getPCode());
        List<AgrDicDictionaryPO> pos = this.agrDicDictionaryMapper.getListByCondition(agrDicDictionaryPO1);
        if (CollectionUtils.isEmpty(pos)) {
            this.cacheService.delete(redisKey);
        } else {
            ArrayList<AgrDicDictionaryBO> temp = new ArrayList<AgrDicDictionaryBO>();
            for (AgrDicDictionaryPO po : pos) {
                AgrDicDictionaryBO bo = new AgrDicDictionaryBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                temp.add(bo);
            }
            this.cacheService.set(redisKey, temp);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    @Override
    public String queryDictBySysCodeAndPcodeAndCode(String sysCode, String pCode, String code) {
        return this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode(sysCode, pCode, code);
    }

    @Override
    public AgrOperateDicDictionaryBusiRspBO refreshDicDictionaryBypCode(AgrRefreshDicDictionaryBusiReqBO busiReqBO) {
        AgrOperateDicDictionaryBusiRspBO busiRspBO = new AgrOperateDicDictionaryBusiRspBO();
        AgrDicDictionaryPO agrDicDictionaryPO = new AgrDicDictionaryPO();
        agrDicDictionaryPO.setPCode(busiReqBO.getPCode());
        List<AgrDicDictionaryPO> pos = this.agrDicDictionaryMapper.getListByCondition(agrDicDictionaryPO);
        HashMap temp = new HashMap();
        if (!CollectionUtils.isEmpty(pos)) {
            for (AgrDicDictionaryPO po : pos) {
                String redisKey = "AGR_" + po.getPCode() + "_";
                AgrDicDictionaryBO agrDicDictionaryBO = new AgrDicDictionaryBO();
                BeanUtils.copyProperties((Object)po, (Object)agrDicDictionaryBO);
                if (!temp.containsKey(redisKey)) {
                    ArrayList<AgrDicDictionaryBO> dicDictionaryBOS = new ArrayList<AgrDicDictionaryBO>();
                    dicDictionaryBOS.add(agrDicDictionaryBO);
                    temp.put(redisKey, dicDictionaryBOS);
                    continue;
                }
                ((List)temp.get(redisKey)).add(agrDicDictionaryBO);
            }
            for (String redisKey : temp.keySet()) {
                this.cacheService.set(redisKey, temp.get(redisKey));
            }
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }
}

