/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import com.ohaotian.plugin.common.util.HanyuPinyinHelper;
import com.tydic.agreement.atom.api.AgrCreateCodeAtomService;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomRspBO;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.utils.AgrDateUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrCreateCodeAtomServiceImpl
implements AgrCreateCodeAtomService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @Override
    public AgrCreateCodeAtomRspBO createCode(AgrCreateCodeAtomReqBO atomReqBO) {
        String code;
        AgrCreateCodeAtomRspBO atomRspBO = new AgrCreateCodeAtomRspBO();
        switch (atomReqBO.getCodeType()) {
            case 1: {
                code = this.createPlaAgreementCode(atomReqBO);
                break;
            }
            case 2: {
                code = this.createAgreementChangeCode(atomReqBO);
                break;
            }
            default: {
                throw new BusinessException("0002", "\u7f16\u7801\u7c7b\u578b\u3010" + atomReqBO.getCodeType() + "\u3011\u4e0d\u652f\u6301");
            }
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u7f16\u7801\u751f\u6210\u6210\u529f");
        atomRspBO.setCode(code);
        return atomRspBO;
    }

    private String createPlaAgreementCode(AgrCreateCodeAtomReqBO atomReqBO) {
        String yearMonth = AgrDateUtils.DateToStr(new Date(), "yyyyMM");
        String maxOrderNum = this.agreementMapper.selectMaxOrderNum(yearMonth);
        String serialNumber = "0001";
        if (maxOrderNum != null && !"".equals(maxOrderNum)) {
            serialNumber = String.format("%04d", Integer.parseInt(maxOrderNum) + 1);
        }
        String orgShortName = HanyuPinyinHelper.getFirstLettersUp((String)atomReqBO.getPlaAgreementCodeBO().getOrgShortName());
        String agreementType = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_TYPE_NAME_TO_CODE_PCODE", atomReqBO.getPlaAgreementCodeBO().getAgreementType());
        if (null == agreementType) {
            throw new BusinessException("22001", "\u534f\u8bae\u7c7b\u522b\u53cd\u5411\u8f6c\u4e49\u5b57\u5178\u672a\u914d\u7f6e");
        }
        String agreementVariety = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_VARIETR_NAME_TO_CODE_PCODE", atomReqBO.getPlaAgreementCodeBO().getAgreementVariety());
        if (null == agreementVariety) {
            throw new BusinessException("22001", "\u91c7\u8d2d\u7c7b\u522b\u53cd\u5411\u8f6c\u4e49\u5b57\u5178\u672a\u914d\u7f6e");
        }
        String code = orgShortName + "-" + agreementType + agreementVariety + "-" + yearMonth + serialNumber;
        return code;
    }

    private String createAgreementChangeCode(AgrCreateCodeAtomReqBO atomReqBO) {
        String changeType = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "CHANGE_TYPE_NAME_TO_CODE_PCODE", atomReqBO.getPlaAgreementChangeCodeBO().getChangeType());
        if (null == changeType) {
            throw new BusinessException("22001", "\u53d8\u66f4\u7c7b\u578b\u53cd\u5411\u8f6c\u4e49\u5b57\u5178\u672a\u914d\u7f6e");
        }
        String plaAgreementCode = atomReqBO.getPlaAgreementChangeCodeBO().getPlaAgreementCode();
        String condition = plaAgreementCode + "-" + changeType + "-";
        String maxOrderNum = this.agreementChangeMapper.selectMaxOrderNum(condition);
        String serialNumber = "0001";
        if (maxOrderNum != null && !"".equals(maxOrderNum)) {
            serialNumber = String.format("%04d", Integer.parseInt(maxOrderNum) + 1);
        }
        String code = plaAgreementCode + "-" + changeType + "-" + serialNumber;
        return code;
    }
}

