/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.atom.api.AgrApproveCreationAtomService;
import com.tydic.agreement.atom.api.AgrCheckAgreementExistAndStatusAtomService;
import com.tydic.agreement.atom.bo.AgrApproveCreationAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementSubmitBusiService;
import com.tydic.agreement.busi.api.AgrGeneralBusiRuleExecService;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiRspBO;
import com.tydic.agreement.busi.bo.AgrGeneralBusiRuleExecReqBO;
import com.tydic.agreement.busi.bo.AgrGeneralBusiRuleExecRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="agrAgreementSubmitBusiService")
public class AgrAgreementSubmitBusiServiceImpl
implements AgrAgreementSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementSubmitBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrCheckAgreementExistAndStatusAtomService agrCheckAgreementExistAndStatusAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${AGR_PLATFORM_CREATE_AUDIT_FLOW:AGR_PLATFORM_CREATE_AUDIT_FLOW}")
    private String platformProcess;
    @Value(value="${AGR_UNIT_CREATE_AUDIT_FLOW:AGR_UNIT_CREATE_AUDIT_FLOW}")
    private String unitProcess;
    @Value(value="${SERVICE_CODE:AGR001}")
    private String SERVICE_CODE;
    @Resource
    private AgrApproveCreationAtomService agrApproveCreationAtomService;
    @Autowired
    private AgrGeneralBusiRuleExecService agrGeneralBusiRuleExecService;

    @Override
    public AgrAgreementSubmitBusiRspBO submitAgreementInfo(AgrAgreementSubmitBusiReqBO busiReqBO) {
        AgrAgreementSubmitBusiRspBO busiRspBO = new AgrAgreementSubmitBusiRspBO();
        AgrCheckAgreementExistAndStatusAtomReqBO atomReqBO = new AgrCheckAgreementExistAndStatusAtomReqBO();
        atomReqBO.setAgreementId(busiReqBO.getAgreementId());
        atomReqBO.setSupplierId(busiReqBO.getSupplierId());
        AgrCheckAgreementExistAndStatusAtomRspBO atomRspBO = this.agrCheckAgreementExistAndStatusAtomService.checkAgreementExistAndStatus(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)atomRspBO), (Object)((Object)busiRspBO));
            return busiRspBO;
        }
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(busiReqBO.getOperType())) {
            AgreementPO po = new AgreementPO();
            po.setSubmissionTime(new Date());
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.TO_CONFIRM);
            this.createAuditNew(atomRspBO, busiReqBO);
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setSupplierId(busiReqBO.getSupplierId());
            int count = this.agreementMapper.updateByCondition(po);
            if (count < 1) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
            }
        } else {
            AgreementPO po = new AgreementPO();
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.DRAFT);
            po.setSupplierId(busiReqBO.getSupplierId());
            po.setSubmissionTime(new Date());
            int n = this.agreementMapper.updateByCondition(po);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u63d0\u4ea4\u4fdd\u5b58\u6210\u529f");
        return busiRspBO;
    }

    private void createProcess(Long agreementId, AgrAgreementBO agrAgreementBO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        approvalObjBO.setObjId(agreementId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(agreementId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u534f\u8bae\u65b0\u589e\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPlatAudit");
        } else if (AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPurchaseAudit");
        }
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(agrAgreementBO.getVendorDepartmentName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(agrAgreementBO.getProducerId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(agrAgreementBO.getProducerName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.error("\u5f00\u59cb\u8c03\u7528\u5ba1\u6279-----");
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new com.tydic.uac.exception.BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
    }

    public void createAuditNew(AgrCheckAgreementExistAndStatusAtomRspBO atomRspBO, AgrAgreementSubmitBusiReqBO busiReqBO) {
        AgrGeneralBusiRuleExecReqBO agrGeneralBusiRuleExecReqBO = new AgrGeneralBusiRuleExecReqBO();
        agrGeneralBusiRuleExecReqBO.setServiceCode(this.SERVICE_CODE);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orgId", busiReqBO.getOrgId().toString());
        paramMap.put("approvalType", "1");
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(atomRspBO.getAgrAgreementBO().getAgreementMode())) {
            paramMap.put("agreementMode", "1");
        } else {
            paramMap.put("agreementMode", "2");
        }
        agrGeneralBusiRuleExecReqBO.setParamMap(paramMap);
        AgrGeneralBusiRuleExecRspBO agrGeneralBusiRuleExecRspBO = this.agrGeneralBusiRuleExecService.generalBusiRuleExec(agrGeneralBusiRuleExecReqBO);
        if (!"0000".equals(agrGeneralBusiRuleExecRspBO.getRespCode())) {
            throw new BusinessException("8888", agrGeneralBusiRuleExecRspBO.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)agrGeneralBusiRuleExecRspBO.getBusiRuleExecResult())) {
            throw new BusinessException("8888", "\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u8fd4\u56de\u4e3a\u7a7a");
        }
        Map resultMap = (Map)JSON.parseObject((String)agrGeneralBusiRuleExecRspBO.getBusiRuleExecResult(), Map.class);
        if (!resultMap.containsKey("processKey") || StringUtils.isEmpty(resultMap.get("processKey"))) {
            throw new BusinessException("8888", "\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u8fd4\u56deprocessKey\u4e3a\u7a7a");
        }
        log.info("\u8fd4\u56de\u540e\u7684\u6d41\u7a0bkey" + (String)resultMap.get("processKey"));
        AgrApproveCreationAtomReqBO approveCreationAtomReqBO = new AgrApproveCreationAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)((Object)approveCreationAtomReqBO));
        approveCreationAtomReqBO.setMenuId((String)resultMap.get("processKey"));
        approveCreationAtomReqBO.setObjId(Collections.singletonList(atomRspBO.getAgrAgreementBO().getAgreementId()));
        try {
            this.agrApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u8ba1\u5212\u4e2d\u5fc3\u5f00\u542f\u5ba1\u6279\u6355\u83b7\u5230\u5f02\u5e38");
            throw new com.tydic.uac.exception.BusinessException("11201", e.getMessage());
        }
    }
}

