/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.agreement.ability.bo.AgrAgreementDictionaryCodeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomReqBO;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomRspBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrBatchImportAgreementSkuBusiService;
import com.tydic.agreement.busi.api.AgrCnncAgrExportImportResultsBusiService;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiRspBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcPesDicQryListByConfigKeysAbilityService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgrBatchImportAgreementSkuBusiServiceImpl
implements AgrBatchImportAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchImportAgreementSkuBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    private UmcPesDicQryListByConfigKeysAbilityService umcPesDicQryListByConfigKeysAbilityService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Autowired
    private AgrCnncAgrExportImportResultsBusiService cnncAgrExportImportResultsBusiService;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public AgrBatchImportAgreementSkuBusiRspBO dealAgrDetailedBatchImportAgreement(AgrBatchImportAgreementSkuBusiReqBO busiReqBO) {
        List agreementSkuPOs;
        AgrBatchImportAgreementSkuBusiRspBO rsp = new AgrBatchImportAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!(AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_ASS.equals(agreement.getAgreementStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d,\u672a\u5b8c\u6210\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\uff01");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(busiReqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title, agreement);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IMPORT_TEMPLATE_PCODE", "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block8: for (AgrImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block8;
            }
        }
        ArrayList importDataMaps = new ArrayList();
        ArrayList<String> materialCodes = new ArrayList<String>();
        ArrayList dateMaps = new ArrayList();
        Map<String, List<AgrAgreementDictionaryCodeBO>> dictMapList = busiReqBO.getData();
        log.info("\u7a0e\u7387\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u503c:{}", dictMapList);
        List<AgrAgreementDictionaryCodeBO> taxRatePcodeList = dictMapList.get("AGR_TAX_RATE_PCODE");
        ArrayList<Byte> taxList = new ArrayList<Byte>();
        for (AgrAgreementDictionaryCodeBO bo : taxRatePcodeList) {
            taxList.add(Byte.valueOf(bo.getCode()));
        }
        List<AgrAgreementDictionaryCodeBO> taxCatCodeList = dictMapList.get("ucc_tax_cat_code_value");
        ArrayList<String> taxCatList = new ArrayList<String>();
        for (AgrAgreementDictionaryCodeBO agrAgreementDictionaryCodeBO : taxCatCodeList) {
            taxCatList.add(agrAgreementDictionaryCodeBO.getCode());
        }
        String errorMessage = "";
        try {
            for (List list : data) {
                boolean importErrMsgFlag = false;
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                StringBuilder importRemark = new StringBuilder();
                for (Object bo : templateBOs) {
                    Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                    if (null == sheetKey) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldNameEng()).append("\u3011\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    if (sheetKey >= list.size()) continue;
                    Object content = list.get(sheetKey);
                    if (bo.getIsMustFill().booleanValue()) {
                        if (null == content || "".equals(content) || "null".equals(content)) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                            continue;
                        }
                    } else if ("null".equals(content)) {
                        content = "";
                    }
                    if ("markupRate".equals(bo.getFieldNameEng())) {
                        String markupRate = (String)content;
                        if (StringUtils.isEmpty((Object)markupRate)) {
                            markupRate = "0";
                        }
                        if (agreement.getTradeMode() == 2 && !markupRate.equals("0")) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u534f\u8bae\u7684\u8d38\u6613\u6a21\u5f0f\u4e3a\u64ae\u5408\u6a21\u5f0f\u65f6\u52a0\u4ef7\u6bd4\u7387\u5fc5\u987b\u4e3a0");
                            continue;
                        }
                        content = markupRate;
                    }
                    if ("buyPrice".equals(bo.getFieldNameEng())) {
                        String buyPrice = (String)content;
                        String string = content = (buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? buyPrice.substring(0, buyPrice.lastIndexOf(".00")) : buyPrice;
                    }
                    if ("salePrice".equals(bo.getFieldNameEng())) {
                        String salePrice = (String)content;
                        content = (salePrice = new BigDecimal(salePrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? salePrice.substring(0, salePrice.lastIndexOf(".00")) : salePrice;
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                    if ("extField6".equals(bo.getFieldNameEng())) {
                        String extField6 = (String)content;
                        content = (extField6 = new BigDecimal(extField6).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? extField6.substring(0, extField6.lastIndexOf(".00")) : extField6;
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                    if ("extField7".equals(bo.getFieldNameEng())) {
                        String extField7 = (String)content;
                        content = (extField7 = new BigDecimal(extField7).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? extField7.substring(0, extField7.lastIndexOf(".00")) : extField7;
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                }
                if (importErrMsgFlag) {
                    dataMap.put("impResult", AgrExtCommonConstant.ImportResult.FAILED);
                    dataMap.put("impRemark", importRemark.toString());
                } else {
                    dataMap.put("impRemark", "\u6210\u529f");
                    dataMap.put("impResult", AgrExtCommonConstant.ImportResult.SUCCESS);
                }
                try {
                    if (Double.valueOf(dataMap.get("taxRate").toString()) < 1.0) {
                        Double taxRate = Double.valueOf(dataMap.get("taxRate").toString()) * 100.0;
                        dataMap.put("taxRate", taxRate.byteValue());
                    }
                    if (Double.valueOf(dataMap.get("markupRate").toString()) < 1.0) {
                        Double markupRate = Double.valueOf(dataMap.get("markupRate").toString()) * 100.0;
                        dataMap.put("markupRate", markupRate.byteValue());
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("22052", "\u6587\u4ef6\u6570\u636e\u89e3\u6790\u9519\u8bef\uff01");
                }
                log.info("\u53c2\u6570:{}", dataMap);
                if (!taxList.contains(dataMap.get("taxRate"))) {
                    errorMessage = "\u7a0e\u7387\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303!";
                    throw new BusinessException("8888", "\u7a0e\u7387\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303");
                }
                if (!taxCatList.contains(dataMap.get("taxCatalog").toString())) {
                    errorMessage = "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303!";
                    throw new BusinessException("8888", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
                }
                importDataMaps.add(dataMap);
                materialCodes.add(dataMap.get("materialCode").toString());
            }
        }
        catch (BusinessException businessException) {
            throw new BusinessException("8888", ObjectUtils.isEmpty((Object)errorMessage) ? "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01" : errorMessage);
        }
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setMaterialCodes(materialCodes);
        agreementSkuPO.setAgreementId(agreement.getAgreementId());
        agreementSkuPO.setAgreementVersion(agreement.getAgreementVersion());
        agreementSkuPO.setIsDelete(Byte.valueOf("0"));
        log.info("\u591a\u6b21\u5bfc\u5165\u6821\u9a8c\u53c2\u6570:{}", (Object)agreementSkuPO);
        List<AgreementSkuPO> list = this.agreementSkuMapper.getList(agreementSkuPO);
        if (!ObjectUtils.isEmpty(list)) {
            throw new BusinessException("8888", "\u7269\u6599\u7f16\u7801:" + list.get(0).getMaterialCode() + "\u5df2\u5b58\u5728");
        }
        String jsonStr = JSON.toJSONString(importDataMaps);
        log.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a" + jsonStr);
        try {
            agreementSkuPOs = JSON.parseArray((String)jsonStr, AgreementSkuPO.class);
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        if (agreementSkuPOs.size() > 3000) {
            throw new BusinessException("0002", "\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u4e0d\u80fd\u8d85\u8fc7 3000\u6761\uff01");
        }
        ArrayList<UccAgrSkuImportCheckBO> rows = new ArrayList<UccAgrSkuImportCheckBO>();
        log.info("\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u89e3\u6790\u6570\u636e \uff1a" + JSONObject.toJSONString(agreementSkuPOs.get(0)));
        for (int i = 0; i < agreementSkuPOs.size(); ++i) {
            UccAgrSkuImportCheckBO bo = new UccAgrSkuImportCheckBO();
            bo.setSerialNumber(Integer.valueOf(i));
            bo.setCommodityTypeName(((AgreementSkuPO)agreementSkuPOs.get(i)).getCommodityTypeName());
            bo.setMaterialCode(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialCode().toString());
            bo.setMeasureName(((AgreementSkuPO)agreementSkuPOs.get(i)).getMeasureName().toString());
            rows.add(bo);
        }
        UccAgrSkuImportCheckAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckAbilityReqBO();
        uccAgrSkuImportCheckAbilityReqBO.setRows(rows);
        ArrayList<AgreementSkuPO> insertSkuPoList = new ArrayList<AgreementSkuPO>();
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (po.getMarkupRate() == null) {
                po.setMarkupRate(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue());
            }
            po.setAgreementSkuId(Sequence.getInstance().nextId());
            po.setAgreementId(agreement.getAgreementId());
            po.setSupplierId(agreement.getSupplierId());
            po.setAgreementVersion(agreement.getAgreementVersion());
            po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            po.setCreateLoginId(busiReqBO.getMemIdIn());
            po.setCreateName(busiReqBO.getUserName());
            po.setCreateTime(new Date());
            po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
            po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
            if (!po.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            insertSkuPoList.add(po);
        }
        List agrAgreementSkuBOList = JSON.parseArray((String)JSON.toJSONString((Object)agreementSkuPOs), AgrAgreementSkuBO.class);
        AgrExportImportResultsBusiReqBO importResultsBusiReqBO = new AgrExportImportResultsBusiReqBO();
        importResultsBusiReqBO.setImportSkuList(agrAgreementSkuBOList);
        importResultsBusiReqBO.setTradeMode(agreement.getTradeMode());
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u5165\u53c2:" + JSON.toJSONString((Object)importResultsBusiReqBO));
        AgrExportImportResultsBusiRspBO importResultsBusiRspBO = this.cnncAgrExportImportResultsBusiService.exportImportResults(importResultsBusiReqBO);
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u51fa\u53c2:" + JSON.toJSONString((Object)((Object)importResultsBusiRspBO)));
        if (!importResultsBusiRspBO.getRespCode().equals("0000")) {
            rsp.setRespCode("8888");
            rsp.setRespCode(importResultsBusiRspBO.getRespCode());
            return rsp;
        }
        Long failedImportCounts = 0L;
        Long sucessImportCounts = 0L;
        for (AgreementSkuPO agreementSkuPO2 : agreementSkuPOs) {
            Long l;
            Long l2;
            if (agreementSkuPO2.getImpResult().equals(AgrExtCommonConstant.ImportResult.FAILED)) {
                l2 = failedImportCounts;
                l = failedImportCounts = Long.valueOf(failedImportCounts + 1L);
                continue;
            }
            if (!agreementSkuPO2.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            l2 = sucessImportCounts;
            l = sucessImportCounts = Long.valueOf(sucessImportCounts + 1L);
        }
        AgrExternalImportResultLogAtomReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogAtomReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(importResultsBusiRspBO.getExportData());
        agrExternalImportResultLogServiceReqBO.setFileName(importResultsBusiRspBO.getFilePath());
        agrExternalImportResultLogServiceReqBO.setFileUrl(importResultsBusiRspBO.getFullFilePath());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(sucessImportCounts);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failedImportCounts);
        agrExternalImportResultLogServiceReqBO.setMemId(busiReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(0);
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(0);
        agrExternalImportResultLogServiceReqBO.setAgreementId(busiReqBO.getAgreementId());
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogAtomRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)((Object)agrExternalImportResultLogServiceRspBO)));
        if (insertSkuPoList.size() > 0) {
            int isInsert = this.agreementSkuMapper.insertBatch(insertSkuPoList);
            rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6210\u529f!\u603b\u5171\u3010" + data.size() + "\u3011\u6761\u6570\u636e\uff0c\u5bfc\u5165\u6210\u529f\u3010" + isInsert + "\u3011\u6761");
        }
        rsp.setRespCode("0000");
        return rsp;
    }

    private void validateParam(List<AgreementSkuPO> agreementSkuPOs) {
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (!StringUtils.isEmpty((Object)po.getSpec()) || !StringUtils.isEmpty((Object)po.getFigure())) continue;
            throw new BusinessException("0001", "\u89c4\u683c/\u578b\u53f7\u548c\u56fe\u53f7/\u5382\u5bb6\u96f6\u4ef6\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, AgreementPO agreement) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < 9) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == 9) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < 10) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }
}

