/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrCreateAgreementSkuChangeBusiServiceImpl
implements AgrCreateAgreementSkuChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSkuChangeBusiServiceImpl.class);
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;

    @Override
    public AgrCreateAgreementSkuChangeBusiRspBO createAgreementSkuChange(AgrCreateAgreementSkuChangeBusiReqBO busiReqBO) {
        int isInsert;
        AgreementSkuChangePO agreementSkuChangePO;
        AgrCreateAgreementSkuChangeBusiRspBO rsp = new AgrCreateAgreementSkuChangeBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        agreementChangePO.setChangeCode(busiReqBO.getChangeCode());
        agreementChangePO.setAgreementId(busiReqBO.getAgreementId());
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        AgreementChangePO daoRsp = this.agreementChangeMapper.getModelBy(agreementChangePO);
        if (!(null == daoRsp || AgrCommConstant.ChangeApplyStatus.DRAFT.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_PASS.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_CONFIRM.equals(daoRsp.getStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53d8\u66f4\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\uff01");
        }
        if (CollectionUtils.isEmpty(busiReqBO.getAgrAgreementSkuChangeBOs())) {
            throw new BusinessException("22002", "\u65b0\u589e\u53d8\u66f4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (AgrAgreementSkuChangeBO each : busiReqBO.getAgrAgreementSkuChangeBOs()) {
            log.info("\u534f\u8bae\u8c03\u4ef7-\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u53c2\u6570\uff1a{}", (Object)each);
            if (each.getChangeType() != 1) continue;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            agreementSkuPO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuPO.setMaterialCode(each.getMaterialCode().toString());
            List<AgreementSkuPO> agreementSkuPOList = this.agreementSkuMapper.getList(agreementSkuPO);
            if (!CollectionUtils.isEmpty(agreementSkuPOList)) {
                throw new BusinessException("22002", "\u65b0\u589e\u7269\u6599\u4e0d\u80fd\u5df2\u7ecf\u5b58\u5728\uff01" + each.getMaterialCode() + "\u4e0d\u80fd\u91cd\u590d\u65b0\u589e");
            }
            agreementSkuChangePO = new AgreementSkuChangePO();
            agreementSkuChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO.setMaterialCode(each.getMaterialCode().toString());
            agreementSkuChangePO.setChangeCode(busiReqBO.getChangeCode());
            List<AgreementSkuChangePO> agreementSkuChangePOList = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
            if (CollectionUtils.isEmpty(agreementSkuChangePOList)) continue;
            throw new BusinessException("22002", "\u7269\u6599\u53ea\u80fd\u65b0\u589e\u4e00\u6b21\uff0c\u4e14\u539f\u534f\u8bae\u4e2d\u5df2\u6709\u7684\u7269\u6599\u4e0d\u80fd\u518d\u88ab\u6dfb\u52a0\uff01" + each.getMaterialCode() + "\u4e0d\u80fd\u91cd\u590d\u65b0\u589e");
        }
        ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
        ArrayList<AgreementSkuChangePO> agreementSkuChangePOs = new ArrayList<AgreementSkuChangePO>();
        for (AgrAgreementSkuChangeBO bo : busiReqBO.getAgrAgreementSkuChangeBOs()) {
            if (null != bo.getAgreementSkuId()) {
                agreementSkuIds.add(bo.getAgreementSkuId());
            }
            agreementSkuChangePO = new AgreementSkuChangePO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuChangePO);
            agreementSkuChangePO.setSkuChangeId(Sequence.getInstance().nextId());
            agreementSkuChangePO.setAgreementVersion(agreement.getAgreementVersion());
            agreementSkuChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO.setChangeCode(busiReqBO.getChangeCode());
            agreementSkuChangePO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
            agreementSkuChangePO.setCreateName(busiReqBO.getUserName());
            agreementSkuChangePO.setCreateTime(new Date());
            agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuChangePOs.add(agreementSkuChangePO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuIds)) {
            AgreementSkuChangePO agreementSkuChangePO1 = new AgreementSkuChangePO();
            agreementSkuChangePO1.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO1.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO1.setChangeCode(busiReqBO.getChangeCode());
            agreementSkuChangePO1.setAgreementSkuIds(agreementSkuIds);
            this.agreementSkuChangeMapper.deleteBy(agreementSkuChangePO1);
        }
        if ((isInsert = this.agreementSkuChangeMapper.insertBatch(agreementSkuChangePOs)) != agreementSkuChangePOs.size()) {
            throw new BusinessException("22003", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589e\u6210\u529f\uff01");
        return rsp;
    }
}

