/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrCnncAgrExportImportResultsBusiService;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiRspBO;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgrExportImportResultsBusiServiceImpl
implements AgrCnncAgrExportImportResultsBusiService {
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${preFilePath}")
    private String preFilePath;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;

    @Override
    public AgrExportImportResultsBusiRspBO exportImportResults(AgrExportImportResultsBusiReqBO reqBO) {
        AgrExportImportResultsBusiRspBO rspBO = new AgrExportImportResultsBusiRspBO();
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> Data = new ArrayList<Map<String, Object>>();
        int index = 0;
        if (reqBO.getImportSkuList() != null) {
            for (AgrAgreementSkuBO agrAgreementSkuBO : reqBO.getImportSkuList()) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u7f16\u53f7", agrAgreementSkuBO.getAgreementSkuId() != null ? agrAgreementSkuBO.getAgreementSkuId() : "");
                item.put("\u5546\u54c1\u7c7b\u578b", agrAgreementSkuBO.getCatalogName() != null ? agrAgreementSkuBO.getCatalogName() : "");
                item.put("\u7269\u6599\u7f16\u7801", agrAgreementSkuBO.getMaterialCode() != null ? agrAgreementSkuBO.getMaterialCode() : "");
                item.put("\u578b\u53f7", agrAgreementSkuBO.getModel() != null ? agrAgreementSkuBO.getModel() : "");
                item.put("\u89c4\u683c", agrAgreementSkuBO.getSpec() != null ? agrAgreementSkuBO.getSpec() : "");
                item.put("\u54c1\u724c", agrAgreementSkuBO.getBrandName() != null ? agrAgreementSkuBO.getBrandName() : "");
                item.put("\u4f9b\u8d27\u5468\u671f", agrAgreementSkuBO.getSupplyCycle() != null ? agrAgreementSkuBO.getSupplyCycle() : "");
                item.put("\u8ba1\u91cf\u5355\u4f4d", agrAgreementSkuBO.getMeasureName() != null ? agrAgreementSkuBO.getMeasureName() : "");
                item.put("\u7a0e\u6536\u7f16\u7801", agrAgreementSkuBO.getTaxCatalog() != null ? agrAgreementSkuBO.getTaxCatalog() : "");
                if (agrAgreementSkuBO.getIsOil() != null) {
                    if (agrAgreementSkuBO.getIsOil().equals((byte)0)) {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9\uff081\u662f 0\u5426\uff09", "\u5426");
                    } else {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9\uff081\u662f 0\u5426\uff09", "\u662f");
                    }
                } else {
                    item.put("\u662f\u5426\u6210\u54c1\u6cb9\uff081\u662f 0\u5426\uff09", "");
                }
                item.put("\u6570\u91cf", agrAgreementSkuBO.getBuyNumber() != null ? agrAgreementSkuBO.getBuyNumber() : "");
                item.put("\u91c7\u8d2d\u5355\u4ef7", agrAgreementSkuBO.getBuyPrice() != null ? new BigDecimal(agrAgreementSkuBO.getBuyPrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (reqBO.getTradeMode().equals((byte)2)) {
                    item.put("\u52a0\u4ef7\u6bd4\u7387", agrAgreementSkuBO.getMarkupRate() != null ? agrAgreementSkuBO.getMarkupRate() : "");
                    item.put("\u534f\u8bae\u4ef7\u4e0a\u9650", agrAgreementSkuBO.getExtField6() != null ? new BigDecimal(agrAgreementSkuBO.getExtField6()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                    item.put("\u534f\u8bae\u4ef7\u4e0b\u9650", agrAgreementSkuBO.getExtField7() != null ? new BigDecimal(agrAgreementSkuBO.getExtField7()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                }
                item.put("\u91c7\u8d2d\u603b\u8ba1", agrAgreementSkuBO.getBuyPriceSum() != null ? new BigDecimal(agrAgreementSkuBO.getBuyPriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u5355\u4ef7", agrAgreementSkuBO.getSalePrice() != null ? new BigDecimal(agrAgreementSkuBO.getSalePrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u603b\u4ef7", agrAgreementSkuBO.getSalePriceSum() != null ? new BigDecimal(agrAgreementSkuBO.getSalePriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (agrAgreementSkuBO.getImpResult() != null) {
                    if (agrAgreementSkuBO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                        item.put("\u5931\u8d25\u539f\u56e0", "");
                    } else {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                        item.put("\u5931\u8d25\u539f\u56e0", agrAgreementSkuBO.getImpRemark() != null ? agrAgreementSkuBO.getImpRemark() : "");
                    }
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
                }
                LinkedHashMap copyItem = new LinkedHashMap(item);
                exportData.add(item);
                Data.add(copyItem);
            }
        } else {
            for (AgrAgreementSkuChangeBO agrAgreementSkuChangeBO : reqBO.getImportSkuChangeList()) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u7f16\u53f7", agrAgreementSkuChangeBO.getAgreementSkuId() != null ? agrAgreementSkuChangeBO.getAgreementSkuId() : "");
                item.put("\u5546\u54c1\u7c7b\u578b", agrAgreementSkuChangeBO.getCatalogName() != null ? agrAgreementSkuChangeBO.getCatalogName() : "");
                item.put("\u7269\u6599\u7f16\u7801", agrAgreementSkuChangeBO.getMaterialId() != null ? agrAgreementSkuChangeBO.getMaterialId() : "");
                item.put("\u578b\u53f7", agrAgreementSkuChangeBO.getModel() != null ? agrAgreementSkuChangeBO.getModel() : "");
                item.put("\u89c4\u683c", agrAgreementSkuChangeBO.getSpec() != null ? agrAgreementSkuChangeBO.getSpec() : "");
                item.put("\u54c1\u724c", agrAgreementSkuChangeBO.getBrandName() != null ? agrAgreementSkuChangeBO.getBrandName() : "");
                item.put("\u4f9b\u8d27\u5468\u671f", agrAgreementSkuChangeBO.getSupplyCycle() != null ? agrAgreementSkuChangeBO.getSupplyCycle() : "");
                item.put("\u8ba1\u91cf\u5355\u4f4d", agrAgreementSkuChangeBO.getMeasureName() != null ? agrAgreementSkuChangeBO.getMeasureName() : "");
                item.put("\u7a0e\u6536\u7f16\u7801", agrAgreementSkuChangeBO.getTaxCatalog() != null ? agrAgreementSkuChangeBO.getTaxCatalog() : "");
                if (agrAgreementSkuChangeBO.getIsOil() != null) {
                    if (agrAgreementSkuChangeBO.getIsOil().equals((byte)0)) {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9\uff081\u662f 0\u5426\uff09", "\u5426");
                    } else {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9\uff081\u662f 0\u5426\uff09", "\u662f");
                    }
                } else {
                    item.put("\u662f\u5426\u6210\u54c1\u6cb9\uff081\u662f 0\u5426\uff09", "");
                }
                item.put("\u6570\u91cf", agrAgreementSkuChangeBO.getBuyNumber() != null ? agrAgreementSkuChangeBO.getBuyNumber() : "");
                item.put("\u91c7\u8d2d\u5355\u4ef7", agrAgreementSkuChangeBO.getBuyPrice() != null ? new BigDecimal(agrAgreementSkuChangeBO.getBuyPrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (reqBO.getTradeMode().equals((byte)2)) {
                    item.put("\u52a0\u4ef7\u6bd4\u7387", agrAgreementSkuChangeBO.getMarkupRate() != null ? agrAgreementSkuChangeBO.getMarkupRate() : "");
                }
                item.put("\u91c7\u8d2d\u603b\u8ba1", agrAgreementSkuChangeBO.getBuyPriceSum() != null ? new BigDecimal(agrAgreementSkuChangeBO.getBuyPriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u5355\u4ef7", agrAgreementSkuChangeBO.getSalePrice() != null ? new BigDecimal(agrAgreementSkuChangeBO.getSalePrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u603b\u4ef7", agrAgreementSkuChangeBO.getSalePriceSum() != null ? new BigDecimal(agrAgreementSkuChangeBO.getSalePriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (agrAgreementSkuChangeBO.getImpResult() != null) {
                    if (agrAgreementSkuChangeBO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                        item.put("\u5931\u8d25\u539f\u56e0", "");
                    } else {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                        item.put("\u5931\u8d25\u539f\u56e0", agrAgreementSkuChangeBO.getImpRemark() != null ? agrAgreementSkuChangeBO.getImpRemark() : "");
                        exportData.add(item);
                    }
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
                    exportData.add(item);
                }
                LinkedHashMap copyItem = new LinkedHashMap(item);
                Data.add(copyItem);
            }
        }
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = this.preFilePath + rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setExportData(Data);
        rspBO.setFullFilePath(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efaexcel \u6570\u636e\u6210\u529f!");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, AgrExportImportResultsBusiRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.agrskucreateWorkbook(data, "\u4e2d\u6838\u534f\u8bae\u660e\u7ec6\u5bfc\u51fa");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "agr";
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("22051", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }

    public static void main(String[] args) {
        BigDecimal number = new BigDecimal(10000L).divide(new BigDecimal("10000")).setScale(3, 1);
        System.out.println(number.toString());
    }
}

