/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.busi.api.AgrSendMessageBusiService;
import com.tydic.agreement.busi.bo.AgrSendMessageBusiReqBO;
import com.tydic.agreement.busi.bo.AgrSendMessageBusiRspBO;
import com.tydic.agreement.busi.bo.SendMessageBO;
import com.tydic.commodity.base.bo.RspUccBo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgrSendMessageBusiServiceImpl
implements AgrSendMessageBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrSendMessageBusiServiceImpl.class);
    @Value(value="${AGR_SEND_MESSAGE_URL:http://10.200.199.100/gemini/task/pushTaskInfo}")
    private String AGR_SEND_MESSAGE_URL;

    @Override
    public AgrSendMessageBusiRspBO agrSendMessage(AgrSendMessageBusiReqBO reqBO) {
        AgrSendMessageBusiRspBO rspBO = new AgrSendMessageBusiRspBO();
        log.info("\u53d1\u901a\u77e5\u539f\u5b50\u670d\u52a1\u5165\u53c2{}->" + JSON.toJSONString((Object)((Object)reqBO)));
        for (String taskCode : reqBO.getSendList().keySet()) {
            String reqStr = this.initReqStr(reqBO.getSendList().get(taskCode), taskCode);
            log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u5165\u53c2{}->" + reqStr);
            try {
                String s = HttpUtil.post((String)this.AGR_SEND_MESSAGE_URL, (String)reqStr);
                log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u8fd4\u56de\u6d88\u606f{}->" + s);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25,{}", (Object)e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String initReqStr(List<SendMessageBO> sendMessageAtomBOS, String taskCode) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("taskCode", (Object)taskCode);
        JSONObject data = new JSONObject();
        if ("1".equals(sendMessageAtomBOS.get(0).getBusinessType())) {
            data.put("plaAgreementCode", (Object)sendMessageAtomBOS.get(0).getPlaAgreementCode());
        } else {
            data.put("changeCode", (Object)sendMessageAtomBOS.get(0).getChangeCode());
        }
        reqJson.put("data", (Object)data.toJSONString());
        reqJson.put("sendId", (Object)sendMessageAtomBOS.get(0).getSendId());
        reqJson.put("sendName", (Object)sendMessageAtomBOS.get(0).getSendName());
        JSONArray receivers = new JSONArray();
        for (SendMessageBO each : sendMessageAtomBOS) {
            JSONObject receiver = new JSONObject();
            receiver.put("receiverId", (Object)each.getReceiverId());
            receiver.put("receiverName", (Object)each.getReceiverName());
            receiver.put("mobileNumber", (Object)each.getMobileNumber());
            receivers.add((Object)receiver);
        }
        reqJson.put("receivers", (Object)receivers);
        return reqJson.toString();
    }

    private RspUccBo resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            return (RspUccBo)JSON.toJavaObject((JSON)rspJsonObject, RspUccBo.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

