/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.atom.api.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrCreateAgreementSkuAtomServiceImpl
implements AgrCreateAgreementSkuAtomService {
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;

    @Override
    public AgrCreateAgreementSkuAtomRspBO createAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        for (AgrAgreementSkuBO each : atomReqBO.getAgrAgreementSkuBOs()) {
            AgreementSkuPO temp = new AgreementSkuPO();
            temp.setAgreementId(atomReqBO.getAgreementId());
            temp.setMaterialId(each.getMaterialId());
            temp.setIsDelete((byte)0);
            List<AgreementSkuPO> list = this.agreementSkuMapper.getList(temp);
            if (CollectionUtils.isEmpty(list)) continue;
            throw new ZTBusinessException("\u8be5\u534f\u8bae\u4e0b\u5df2\u5b58\u5728\u7269\u6599\uff1a" + each.getMaterialName());
        }
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuLogPO> agrAgreementSkuLogPOs = new ArrayList<AgreementSkuLogPO>();
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuLogPO);
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setAgreementVersion(atomReqBO.getAgreementVersion());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            agreementSkuPO.setBuyPriceSum(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            agreementSkuPO.setSysTenantId(atomReqBO.getSysTenantId());
            agreementSkuPO.setSysTenantName(atomReqBO.getSysTenantName());
            if (StringUtils.isBlank((CharSequence)agreementSkuPO.getCatalogId())) {
                agreementSkuPO.setCatalogId(agreementSkuPO.getCommodityTypeId().toString());
                agreementSkuPO.setCatalogName(agreementSkuPO.getCommodityTypeName());
            }
            agrAgreementSkuPOs.add(agreementSkuPO);
            Long agreementSkuLogId = Sequence.getInstance().nextId();
            agreementSkuLogPO.setAgreementSkuLogId(agreementSkuLogId);
            agreementSkuLogPO.setAgreementSkuId(agreementSkuId);
            agreementSkuLogPO.setAgreementLogId(atomReqBO.getAgreementLogId());
            agreementSkuLogPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuLogPO.setAgreementVersion(atomReqBO.getAgreementVersion());
            agreementSkuLogPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuLogPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuLogPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuLogPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuLogPO.setCreateName(atomReqBO.getUserName());
            agreementSkuLogPO.setCreateTime(new Date());
            agreementSkuLogPO.setBuyPriceSum(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            agreementSkuLogPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            agreementSkuLogPO.setSysTenantId(atomReqBO.getSysTenantId());
            agreementSkuLogPO.setSysTenantName(atomReqBO.getSysTenantName());
            if (StringUtils.isBlank((CharSequence)agreementSkuLogPO.getCatalogId())) {
                agreementSkuLogPO.setCatalogId(agreementSkuLogPO.getCommodityTypeId().toString());
            }
            agrAgreementSkuLogPOs.add(agreementSkuLogPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        int isInsert2 = this.agreementSkuLogMapper.insertBatch(agrAgreementSkuLogPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    @Override
    public AgrCreateAgreementSkuAtomRspBO createExtAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            agreementSkuPO.setAgreementVersion("null");
            agreementSkuPO.setManufacturer("null");
            agreementSkuPO.setBuyPriceSum(0L);
            agreementSkuPO.setMarkupRate(0.0);
            agreementSkuPO.setSalePrice(0L);
            agreementSkuPO.setSalePriceSum(0L);
            agreementSkuPO.setMeasureName("null");
            agreementSkuPO.setBuyNumber(BigDecimal.ZERO);
            agreementSkuPO.setSysTenantId(atomReqBO.getSysTenantId());
            agreementSkuPO.setSysTenantName(atomReqBO.getSysTenantName());
            agrAgreementSkuPOs.add(agreementSkuPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    public static void main(String[] args) {
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setBuyPrice(10000L);
        agreementSkuPO.setBuyNumber(new BigDecimal(10));
        agreementSkuPO.setMarkupRate(5.4);
        agreementSkuPO.setBuyPriceSum(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
        agreementSkuPO.setSalePrice(new BigDecimal(agreementSkuPO.getBuyPrice()).add(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(new BigDecimal(agreementSkuPO.getMarkupRate().toString())).divide(new BigDecimal(100))).longValue());
        agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
        System.out.println(JSON.toJSONString((Object)agreementSkuPO));
    }
}

