/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.commodity.common.ability.api.UccEbsMaterialAddAbilityService;
import com.tydic.commodity.common.ability.api.UccEbsMaterialEditAbilityService;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialAddAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialEditAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialEditAbilityRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EbsMaterialAddMqServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(EbsMaterialAddMqServiceConsumer.class);
    @Autowired
    private UccEbsMaterialAddAbilityService uccEbsMaterialAddAbilityService;
    @Autowired
    private UccEbsMaterialEditAbilityService uccEbsMaterialEditAbilityService;
    @Autowired
    private AgreementMapper agreementMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        AgreementSkuPO agrSkuPo;
        String content = message.getContent();
        log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b:{}" + content);
        try {
            agrSkuPo = (AgreementSkuPO)JSON.parseObject((String)content, AgreementSkuPO.class);
            log.info("\u8f6c\u6362\u540e\u53c2\u6570\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)agrSkuPo));
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        try {
            AgreementPO agreementQryPo = new AgreementPO();
            agreementQryPo.setAgreementId(agrSkuPo.getAgreementId());
            agreementQryPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO agreement = this.agreementMapper.getModelBy(agreementQryPo);
            UccEbsMaterialAddAbilityReqBO uccEbsMaterialAddReqBo = new UccEbsMaterialAddAbilityReqBO();
            UccEbsMaterialEditAbilityReqBO uccEbsMaterialEditReqBo = new UccEbsMaterialEditAbilityReqBO();
            uccEbsMaterialAddReqBo.setEbsMaterialCode(agrSkuPo.getEbsMaterialCode());
            uccEbsMaterialAddReqBo.setEbsMeasure(agrSkuPo.getMeasureName());
            uccEbsMaterialAddReqBo.setEbsMaterialName(agrSkuPo.getMaterialName());
            uccEbsMaterialAddReqBo.setEbsLongDesc(agrSkuPo.getMaterialName());
            uccEbsMaterialAddReqBo.setEbsModel(agrSkuPo.getSpec() + "/" + agrSkuPo.getModel());
            uccEbsMaterialAddReqBo.setBrandName(agrSkuPo.getBrandName());
            uccEbsMaterialAddReqBo.setEbsInvalid("N");
            uccEbsMaterialAddReqBo.setSysCode(agreement.getAgreementBelongsCode());
            log.info("\u65b0\u589e\u7269\u6599\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialAddReqBo));
            UccEbsMaterialAddAbilityRspBO uccEbsMaterialAddRspBo = this.uccEbsMaterialAddAbilityService.dealAddMaterialEdit(uccEbsMaterialAddReqBo);
            log.info("\u65b0\u589e\u7269\u6599\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialAddRspBo));
            if (!"0000".equals(uccEbsMaterialAddRspBo.getRespCode())) {
                log.warn("\u65b0\u589e\u5173\u8054\u7269\u6599[{}]\u5931\u8d25\uff1a{}", (Object)agrSkuPo.getEbsMaterialCode(), (Object)uccEbsMaterialAddRspBo.getRespDesc());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            uccEbsMaterialEditReqBo.setEbsMaterialId(uccEbsMaterialAddRspBo.getEsbMaterialId());
            uccEbsMaterialEditReqBo.setMaterialId(Long.valueOf(agrSkuPo.getMaterialId()));
            uccEbsMaterialEditReqBo.setIsOut(Integer.valueOf(1));
            log.info("\u5173\u8054\u7269\u6599\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialEditReqBo));
            UccEbsMaterialEditAbilityRspBO uccEbsMaterialEditRspBO = this.uccEbsMaterialEditAbilityService.dealEbsMaterialEdit(uccEbsMaterialEditReqBo);
            log.info("\u5173\u8054\u7269\u6599\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialEditRspBO));
            if (!"0000".equals(uccEbsMaterialEditRspBO.getRespCode())) {
                log.warn("\u5173\u8054\u7269\u6599\u5173\u7cfb\u5931\u8d25\uff1a{}", (Object)uccEbsMaterialEditRspBO.getRespDesc());
            }
            log.info("\u7269\u6599{}-{}\u5173\u8054\u6210\u529f\u3002", (Object)agrSkuPo.getEbsMaterialCode(), (Object)agrSkuPo.getMaterialCode());
        }
        catch (Exception e) {
            log.error("\u6d41\u7a0bMQ\u6d88\u8d39\uff1a\u8c03\u7528\u670d\u52a1\u5904\u7406MQ\u9519\u8bef");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

