/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.busi.api.AgrUpdatePriceTermTimeTaskBusiService;
import com.tydic.agreement.busi.bo.AgrUpdatePriceTermTimeTaskBusiReqBO;
import com.tydic.agreement.busi.bo.AgrUpdatePriceTermTimeTaskBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.consumer.bo.PriceAgreementBO;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.uac.exception.BusinessException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgrUpdatePriceTermTimeTaskBusiServiceImpl
implements AgrUpdatePriceTermTimeTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrUpdatePriceTermTimeTaskBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Value(value="${AGR_PRICE_AGREEMENT_TOPIC:AGR_PRICE_AGREEMENT_TOPIC}")
    private String agrPriceAgreementTopic;
    @Value(value="${AGR_PRICE_AGREEMENT_TAG:*}")
    private String agrPriceAgreementTag;
    @Resource(name="agrSyncPriceAgreementMqServiceProvider")
    private ProxyMessageProducer agrSyncPriceAgreementMqServiceProvider;

    @Override
    public AgrUpdatePriceTermTimeTaskBusiRspBO execute(AgrUpdatePriceTermTimeTaskBusiReqBO reqBO) {
        AgrUpdatePriceTermTimeTaskBusiRspBO rspBO = new AgrUpdatePriceTermTimeTaskBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementClassification(4);
        agreementPO.setWhthinPriceTerm(1);
        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
        List<AgreementPO> agreementPOs = this.agreementMapper.getEnablePriceList(agreementPO);
        if (!CollectionUtils.isEmpty(agreementPOs)) {
            ArrayList<Long> agreementIds = new ArrayList<Long>();
            ArrayList<String> plaAgreementCodes = new ArrayList<String>();
            for (AgreementPO po : agreementPOs) {
                if (!StringUtils.isNotBlank((CharSequence)po.getAgreementPriceUseTerm()) || this.isPriceValid(po.getEffDate(), po.getAgreementPriceUseTerm())) continue;
                agreementIds.add(po.getAgreementId());
                plaAgreementCodes.add(po.getPlaAgreementCode());
            }
            if (!CollectionUtils.isEmpty(agreementIds)) {
                AgreementPO updatePO = new AgreementPO();
                updatePO.setAgreementIds(agreementIds);
                updatePO.setWhthinPriceTerm(0);
                int count1 = this.agreementMapper.updateByCondition(updatePO);
                if (count1 != agreementIds.size()) {
                    throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868extField1\u5931\u8d25");
                }
                for (String plaAgreementCode : plaAgreementCodes) {
                    PriceAgreementBO priceAgreementBO = new PriceAgreementBO();
                    priceAgreementBO.setPlaAgreementCode(plaAgreementCode);
                    log.info("\u5b9a\u4ef7\u534f\u8bae\u5931\u6548\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)priceAgreementBO));
                    this.agrSyncPriceAgreementMqServiceProvider.send(new ProxyMessage(this.agrPriceAgreementTopic, this.agrPriceAgreementTag, JSON.toJSONString((Object)priceAgreementBO)));
                }
            }
        }
        return rspBO;
    }

    public boolean isPriceValid(Date effDate, String agreementPriceUseTerm) {
        LocalDate effectiveDate = effDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int validityPeriodInDays = Integer.parseInt(agreementPriceUseTerm);
        LocalDate expirationDate = effectiveDate.plusDays(validityPeriodInDays);
        LocalDate currentDate = LocalDate.now();
        return expirationDate.isAfter(currentDate);
    }
}

