/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementDictionaryCodeBO;
import com.tydic.agreement.ability.bo.AgrChangeSkuBO;
import com.tydic.agreement.busi.api.AgrBatchAddImportLogBusiService;
import com.tydic.agreement.busi.bo.AgrBatchAddImportLogBusiReqBO;
import com.tydic.agreement.busi.bo.AgrBatchAddImportLogBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuImportFileMapper;
import com.tydic.agreement.dao.AgrAgreementSkuImportLogMapper;
import com.tydic.agreement.dao.AgrAgreementSkuImportLogOriginalMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgrAgreementSkuImportFilePO;
import com.tydic.agreement.po.AgrAgreementSkuImportLogOriginalPO;
import com.tydic.agreement.po.AgrAgreementSkuImportLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.commodity.common.ability.api.UccAgrSkuImportCheckNewAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuTypeQryByNameAbilityService;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import com.tydic.ppc.ability.api.PpcPurchaseDemandQryListAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrBatchAddImportLogBusiServiceImpl
implements AgrBatchAddImportLogBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchAddImportLogBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrAgreementSkuImportFileMapper agrAgreementSkuImportFileMapper;
    @Autowired
    private AgrAgreementSkuImportLogMapper agrAgreementSkuImportLogMapper;
    @Autowired
    private AgrAgreementSkuImportLogOriginalMapper agrAgreementSkuImportLogOriginalMapper;
    @Autowired
    private PpcPurchaseDemandQryListAbilityService ppcPurchaseDemandQryListAbilityService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;
    @Autowired
    private UccAgrSkuImportCheckNewAbilityService uccAgrSkuImportCheckNewAbilityService;
    @Autowired
    private UccSpuTypeQryByNameAbilityService uccSpuTypeQryByNameAbilityService;
    @Autowired
    private UccSkuManagementListQryAbilityService uccSkuManagementListQryAbilityService;
    @Value(value="${HK.sysTenantId:1104853665419067393}")
    private Long sysTenantIdHK;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public AgrBatchAddImportLogBusiRspBO dealBatchAddImportLog(AgrBatchAddImportLogBusiReqBO busiReqBO) {
        AgrBatchAddImportLogBusiRspBO rspBO = new AgrBatchAddImportLogBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        Map<String, List<AgrAgreementDictionaryCodeBO>> dictMapList = busiReqBO.getData();
        log.info("\u7a0e\u7387\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u503c:{}", dictMapList);
        List<AgrAgreementDictionaryCodeBO> taxRatePcodeList = dictMapList.get("AGR_TAX_RATE_PCODE");
        ArrayList<Byte> taxList = new ArrayList<Byte>();
        for (AgrAgreementDictionaryCodeBO bo : taxRatePcodeList) {
            taxList.add(Byte.valueOf(bo.getCode()));
        }
        List<AgrAgreementDictionaryCodeBO> taxCatCodeList = dictMapList.get("ucc_tax_cat_code_value");
        ArrayList<String> taxCatList = new ArrayList<String>();
        for (AgrAgreementDictionaryCodeBO bo : taxCatCodeList) {
            taxCatList.add(bo.getCode());
        }
        ArrayList addTaxCatList = new ArrayList();
        ArrayList<AgrAgreementSkuImportLogPO> agrAgreementSkuImportLogPOList = new ArrayList<AgrAgreementSkuImportLogPO>();
        ArrayList<AgrAgreementSkuImportLogOriginalPO> agrAgreementSkuImportLogOriginalPOS = new ArrayList<AgrAgreementSkuImportLogOriginalPO>();
        Long importFileId = Sequence.getInstance().nextId();
        for (AgrChangeSkuBO agrChangeSkuBO : busiReqBO.getAgrChangeSkuBOs()) {
            AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPO = new AgrAgreementSkuImportLogPO();
            AgrAgreementSkuImportLogOriginalPO agrAgreementSkuImportLogOriginalPO = new AgrAgreementSkuImportLogOriginalPO();
            agrAgreementSkuImportLogPO.setImportStatus("1");
            agrAgreementSkuImportLogPO.setFailReason("\u6210\u529f");
            agrAgreementSkuImportLogPO.setImportFileId(importFileId);
            agrAgreementSkuImportLogPO.setId(Sequence.getInstance().nextId());
            if (StringUtils.isBlank((CharSequence)agrChangeSkuBO.getXcCategory())) {
                agrChangeSkuBO.setXcCategory("\u5426");
            } else if ("1".equals(agrChangeSkuBO.getXcCategory())) {
                agrChangeSkuBO.setXcCategory("\u662f");
            } else {
                agrChangeSkuBO.setXcCategory("\u5426");
            }
            if (StringUtils.isBlank((CharSequence)agrChangeSkuBO.getXcSku())) {
                agrChangeSkuBO.setXcSku("\u5426");
            } else if ("1".equals(agrChangeSkuBO.getXcSku())) {
                agrChangeSkuBO.setXcSku("\u662f");
            } else {
                agrChangeSkuBO.setXcSku("\u5426");
            }
            BeanUtils.copyProperties((Object)agrAgreementSkuImportLogPO, (Object)agrAgreementSkuImportLogOriginalPO);
            agrAgreementSkuImportLogPOList.add(agrAgreementSkuImportLogPO);
            agrAgreementSkuImportLogOriginalPOS.add(agrAgreementSkuImportLogOriginalPO);
        }
        AgrAgreementSkuImportFilePO agrAgreementSkuImportFilePo = new AgrAgreementSkuImportFilePO();
        agrAgreementSkuImportFilePo.setImportFileId(importFileId);
        agrAgreementSkuImportFilePo.setAgreementId(busiReqBO.getAgreementId());
        agrAgreementSkuImportFilePo.setImportType("2");
        agrAgreementSkuImportFilePo.setCreateOperId(busiReqBO.getUserId());
        agrAgreementSkuImportFilePo.setCreateOperName(busiReqBO.getName());
        agrAgreementSkuImportFilePo.setCreateOrgId(busiReqBO.getOrgId());
        agrAgreementSkuImportFilePo.setCreateOrgName(busiReqBO.getOrgName());
        agrAgreementSkuImportFilePo.setCreateTimt(new Date());
        this.agrAgreementSkuImportFileMapper.insert(agrAgreementSkuImportFilePo);
        if (!CollectionUtils.isEmpty(agrAgreementSkuImportLogPOList)) {
            this.agrAgreementSkuImportLogMapper.insertBatch(agrAgreementSkuImportLogPOList);
            this.agrAgreementSkuImportLogOriginalMapper.insertBatch(agrAgreementSkuImportLogOriginalPOS);
        }
        rspBO.setImportFileId(importFileId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static boolean isValidTwoDecimals(String input) {
        String regex = "^\\d+(\\.\\d{1,2})?$";
        if (input.matches(regex)) {
            try {
                double number = Double.parseDouble(input);
                return number > 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public void refreshCodeList(String key) {
        this.cacheClient.delete(DICTIONARY_KEY_PREFIX + key);
        FscQueryDictionaryAbilityReqBO reqBO = new FscQueryDictionaryAbilityReqBO();
        reqBO.setPcode("FSC_TAX_CAT_CODE_VALUE");
        FscRspPageBaseBO qryRspBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(reqBO);
        if ("0000".equals(qryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            this.cacheClient.set(DICTIONARY_KEY_PREFIX + key, (Object)qryRspBO.getRows(), AgrBatchAddImportLogBusiServiceImpl.getExpireSeconds(3600, 10));
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }
}

