/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.busi.api.AgrDeleteAgreementBusiService;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementBusiReqBO;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementCodeRelaMapper;
import com.tydic.agreement.dao.AgrAgreementVendorMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementCodeRelaPO;
import com.tydic.agreement.po.AgrAgreementVendorPO;
import com.tydic.agreement.po.AgreementPO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrDeleteAgreementBusiServiceImpl
implements AgrDeleteAgreementBusiService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementVendorMapper agrAgreementVendorMapper;
    @Autowired
    private AgrAgreementCodeRelaMapper agrAgreementCodeRelaMapper;

    @Override
    public AgrDeleteAgreementBusiRspBO deleteAgreementInfo(AgrDeleteAgreementBusiReqBO busiReqBO) {
        AgrDeleteAgreementBusiRspBO rsp = new AgrDeleteAgreementBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementIds(busiReqBO.getAgreementIds());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOs = this.agreementMapper.getList(agreementPO);
        if (agreementPOs.size() != busiReqBO.getAgreementIds().size()) {
            throw new BusinessException("22001", "\u6709\u4e0d\u5b58\u5728\u7684\u534f\u8baeId\uff01");
        }
        Map agreementPOMap = agreementPOs.stream().collect(Collectors.toMap(AgreementPO::getAgreementId, Function.identity()));
        for (AgreementPO po : agreementPOs) {
            if (AgrCommConstant.AgreementStatus.DRAFT.equals(po.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(po.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_CONFIRM.equals(po.getAgreementStatus())) continue;
            throw new BusinessException("22002", "\u534f\u8bae\u3010" + po.getPlaAgreementCode() + "\u3011\u4e0d\u80fd\u5220\u9664\uff0c\u53ea\u6709\u8349\u7a3f\u3001\u9a73\u56de\u548c\u672a\u63a5\u53d7\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u5220\u9664\uff01");
        }
        for (Long agreementId : busiReqBO.getAgreementIds()) {
            AgrAgreementCodeRelaPO agrAgreementCodeRelaPo;
            AgrAgreementVendorPO agrAgreementVendorPo;
            AgreementPO updateAgreementPO = new AgreementPO();
            updateAgreementPO.setAgreementId(agreementId);
            updateAgreementPO.setUpdateLoginId(busiReqBO.getMemIdIn());
            updateAgreementPO.setUpdateName(busiReqBO.getUserName());
            updateAgreementPO.setUpdateTime(new Date());
            updateAgreementPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
            int isUpdate = this.agreementMapper.deleteByUpdate(updateAgreementPO);
            if (isUpdate < 1) {
                throw new BusinessException("22004", "\u534f\u8bae\u5220\u9664\u5931\u8d25\uff01");
            }
            if (((AgreementPO)agreementPOMap.get(agreementId)).getSignMethod() != null && 2 == ((AgreementPO)agreementPOMap.get(agreementId)).getSignMethod()) {
                if (3 != ((AgreementPO)agreementPOMap.get(agreementId)).getSignType()) continue;
                agrAgreementVendorPo = new AgrAgreementVendorPO();
                agrAgreementVendorPo.setMasterAgreementCode(((AgreementPO)agreementPOMap.get(agreementId)).getPlaAgreementCode());
                if (StringUtils.isNotBlank((CharSequence)agrAgreementVendorPo.getMasterAgreementCode())) {
                    this.agrAgreementVendorMapper.deleteBy(agrAgreementVendorPo);
                }
                agrAgreementCodeRelaPo = new AgrAgreementCodeRelaPO();
                agrAgreementCodeRelaPo.setAgreementCode(((AgreementPO)agreementPOMap.get(agreementId)).getPlaAgreementCode());
                if (!StringUtils.isNotBlank((CharSequence)agrAgreementCodeRelaPo.getAgreementCode())) continue;
                this.agrAgreementCodeRelaMapper.deleteBy(agrAgreementCodeRelaPo);
                continue;
            }
            if (((AgreementPO)agreementPOMap.get(agreementId)).getSignMethod() == null || 3 != ((AgreementPO)agreementPOMap.get(agreementId)).getSignMethod() || 4 != ((AgreementPO)agreementPOMap.get(agreementId)).getSignType()) continue;
            agrAgreementVendorPo = new AgrAgreementVendorPO();
            agrAgreementVendorPo.setMasterAgreementCode(((AgreementPO)agreementPOMap.get(agreementId)).getPlaAgreementCode());
            if (StringUtils.isNotBlank((CharSequence)agrAgreementVendorPo.getMasterAgreementCode())) {
                this.agrAgreementVendorMapper.deleteBy(agrAgreementVendorPo);
            }
            agrAgreementCodeRelaPo = new AgrAgreementCodeRelaPO();
            agrAgreementCodeRelaPo.setAgreementCode(((AgreementPO)agreementPOMap.get(agreementId)).getPlaAgreementCode());
            if (!StringUtils.isNotBlank((CharSequence)agrAgreementCodeRelaPo.getAgreementCode())) continue;
            this.agrAgreementCodeRelaMapper.deleteBy(agrAgreementCodeRelaPo);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u5220\u9664\u6210\u529f\uff01");
        return rsp;
    }
}

