/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.busi.api.AgrUpdateImportLogBusiService;
import com.tydic.agreement.busi.bo.AgrUpdateImportLogBusiReqBO;
import com.tydic.agreement.busi.bo.AgrUpdateImportLogBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuImportLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgrAgreementSkuImportLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.commodity.common.ability.api.UccAgrSkuImportCheckNewAbilityService;
import com.tydic.commodity.common.ability.api.UccCodegenerationAbilityService;
import com.tydic.commodity.common.ability.api.UccMaterialAddAbilityService;
import com.tydic.commodity.common.ability.api.UccMaterialEditAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuTypeQryByNameAbilityService;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportCheckNewAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportCheckNewAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportCheckNewBO;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeDropDownBO;
import com.tydic.commodity.common.ability.bo.UccMaterialEditAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMaterialEditAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.common.ability.bo.UccSpuTypeQryByNameAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuTypeQryByNameAbilityRspBO;
import com.tydic.ppc.ability.api.PpcPurchaseDemandQryListAbilityService;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandQryPageAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandQryPageAbilityRspBO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrUpdateImportLogBusiServiceImpl
implements AgrUpdateImportLogBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrUpdateImportLogBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementSkuImportLogMapper agrAgreementSkuImportLogMapper;
    @Autowired
    private UccSkuManagementListQryAbilityService uccSkuManagementListQryAbilityService;
    @Autowired
    private UccMaterialEditAbilityService uccMaterialEditAbilityService;
    @Autowired
    private UccAgrSkuImportCheckNewAbilityService uccAgrSkuImportCheckNewAbilityService;
    @Autowired
    private UccMaterialAddAbilityService uccMaterialAddAbilityService;
    @Autowired
    private UccCodegenerationAbilityService uccCodegenerationAbilityService;
    @Autowired
    private UccSpuTypeQryByNameAbilityService uccSpuTypeQryByNameAbilityService;
    @Autowired
    private PpcPurchaseDemandQryListAbilityService ppcPurchaseDemandQryListAbilityService;

    @Override
    public AgrUpdateImportLogBusiRspBO updateImportLog(AgrUpdateImportLogBusiReqBO reqBO) {
        AgrUpdateImportLogBusiRspBO rspBO = new AgrUpdateImportLogBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPo = new AgrAgreementSkuImportLogPO();
        agrAgreementSkuImportLogPo.setId(reqBO.getId());
        AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPO = this.agrAgreementSkuImportLogMapper.getModelBy(agrAgreementSkuImportLogPo);
        AgrAgreementSkuImportLogPO set = new AgrAgreementSkuImportLogPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)set);
        set.setCatalogId(reqBO.getCommodityTypeId().toString());
        set.setCatalogName(reqBO.getCommodityTypeName());
        set.setId(reqBO.getId());
        set.setVerifyStatus("1");
        set.setFailReason("");
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)reqBO.getVendorMaterialCode())) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u4f9b\u5e94\u5546\u5546\u54c1\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBrandName())) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u54c1\u724c\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getMeasureName())) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u8ba1\u91cf\u5355\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTaxCatalog())) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (null == reqBO.getSupplyCycle()) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u4f9b\u8d27\u5468\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (null == reqBO.getBuyNumber()) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u6570\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        } else {
            try {
                int number = reqBO.getBuyNumber().intValue();
                if (number <= 0) {
                    sb.append("\u3010\u6570\u91cf\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0\u7684\u6574\u6570;");
                }
            }
            catch (NumberFormatException e) {
                sb.append("\u3010\u6570\u91cf\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0\u7684\u6574\u6570;");
            }
        }
        if (null == reqBO.getSalePrice()) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u9500\u552e\u5355\u4ef7\uff08\u5143\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        } else if (!AgrUpdateImportLogBusiServiceImpl.isValidTwoDecimals(reqBO.getSalePrice().toString())) {
            sb.append("\u3010\u9500\u552e\u5355\u4ef7\uff08\u5143\uff09\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
        }
        if (null == reqBO.getBuyPrice()) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u91c7\u8d2d\u5355\u4ef7\uff08\u5143\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        } else if (!AgrUpdateImportLogBusiServiceImpl.isValidTwoDecimals(reqBO.getBuyPrice().toString())) {
            set.setVerifyStatus("2");
            sb.append("\u3010\u9500\u552e\u5355\u4ef7\uff08\u5143\uff09\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
        }
        if (null == reqBO.getTaxRate()) {
            set.setVerifyStatus("2");
            sb.append("\u5fc5\u586b\u9879\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (null != reqBO.getMarkupRate() && !AgrUpdateImportLogBusiServiceImpl.isValidTwoDecimals(reqBO.getMarkupRate().toString())) {
            set.setVerifyStatus("2");
            sb.append("\u3010\u52a0\u4ef7\u6bd4\u7387\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
        }
        if (null != reqBO.getExtField6() && !AgrUpdateImportLogBusiServiceImpl.isValidTwoDecimals(reqBO.getExtField6().toString())) {
            set.setVerifyStatus("2");
            sb.append("\u3010\u534f\u8bae\u4ef7\u4e0a\u9650\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
        }
        if (null != reqBO.getExtField7() && !AgrUpdateImportLogBusiServiceImpl.isValidTwoDecimals(reqBO.getExtField7().toString())) {
            set.setVerifyStatus("2");
            sb.append("\u3010\u534f\u8bae\u4ef7\u4e0b\u9650\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
        }
        if (null != reqBO.getMarkupAmount() && !AgrUpdateImportLogBusiServiceImpl.isValidTwoDecimals(reqBO.getMarkupAmount().toString())) {
            set.setVerifyStatus("2");
            sb.append("\u3010\u52a0\u4ef7\u91d1\u989d\u3011\u4ec5\u5141\u8bb8\u8f93\u5165\uff1e0.00\uff0c\u6700\u591a\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570;");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseDemandOrderNo())) {
            PpcPurchaseDemandQryPageAbilityReqBO ppcPurchaseDemandQryPageAbilityReqBO = new PpcPurchaseDemandQryPageAbilityReqBO();
            ppcPurchaseDemandQryPageAbilityReqBO.setUserId(Long.valueOf(1L));
            ppcPurchaseDemandQryPageAbilityReqBO.setPurchaseDemandNoAccurate(reqBO.getPurchaseDemandOrderNo());
            PpcPurchaseDemandQryPageAbilityRspBO ppcPurchaseDemandQryPageAbilityRspBO = this.ppcPurchaseDemandQryListAbilityService.queryPurchaseDemandPage(ppcPurchaseDemandQryPageAbilityReqBO);
            if ("0000".equals(ppcPurchaseDemandQryPageAbilityRspBO.getRespCode()) && ppcPurchaseDemandQryPageAbilityRspBO.getRecordsTotal() == 0) {
                sb.append("\u201ce\u8d2d\u91c7\u8d2d\u9700\u6c42\u7f16\u53f7\u201d\u8f93\u5165\u6709\u8bef;");
            }
        }
        if (agreement.getTradeMode() == 2) {
            if (set.getSalePrice().compareTo(set.getBuyPrice()) != 0) {
                set.setVerifyStatus("2");
                sb.append("\u91c7\u8d2d\u5355\u4ef7\u548c\u9500\u552e\u5355\u4ef7\u5e94\u76f8\u540c;");
            }
        } else {
            if (set.getMarkupRate() == null && set.getMarkupAmount() == null) {
                set.setVerifyStatus("2");
                sb.append("\u8d38\u6613\u6a21\u5f0f\u52a0\u4ef7\u91d1\u989d\u548c\u52a0\u4ef7\u6bd4\u7387\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a;");
            } else if (set.getMarkupRate() == null) {
                if (set.getBuyPrice() != null && set.getMarkupAmount() != null && set.getSalePrice() != null) {
                    log.info("buyPrice:" + set.getBuyPrice().add(set.getMarkupAmount()) + "salePrice:" + set.getSalePrice());
                    if (set.getBuyPrice().add(set.getMarkupAmount()).compareTo(set.getSalePrice()) != 0) {
                        set.setVerifyStatus("2");
                        sb.append("\u8d38\u6613\u6a21\u5f0f\u52a0\u4ef7\u6bd4\u7387\u4e3a\u7a7a\u65f6\u201c\u9500\u552e\u5355\u4ef7\u201d = \u201c\u91c7\u8d2d\u5355\u4ef7\u201d + \u201c\u52a0\u4ef7\u91d1\u989d\u201d;");
                    }
                }
            } else if (set.getBuyPrice() != null && set.getMarkupRate() != null && set.getSalePrice() != null) {
                BigDecimal markupRateDecimal = new BigDecimal(set.getMarkupRate()).divide(new BigDecimal("100"));
                BigDecimal salesPrice = set.getBuyPrice().multiply(markupRateDecimal.add(BigDecimal.ONE));
                BigDecimal salePriceWithMarkup = salesPrice.setScale(2, RoundingMode.HALF_UP);
                log.info("salePriceWithMarkup:" + salePriceWithMarkup);
                log.info("SalePrice:" + set.getSalePrice());
                if (salePriceWithMarkup.compareTo(set.getSalePrice()) != 0) {
                    set.setVerifyStatus("2");
                    sb.append("\u8d38\u6613\u6a21\u5f0f\u52a0\u4ef7\u6bd4\u7387\u4e3a\u4e0d\u7a7a\u65f6\u201d\u9500\u552e\u5355\u4ef7\u201d = \u201c\u91c7\u8d2d\u5355\u4ef7\u201d * \uff081 + \u201c\u52a0\u4ef7\u6bd4\u7387\u201d\uff09\uff0c\u56db\u820d\u4e94\u5165\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570;");
                }
            }
            boolean isValid = true;
            if (set.getExtField6() != null) {
                log.info("salePrice:" + set.getSalePrice() + "extField6:" + set.getExtField6());
                if (set.getSalePrice().compareTo(set.getExtField6()) > 0) {
                    set.setVerifyStatus("2");
                    sb.append("\u8d38\u6613\u6a21\u5f0f\u201c\u534f\u8bae\u4ef7\u4e0a\u9650\uff08\u5143\uff09\u201d \u2265 \u201c\u9500\u552e\u5355\u4ef7\u201d \u2265 \u201c\u534f\u8bae\u4ef7\u4e0b\u9650\uff08\u5143\uff09\u201d;");
                    isValid = false;
                }
            }
            if (set.getExtField7() != null && isValid) {
                log.info("salePrice:" + set.getSalePrice() + "extField7:" + set.getExtField7());
                if (set.getSalePrice().compareTo(set.getExtField7()) < 0) {
                    set.setVerifyStatus("2");
                    sb.append("\u8d38\u6613\u6a21\u5f0f\u201c\u534f\u8bae\u4ef7\u4e0a\u9650\uff08\u5143\uff09\u201d \u2265 \u201c\u9500\u552e\u5355\u4ef7\u201d \u2265 \u201c\u534f\u8bae\u4ef7\u4e0b\u9650\uff08\u5143\uff09\u201d;");
                }
            }
        }
        ArrayList<UccAgrSkuImportCheckNewBO> rows = new ArrayList<UccAgrSkuImportCheckNewBO>();
        UccAgrSkuImportCheckNewBO bo = new UccAgrSkuImportCheckNewBO();
        bo.setSerialNumber(Integer.valueOf(1));
        bo.setBrandName(set.getBrandName());
        bo.setMeasureName(set.getMeasureName());
        rows.add(bo);
        UccAgrSkuImportCheckNewAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckNewAbilityReqBO();
        uccAgrSkuImportCheckAbilityReqBO.setRows(rows);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityReqBO));
        UccAgrSkuImportCheckNewAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckNewAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u51fa\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityRspBO));
        if (!"0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            throw new BusinessException("22052", uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
        }
        set.setMeasureId(((UccAgrSkuImportCheckNewBO)uccAgrSkuImportCheckAbilityRspBO.getRows().get(0)).getMeasureId());
        set.setMeasureName(((UccAgrSkuImportCheckNewBO)uccAgrSkuImportCheckAbilityRspBO.getRows().get(0)).getMeasureName());
        set.setBrandId(((UccAgrSkuImportCheckNewBO)uccAgrSkuImportCheckAbilityRspBO.getRows().get(0)).getBrandId());
        set.setBrandName(((UccAgrSkuImportCheckNewBO)uccAgrSkuImportCheckAbilityRspBO.getRows().get(0)).getBrandName());
        if (agrAgreementSkuImportLogPO.getVendorMaterialCode() != null && !agrAgreementSkuImportLogPO.getVendorMaterialCode().equals(reqBO.getVendorMaterialCode())) {
            ArrayList<String> typeNameList = new ArrayList<String>();
            typeNameList.add(reqBO.getCommodityTypeName());
            Map<Object, Object> spuTypeMap = new HashMap();
            if (!CollectionUtils.isEmpty(typeNameList)) {
                UccSpuTypeQryByNameAbilityReqBO uccSpuTypeQryByNameAbilityReqBO = new UccSpuTypeQryByNameAbilityReqBO();
                uccSpuTypeQryByNameAbilityReqBO.setCommdityNameList(typeNameList);
                log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccSpuTypeQryByNameAbilityReqBO));
                UccSpuTypeQryByNameAbilityRspBO abilityRspBO = this.uccSpuTypeQryByNameAbilityService.spuTypeQryByName(uccSpuTypeQryByNameAbilityReqBO);
                log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
                if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getData())) {
                    spuTypeMap = abilityRspBO.getData().stream().collect(Collectors.toMap(UccCommodityTypeDropDownBO::getCatalogName, Function.identity(), (oldValue, newValue) -> newValue));
                }
            }
            log.info("123321123321");
            UccSkuManagementListQryAbilityReqBO uccSkuManagementListQryAbilityReqBO = new UccSkuManagementListQryAbilityReqBO();
            uccSkuManagementListQryAbilityReqBO.setExtSkuId(reqBO.getVendorMaterialCode());
            uccSkuManagementListQryAbilityReqBO.setSupplierShopId(agreement.getVendorId());
            UccSkuManagementListQryAbilityRspBO uccSkuManagementListQryAbilityRspBO = this.uccSkuManagementListQryAbilityService.getSkuManagementListQry(uccSkuManagementListQryAbilityReqBO);
            if ("0000".equals(uccSkuManagementListQryAbilityRspBO.getRespCode())) {
                if (!CollectionUtils.isEmpty((Collection)uccSkuManagementListQryAbilityRspBO.getRows())) {
                    sb.append("\u4f9b\u5e94\u5546\u5546\u54c1\u7f16\u7801\u201d\u5df2\u5b58\u5728;");
                    set.setNeedInsert("2");
                    if (StringUtils.isNotBlank((CharSequence)((UccSkuManagementListQryBO)uccSkuManagementListQryAbilityRspBO.getRows().get(0)).getMaterialCode())) {
                        if (null != ((UccSkuManagementListQryBO)uccSkuManagementListQryAbilityRspBO.getRows().get(0)).getMaterialId()) {
                            set.setMaterialId(((UccSkuManagementListQryBO)uccSkuManagementListQryAbilityRspBO.getRows().get(0)).getMaterialId().toString());
                        }
                        set.setMaterialCode(((UccSkuManagementListQryBO)uccSkuManagementListQryAbilityRspBO.getRows().get(0)).getMaterialCode());
                        set.setMaterialName(((UccSkuManagementListQryBO)uccSkuManagementListQryAbilityRspBO.getRows().get(0)).getMaterialName());
                    } else {
                        this.changeMaterial(agrAgreementSkuImportLogPO, set);
                    }
                } else {
                    this.changeMaterial(agrAgreementSkuImportLogPO, set);
                }
            }
        }
        if ("2".equals(set.getVerifyStatus()) || "2".equals(set.getNeedInsert())) {
            log.info("\u65b0\u589e\u7269\u6599\u4fe1\u606f\u5931\u8d25,\u539f\u56e0:" + sb.toString());
            set.setFailReason(sb.toString());
        }
        set.setCatalogId(set.getCommodityTypeId().toString());
        set.setCatalogName(set.getCatalogName());
        this.agrAgreementSkuImportLogMapper.updateById(set);
        return rspBO;
    }

    @Override
    public AgrUpdateImportLogBusiRspBO confirmAdd(AgrUpdateImportLogBusiReqBO reqBO) {
        AgrUpdateImportLogBusiRspBO rspBO = new AgrUpdateImportLogBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("0000");
        AgrAgreementSkuImportLogPO set = new AgrAgreementSkuImportLogPO();
        set.setNeedInsert("1");
        AgrAgreementSkuImportLogPO where = new AgrAgreementSkuImportLogPO();
        where.setId(reqBO.getId());
        this.agrAgreementSkuImportLogMapper.updateBy(set, where);
        this.agrAgreementSkuImportLogMapper.updateFailReason(where);
        return rspBO;
    }

    private Boolean getDifferences(AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPO, AgrAgreementSkuImportLogPO set) {
        Boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)agrAgreementSkuImportLogPO.getBrandName()) && !agrAgreementSkuImportLogPO.getBrandName().equals(set.getBrandName())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((CharSequence)agrAgreementSkuImportLogPO.getMeasureName()) && !agrAgreementSkuImportLogPO.getMeasureName().equals(set.getMeasureName())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((CharSequence)agrAgreementSkuImportLogPO.getCatalogId()) && !agrAgreementSkuImportLogPO.getCatalogId().equals(set.getCatalogId())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((CharSequence)agrAgreementSkuImportLogPO.getSpec()) && !agrAgreementSkuImportLogPO.getSpec().equals(set.getSpec())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((CharSequence)agrAgreementSkuImportLogPO.getModel()) && !agrAgreementSkuImportLogPO.getModel().equals(set.getModel())) {
            flag = true;
        }
        return flag;
    }

    private void changeMaterial(AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPO, AgrAgreementSkuImportLogPO set) {
        if (this.getDifferences(agrAgreementSkuImportLogPO, set).booleanValue()) {
            UccMaterialEditAbilityReqBO uccMaterialEditAbilityReqBO = new UccMaterialEditAbilityReqBO();
            uccMaterialEditAbilityReqBO.setMaterialId(Long.valueOf(Long.parseLong(agrAgreementSkuImportLogPO.getMaterialId())));
            uccMaterialEditAbilityReqBO.setBrandId(set.getBrandId());
            uccMaterialEditAbilityReqBO.setBrandName(set.getBrandName());
            uccMaterialEditAbilityReqBO.setCataLogId(Long.valueOf(Long.parseLong(set.getCatalogId())));
            uccMaterialEditAbilityReqBO.setCataLogName(set.getCatalogName());
            uccMaterialEditAbilityReqBO.setMaterialCode(agrAgreementSkuImportLogPO.getMaterialCode());
            uccMaterialEditAbilityReqBO.setMaterialName(agrAgreementSkuImportLogPO.getVendorMaterialName());
            uccMaterialEditAbilityReqBO.setMeasure(set.getMeasureName());
            uccMaterialEditAbilityReqBO.setMeasureId(set.getMeasureId());
            uccMaterialEditAbilityReqBO.setModel(set.getModel());
            uccMaterialEditAbilityReqBO.setSpec(set.getSpec());
            UccMaterialEditAbilityRspBO uccMaterialEditAbilityRspBO = this.uccMaterialEditAbilityService.dealUccMaterialEdit(uccMaterialEditAbilityReqBO);
            if (!"0000".equals(uccMaterialEditAbilityRspBO.getRespCode())) {
                throw new BusinessException("22052", uccMaterialEditAbilityRspBO.getRespDesc());
            }
        }
    }

    public static boolean isValidTwoDecimals(String input) {
        String regex = "^\\d+(\\.\\d{1,2})?$";
        if (input.matches(regex)) {
            try {
                double number = Double.parseDouble(input);
                return number > 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

