/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.api.AgrQryCheckScopeByAgreementIdsAbilityService;
import com.tydic.agreement.ability.bo.AgrQryCheckScopeByAgreementIdsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryCheckScopeByAgreementIdsAbilityRspBO;
import com.tydic.agreement.ability.bo.CheckScopeByAgreementIdsBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementCodeRelaMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementCodeRelaPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.umc.general.ability.api.CrcQryCorporationListAbilityService;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrQryCheckScopeByAgreementIdsAbilityService"})
public class AgrQryCheckScopeByAgreementIdsAbilityServiceImpl
implements AgrQryCheckScopeByAgreementIdsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryCheckScopeByAgreementIdsAbilityServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementCodeRelaMapper agrAgreementCodeRelaMapper;
    @Autowired
    private CrcQryCorporationListAbilityService crcQryCorporationListAbilityService;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;

    @PostMapping(value={"qryCheckScopeByAgreementIds"})
    public AgrQryCheckScopeByAgreementIdsAbilityRspBO qryCheckScopeByAgreementIds(@RequestBody AgrQryCheckScopeByAgreementIdsAbilityReqBO reqBO) {
        AgrQryCheckScopeByAgreementIdsAbilityRspBO rspBO = new AgrQryCheckScopeByAgreementIdsAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<CheckScopeByAgreementIdsBO> agreementIdsBOS = new ArrayList<CheckScopeByAgreementIdsBO>();
        CrcQryCorporationListAbilityReqBO abilityReqBO = new CrcQryCorporationListAbilityReqBO();
        abilityReqBO.setLocalOrgId(reqBO.getOrgId());
        CrcQryCorporationListAbilityRspBO abilityRspBO = this.crcQryCorporationListAbilityService.qryCorporationList(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new BusinessException("0105", "\u67e5\u8be2\u4f1a\u5458\u5173\u8054\u91c7\u8d2d\u5355\u4f4d\u5931\u8d25\uff01");
        }
        List<Long> corporationIds = abilityRspBO.getCorPorationBOList().stream().map(corPorationBO -> corPorationBO.getCorporationId()).collect(Collectors.toList());
        UmcQryMemLegalOrgInfoAbilityServiceReqBO umcQryMemLegalOrgInfoAbilityServiceReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setMemId(reqBO.getUserId());
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setSysTenantId(reqBO.getSysTenantId());
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceReqBO));
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcQryMemLegalOrgInfoAbilityServiceReqBO);
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceRspBO));
        if (!"0000".equals(umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespCode())) {
            throw new BusinessException("0101", umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespDesc());
        }
        for (Long agreementId : reqBO.getAgreementIds()) {
            CheckScopeByAgreementIdsBO checkScopeByAgreementIdsBO = new CheckScopeByAgreementIdsBO();
            checkScopeByAgreementIdsBO.setAgreementId(agreementId);
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setAgreementId(agreementId);
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
            if (null == agreement) {
                throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
            }
            if (agreement.getSignMethod() != null && agreement.getSignMethod() != 1) {
                AgrAgreementCodeRelaPO agrAgreementCodeRelaPo = new AgrAgreementCodeRelaPO();
                agrAgreementCodeRelaPo.setAgreementId(agreementId);
                agrAgreementCodeRelaPo.setCodeType(agreement.getSignMethod().toString());
                List<AgrAgreementCodeRelaPO> agrAgreementCodeRelaPOS = this.agrAgreementCodeRelaMapper.getList(agrAgreementCodeRelaPo);
                if (!CollectionUtils.isEmpty(agrAgreementCodeRelaPOS)) {
                    AgreementPO agreementPO1 = new AgreementPO();
                    agreementPO1.setOriginalAgreementCodes(agrAgreementCodeRelaPOS.stream().map(AgrAgreementCodeRelaPO::getAgreementCode).collect(Collectors.toList()));
                    agreementPO1.setAgreementStatus((byte)4);
                    List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO1);
                    if (CollectionUtils.isEmpty(agreementPOS)) {
                        checkScopeByAgreementIdsBO.setStatus(Integer.valueOf(1));
                        agreementIdsBOS.add(checkScopeByAgreementIdsBO);
                        continue;
                    }
                    for (AgreementPO agreementPO2 : agreementPOS) {
                        Integer status = this.getStatus(agreementPO2.getAgreementId(), agreementPO2.getScopeType(), umcQryMemLegalOrgInfoAbilityServiceRspBO, corporationIds);
                        checkScopeByAgreementIdsBO.setStatus(status);
                        if (2 != status) continue;
                        break;
                    }
                    agreementIdsBOS.add(checkScopeByAgreementIdsBO);
                    continue;
                }
                checkScopeByAgreementIdsBO.setStatus(Integer.valueOf(1));
                agreementIdsBOS.add(checkScopeByAgreementIdsBO);
                continue;
            }
            checkScopeByAgreementIdsBO.setStatus(Integer.valueOf(1));
            agreementIdsBOS.add(checkScopeByAgreementIdsBO);
        }
        rspBO.setAgreementIdsBOS(agreementIdsBOS);
        return rspBO;
    }

    private Integer getStatus(Long agreementId, Byte scopeType, UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO, List<Long> corporationIds) {
        Integer status = 3;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setAgreementId(agreementId);
        agreementScopePO.setIsDelete((byte)0);
        List<AgreementScopePO> agreementScopePOList = this.agreementScopeMapper.getList(agreementScopePO);
        block0 : switch (scopeType) {
            case 0: {
                if (umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getSysTenantId().equals(agreementScopePOList.get(0).getScopeCode())) {
                    status = 2;
                    break;
                }
                status = 3;
                break;
            }
            case 2: {
                if (umcQryMemLegalOrgInfoAbilityServiceRspBO.getTwoLevelOrgInfo().getOrgId().equals(agreementScopePOList.get(0).getScopeCode())) {
                    status = 2;
                    break;
                }
                status = 3;
                break;
            }
            case 5: {
                if (CollectionUtils.isEmpty(corporationIds)) break;
                block8: for (Long corporationId : corporationIds) {
                    for (AgreementScopePO scopePO : agreementScopePOList) {
                        if (!corporationId.equals(scopePO.getScopeCode())) continue;
                        status = 2;
                        continue block8;
                    }
                }
                break;
            }
            case 7: {
                for (AgreementScopePO scopePO : agreementScopePOList) {
                    if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getSysTenantId().equals(scopePO.getScopeCode())) continue;
                    status = 2;
                    break block0;
                }
                break;
            }
            case 8: {
                status = 2;
                break;
            }
            case 9: {
                for (AgreementScopePO scopePO : agreementScopePOList) {
                    if (1 == scopePO.getIncludeSubOrg()) {
                        if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getOrgTreePath().contains(scopePO.getScopeCode().toString())) continue;
                        status = 2;
                        break block0;
                    }
                    if (!umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getOrgId().equals(scopePO.getScopeCode())) continue;
                    status = 2;
                    break block0;
                }
                break;
            }
        }
        return status;
    }
}

